/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core.schemabuilder;

import shade.com.datastax.spark.connector.driver.core.schemabuilder.Alter;
import shade.com.datastax.spark.connector.driver.core.schemabuilder.Create;
import shade.com.datastax.spark.connector.driver.core.schemabuilder.CreateIndex;
import shade.com.datastax.spark.connector.driver.core.schemabuilder.CreateType;
import shade.com.datastax.spark.connector.driver.core.schemabuilder.Drop;
import shade.com.datastax.spark.connector.driver.core.schemabuilder.TableOptions;
import shade.com.datastax.spark.connector.driver.core.schemabuilder.UDTType;

public final class SchemaBuilder {
    private SchemaBuilder() {
    }

    public static Create createTable(String tableName) {
        return new Create(tableName);
    }

    public static Create createTable(String keyspaceName, String tableName) {
        return new Create(keyspaceName, tableName);
    }

    public static Alter alterTable(String tableName) {
        return new Alter(tableName);
    }

    public static Alter alterTable(String keyspaceName, String tableName) {
        return new Alter(keyspaceName, tableName);
    }

    public static Drop dropTable(String tableName) {
        return new Drop(tableName, Drop.DroppedItem.TABLE);
    }

    public static Drop dropTable(String keyspaceName, String tableName) {
        return new Drop(keyspaceName, tableName, Drop.DroppedItem.TABLE);
    }

    public static CreateIndex createIndex(String indexName) {
        return new CreateIndex(indexName);
    }

    public static Drop dropIndex(String indexName) {
        return new Drop(indexName, Drop.DroppedItem.INDEX);
    }

    public static Drop dropIndex(String keyspaceName, String indexName) {
        return new Drop(keyspaceName, indexName, Drop.DroppedItem.INDEX);
    }

    public static CreateType createType(String typeName) {
        return new CreateType(typeName);
    }

    public static CreateType createType(String keyspaceName, String typeName) {
        return new CreateType(keyspaceName, typeName);
    }

    public static Drop dropType(String typeName) {
        return new Drop(typeName, Drop.DroppedItem.TYPE);
    }

    public static Drop dropType(String keyspaceName, String typeName) {
        return new Drop(keyspaceName, typeName, Drop.DroppedItem.TYPE);
    }

    public static UDTType frozen(String udtName) {
        return UDTType.frozen(udtName);
    }

    public static UDTType udtLiteral(String literal) {
        return UDTType.literal(literal);
    }

    public static TableOptions.CompactionOptions.SizeTieredCompactionStrategyOptions sizedTieredStategy() {
        return new TableOptions.CompactionOptions.SizeTieredCompactionStrategyOptions();
    }

    public static TableOptions.CompactionOptions.LeveledCompactionStrategyOptions leveledStrategy() {
        return new TableOptions.CompactionOptions.LeveledCompactionStrategyOptions();
    }

    public static TableOptions.CompactionOptions.DateTieredCompactionStrategyOptions dateTieredStrategy() {
        return new TableOptions.CompactionOptions.DateTieredCompactionStrategyOptions();
    }

    public static TableOptions.CompressionOptions noCompression() {
        return new TableOptions.CompressionOptions.NoCompression();
    }

    public static TableOptions.CompressionOptions lz4() {
        return new TableOptions.CompressionOptions(TableOptions.CompressionOptions.Algorithm.LZ4);
    }

    public static TableOptions.CompressionOptions snappy() {
        return new TableOptions.CompressionOptions(TableOptions.CompressionOptions.Algorithm.SNAPPY);
    }

    public static TableOptions.CompressionOptions deflate() {
        return new TableOptions.CompressionOptions(TableOptions.CompressionOptions.Algorithm.DEFLATE);
    }

    public static TableOptions.SpeculativeRetryValue noSpeculativeRetry() {
        return new TableOptions.SpeculativeRetryValue("'NONE'");
    }

    public static TableOptions.SpeculativeRetryValue always() {
        return new TableOptions.SpeculativeRetryValue("'ALWAYS'");
    }

    public static TableOptions.SpeculativeRetryValue percentile(int percentile) {
        if (percentile < 0 || percentile > 100) {
            throw new IllegalArgumentException("Percentile value for speculative retry should be between 0 and 100");
        }
        return new TableOptions.SpeculativeRetryValue("'" + percentile + "percentile'");
    }

    public static TableOptions.SpeculativeRetryValue millisecs(int millisecs) {
        if (millisecs < 0) {
            throw new IllegalArgumentException("Millisecond value for speculative retry should be positive");
        }
        return new TableOptions.SpeculativeRetryValue("'" + millisecs + "ms'");
    }

    public static TableOptions.CachingRowsPerPartition noRows() {
        return new TableOptions.CachingRowsPerPartition("'none'");
    }

    public static TableOptions.CachingRowsPerPartition allRows() {
        return new TableOptions.CachingRowsPerPartition("'all'");
    }

    public static TableOptions.CachingRowsPerPartition rows(int rowNumber) {
        if (rowNumber <= 0) {
            throw new IllegalArgumentException("rows number for caching should be strictly positive");
        }
        return new TableOptions.CachingRowsPerPartition(Integer.toString(rowNumber));
    }

    public static enum KeyCaching {
        ALL("'all'"),
        NONE("'none'");

        private String value;

        private KeyCaching(String value2) {
            this.value = value2;
        }

        String value() {
            return this.value;
        }
    }

    public static enum Caching {
        ALL("'all'"),
        KEYS_ONLY("'keys_only'"),
        ROWS_ONLY("'rows_only'"),
        NONE("'none'");

        private String value;

        private Caching(String value2) {
            this.value = value2;
        }

        String value() {
            return this.value;
        }
    }

    public static enum Direction {
        ASC,
        DESC;

    }
}

