/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import scala.reflect.ScalaSignature;
import shade.com.datastax.spark.connector.driver.core.Cluster;
import shade.com.datastax.spark.connector.driver.core.ConsistencyLevel;
import shade.com.datastax.spark.connector.driver.core.Statement;
import shade.com.datastax.spark.connector.driver.core.WriteType;
import shade.com.datastax.spark.connector.driver.core.exceptions.DriverException;
import shade.com.datastax.spark.connector.driver.core.policies.RetryPolicy;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001B\u0001\u0003\u00015\u00111#T;mi&\u0004H.\u001a*fiJL\bk\u001c7jGfT!a\u0001\u0003\u0002\u0007\r\fHN\u0003\u0002\u0006\r\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\u0011\u0011\fG/Y:uCbT\u0011aC\u0001\u0004G>l7\u0001A\n\u0004\u000191\u0002CA\b\u0015\u001b\u0005\u0001\"BA\t\u0013\u0003\u0011a\u0017M\\4\u000b\u0003M\tAA[1wC&\u0011Q\u0003\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005]qR\"\u0001\r\u000b\u0005eQ\u0012\u0001\u00039pY&\u001c\u0017.Z:\u000b\u0005ma\u0012\u0001B2pe\u0016T!!\b\u0005\u0002\r\u0011\u0014\u0018N^3s\u0013\ty\u0002DA\u0006SKR\u0014\u0018\u0010U8mS\u000eL\b\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\u0002\u001b5\f\u0007PU3uef\u001cu.\u001e8u!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\rIe\u000e\u001e\u0005\u0006S\u0001!\tAK\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005-j\u0003C\u0001\u0017\u0001\u001b\u0005\u0011\u0001\"B\u0011)\u0001\u0004\u0011\u0003\"B\u0018\u0001\t\u0013\u0001\u0014!\u0006:fiJLX*\u00198z)&lWm](s)\"\u0014xn\u001e\u000b\u0003c\u0015\u0003\"A\r\"\u000f\u0005M\u0002eB\u0001\u001b@\u001d\t)dH\u0004\u00027{9\u0011q\u0007\u0010\b\u0003qmj\u0011!\u000f\u0006\u0003u1\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011BA\u000f\t\u0013\tYB$\u0003\u0002\u001a5%\u0011\u0011\tG\u0001\f%\u0016$(/\u001f)pY&\u001c\u00170\u0003\u0002D\t\ni!+\u001a;ss\u0012+7-[:j_:T!!\u0011\r\t\u000b\u0019s\u0003\u0019\u0001\u0012\u0002\u000f9\u0014'+\u001a;ss\")\u0001\n\u0001C\u0005\u0013\u0006\u0001\"/\u001a;ss>s7-Z(s)\"\u0014xn\u001e\u000b\u0003c)CQAR$A\u0002\tBQ\u0001\u0014\u0001\u0005B5\u000bA!\u001b8jiR\u0011a*\u0015\t\u0003G=K!\u0001\u0015\u0013\u0003\tUs\u0017\u000e\u001e\u0005\u0006%.\u0003\raU\u0001\bG2,8\u000f^3s!\t!V+D\u0001\u001b\u0013\t1&DA\u0004DYV\u001cH/\u001a:\t\u000ba\u0003A\u0011I-\u0002\u000b\rdwn]3\u0015\u00039CQa\u0017\u0001\u0005Bq\u000bQb\u001c8SK\u0006$G+[7f_V$HcB\u0019^E\u001eL7\u000e\u001d\u0005\u0006=j\u0003\raX\u0001\u0005gRlG\u000f\u0005\u0002UA&\u0011\u0011M\u0007\u0002\n'R\fG/Z7f]RDQa\u0019.A\u0002\u0011\f!a\u00197\u0011\u0005Q+\u0017B\u00014\u001b\u0005A\u0019uN\\:jgR,gnY=MKZ,G\u000eC\u0003i5\u0002\u0007!%A\tsKF,\u0018N]3e%\u0016\u001c\bo\u001c8tKNDQA\u001b.A\u0002\t\n\u0011C]3dK&4X\r\u001a*fgB|gn]3t\u0011\u0015a'\f1\u0001n\u00035!\u0017\r^1SKR\u0014\u0018.\u001a<fIB\u00111E\\\u0005\u0003_\u0012\u0012qAQ8pY\u0016\fg\u000eC\u0003G5\u0002\u0007!\u0005C\u0003s\u0001\u0011\u00053/\u0001\bp]J+\u0017/^3ti\u0016\u0013(o\u001c:\u0015\u000bE\"XO\u001e@\t\u000by\u000b\b\u0019A0\t\u000b\r\f\b\u0019\u00013\t\u000b]\f\b\u0019\u0001=\u0002\u0005\u0015D\bCA=}\u001b\u0005Q(BA>\u001b\u0003))\u0007pY3qi&|gn]\u0005\u0003{j\u0014q\u0002\u0012:jm\u0016\u0014X\t_2faRLwN\u001c\u0005\u0006\rF\u0004\rA\t\u0005\b\u0003\u0003\u0001A\u0011IA\u0002\u00039ygn\u0016:ji\u0016$\u0016.\\3pkR$R\"MA\u0003\u0003\u000f\tI!a\u0005\u0002\u0018\u0005m\u0001\"\u00020\u0000\u0001\u0004y\u0006\"B2\u0000\u0001\u0004!\u0007bBA\u0006\u007f\u0002\u0007\u0011QB\u0001\noJLG/\u001a+za\u0016\u00042\u0001VA\b\u0013\r\t\tB\u0007\u0002\n/JLG/\u001a+za\u0016Da!!\u0006\u0000\u0001\u0004\u0011\u0013\u0001\u0004:fcVL'/\u001a3BG.\u001c\bBBA\r\u007f\u0002\u0007!%\u0001\u0007sK\u000e,\u0017N^3e\u0003\u000e\\7\u000fC\u0003G\u007f\u0002\u0007!\u0005C\u0004\u0002 \u0001!\t%!\t\u0002\u001b=tWK\\1wC&d\u0017M\u00197f)-\t\u00141EA\u0013\u0003O\tY#a\f\t\ry\u000bi\u00021\u0001`\u0011\u0019\u0019\u0017Q\u0004a\u0001I\"9\u0011\u0011FA\u000f\u0001\u0004\u0011\u0013a\u0004:fcVL'/\u001a3SKBd\u0017nY1\t\u000f\u00055\u0012Q\u0004a\u0001E\u0005a\u0011\r\\5wKJ+\u0007\u000f\\5dC\"1a)!\bA\u0002\t\u0002")
public class MultipleRetryPolicy
implements RetryPolicy {
    private final int maxRetryCount;

    private RetryPolicy.RetryDecision retryManyTimesOrThrow(int nbRetry) {
        RetryPolicy.RetryDecision retryDecision;
        int n = this.maxRetryCount;
        switch (n) {
            default: {
                if (nbRetry < n) {
                    retryDecision = RetryPolicy.RetryDecision.retry(null);
                    break;
                }
                retryDecision = RetryPolicy.RetryDecision.rethrow();
                break;
            }
            case -1: {
                retryDecision = RetryPolicy.RetryDecision.retry(null);
            }
        }
        return retryDecision;
    }

    private RetryPolicy.RetryDecision retryOnceOrThrow(int nbRetry) {
        return nbRetry == 0 ? RetryPolicy.RetryDecision.retry(null) : RetryPolicy.RetryDecision.rethrow();
    }

    @Override
    public void init(Cluster cluster) {
    }

    @Override
    public void close() {
    }

    @Override
    public RetryPolicy.RetryDecision onReadTimeout(Statement stmt, ConsistencyLevel cl, int requiredResponses, int receivedResponses, boolean dataRetrieved, int nbRetry) {
        return this.retryManyTimesOrThrow(nbRetry);
    }

    @Override
    public RetryPolicy.RetryDecision onRequestError(Statement stmt, ConsistencyLevel cl, DriverException ex, int nbRetry) {
        return RetryPolicy.RetryDecision.rethrow();
    }

    @Override
    public RetryPolicy.RetryDecision onWriteTimeout(Statement stmt, ConsistencyLevel cl, WriteType writeType, int requiredAcks, int receivedAcks, int nbRetry) {
        return this.retryManyTimesOrThrow(nbRetry);
    }

    @Override
    public RetryPolicy.RetryDecision onUnavailable(Statement stmt, ConsistencyLevel cl, int requiredReplica, int aliveReplica, int nbRetry) {
        return this.retryManyTimesOrThrow(nbRetry);
    }

    public MultipleRetryPolicy(int maxRetryCount) {
        this.maxRetryCount = maxRetryCount;
    }
}

