/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd;

import com.datastax.spark.connector.AllColumns$;
import com.datastax.spark.connector.CassandraRowMetadata;
import com.datastax.spark.connector.CassandraRowMetadata$;
import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.PartitionKeyColumns$;
import com.datastax.spark.connector.SomeColumns;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.package$;
import com.datastax.spark.connector.rdd.AbstractCassandraJoin;
import com.datastax.spark.connector.rdd.AbstractCassandraJoin$;
import com.datastax.spark.connector.rdd.CassandraLimit$;
import com.datastax.spark.connector.rdd.CassandraRDD;
import com.datastax.spark.connector.rdd.CassandraTableRowReaderProvider;
import com.datastax.spark.connector.rdd.ClusteringOrder;
import com.datastax.spark.connector.rdd.EmptyCassandraRDD;
import com.datastax.spark.connector.util.CountingIterator;
import com.datastax.spark.connector.util.CqlWhereParser;
import com.datastax.spark.connector.util.CqlWhereParser$;
import com.datastax.spark.connector.util.Quote$;
import com.datastax.spark.connector.writer.BoundStatementBuilder;
import com.datastax.spark.connector.writer.BoundStatementBuilder$;
import com.datastax.spark.connector.writer.RowWriter;
import com.datastax.spark.connector.writer.RowWriterFactory;
import java.util.concurrent.Future;
import org.apache.spark.Partition;
import org.apache.spark.TaskContext;
import org.apache.spark.metrics.InputMetricsUpdater;
import org.apache.spark.metrics.InputMetricsUpdater$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import shade.com.datastax.spark.connector.driver.core.PreparedId;
import shade.com.datastax.spark.connector.driver.core.PreparedStatement;
import shade.com.datastax.spark.connector.driver.core.ProtocolVersion;
import shade.com.datastax.spark.connector.driver.core.Session;

public abstract class AbstractCassandraJoin$class {
    public static RowWriter rowWriter(CassandraRDD $this) {
        Option option;
        block4: {
            RowWriter rowWriter;
            block3: {
                block2: {
                    RowWriter _rowWriter;
                    option = ((AbstractCassandraJoin)((Object)$this)).manualRowWriter();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    rowWriter = _rowWriter = (RowWriter)some.x();
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                rowWriter = ((RowWriterFactory)Predef$.MODULE$.implicitly(((AbstractCassandraJoin)((Object)$this)).rowWriterFactory())).rowWriter(((CassandraTableRowReaderProvider)((Object)$this)).tableDef(), (IndexedSeq<ColumnRef>)((AbstractCassandraJoin)((Object)$this)).joinColumnNames().toIndexedSeq());
            }
            return rowWriter;
        }
        throw new MatchError(option);
    }

    public static Seq joinColumnNames(CassandraRDD $this) {
        ColumnSelector columnSelector;
        block6: {
            Seq seq;
            block5: {
                block4: {
                    columnSelector = ((AbstractCassandraJoin)((Object)$this)).joinColumns();
                    if (AllColumns$.MODULE$.equals(columnSelector)) {
                        throw new IllegalArgumentException("Unable to join against all columns in a Cassandra Table. Only primary key columns allowed.");
                    }
                    if (!PartitionKeyColumns$.MODULE$.equals(columnSelector)) break block4;
                    seq = (Seq)((CassandraTableRowReaderProvider)((Object)$this)).tableDef().partitionKey().map((Function1)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final ColumnRef apply(ColumnDef col) {
                            return package$.MODULE$.toNamedColumnRef(col.columnName());
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    break block5;
                }
                if (!(columnSelector instanceof SomeColumns)) break block6;
                SomeColumns someColumns = (SomeColumns)columnSelector;
                Seq<ColumnRef> cs = someColumns.columns();
                ((CassandraTableRowReaderProvider)((Object)$this)).checkColumnsExistence(cs);
                seq = (Seq)cs.map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final ColumnRef apply(ColumnRef x0$1) {
                        ColumnRef columnRef = x0$1;
                        if (columnRef != null) {
                            ColumnRef columnRef2;
                            ColumnRef columnRef3 = columnRef2 = columnRef;
                            return columnRef3;
                        }
                        throw new IllegalArgumentException("Unable to join against unnamed columns. No CQL Functions allowed.");
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            return seq;
        }
        throw new MatchError((Object)columnSelector);
    }

    /*
     * WARNING - void declaration
     */
    public static Seq checkValidJoin(CassandraRDD $this) {
        void var4_4;
        Set partitionKeyColumnNames = ((TraversableOnce)((CassandraTableRowReaderProvider)((Object)$this)).tableDef().partitionKey().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnDef x$1) {
                return x$1.columnName();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        Set primaryKeyColumnNames = ((TraversableOnce)((CassandraTableRowReaderProvider)((Object)$this)).tableDef().primaryKey().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnDef x$2) {
                return x$2.columnName();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        Set colNames = ((TraversableOnce)((AbstractCassandraJoin)((Object)$this)).joinColumnNames().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnRef x$3) {
                return x$3.columnName();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        ((AbstractCassandraJoin)((Object)$this)).rowWriter().columnNames();
        ((AbstractCassandraJoin)((Object)$this)).singleKeyCqlQuery().length();
        Seq chosenClusteringColumns = (Seq)((CassandraTableRowReaderProvider)((Object)$this)).tableDef().clusteringColumns().filter((Function1)new Serializable($this, colNames){
            public static final long serialVersionUID = 0L;
            private final Set colNames$1;

            public final boolean apply(ColumnDef cc) {
                return this.colNames$1.contains((Object)cc.columnName());
            }
            {
                this.colNames$1 = colNames$1;
            }
        });
        if (((CassandraTableRowReaderProvider)((Object)$this)).tableDef().clusteringColumns().startsWith((GenSeq)chosenClusteringColumns)) {
            Set missingPartitionKeys = (Set)partitionKeyColumnNames.$minus$minus((GenTraversableOnce)colNames);
            Predef$.MODULE$.require(missingPartitionKeys.isEmpty(), (Function0)new Serializable($this, missingPartitionKeys){
                public static final long serialVersionUID = 0L;
                private final Set missingPartitionKeys$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't join without the full partition key. Missing: [ ", " ]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.missingPartitionKeys$1}));
                }
                {
                    this.missingPartitionKeys$1 = missingPartitionKeys$1;
                }
            });
            ((AbstractCassandraJoin)((Object)$this)).joinColumnNames().foreach((Function1)new Serializable($this, primaryKeyColumnNames){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CassandraRDD $outer;
                private final Set primaryKeyColumnNames$1;

                public final void apply(ColumnRef column) {
                    AbstractCassandraJoin$class.checkSingleColumn$1(this.$outer, column, this.primaryKeyColumnNames$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.primaryKeyColumnNames$1 = primaryKeyColumnNames$1;
                }
            });
            return ((AbstractCassandraJoin)((Object)$this)).joinColumnNames();
        }
        ColumnDef maxCol = (ColumnDef)var4_4.last();
        int maxIndex = BoxesRunTime.unboxToInt((Object)maxCol.componentIndex().get());
        Seq requiredColumns2 = (Seq)((CassandraTableRowReaderProvider)((Object)$this)).tableDef().clusteringColumns().takeWhile((Function1)new Serializable($this, maxIndex){
            public static final long serialVersionUID = 0L;
            private final int maxIndex$1;

            public final boolean apply(ColumnDef x$4) {
                return BoxesRunTime.unboxToInt((Object)x$4.componentIndex().get()) <= this.maxIndex$1;
            }
            {
                this.maxIndex$1 = maxIndex$1;
            }
        });
        Set missingColumns2 = (Set)requiredColumns2.toSet().$minus$minus((GenTraversableOnce)var4_4.toSet());
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't pushdown join on column ", " without also specifying [ ", " ]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{maxCol, missingColumns2})));
    }

    public static String singleKeyCqlQuery(CassandraRDD $this) {
        Seq whereClauses = (Seq)$this.where().predicates().flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Seq<CqlWhereParser.Predicate> apply(String cqlWhere) {
                return CqlWhereParser$.MODULE$.parse(cqlWhere);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq joinColumns = (Seq)((AbstractCassandraJoin)((Object)$this)).joinColumnNames().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnRef x$5) {
                return x$5.columnName();
            }
        }, Seq$.MODULE$.canBuildFrom());
        Set joinColumnPredicates = ((TraversableOnce)whereClauses.collect((PartialFunction)new Serializable($this, joinColumns){
            public static final long serialVersionUID = 0L;
            private final Seq joinColumns$1;

            public final <A1 extends CqlWhereParser.Predicate, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                CqlWhereParser.RangePredicate rangePredicate;
                String c;
                CqlWhereParser.InListPredicate inListPredicate;
                String c2;
                CqlWhereParser.InPredicate inPredicate;
                String c3;
                CqlWhereParser.EqPredicate eqPredicate;
                String c4;
                A1 A1 = x1;
                Object object = A1 instanceof CqlWhereParser.EqPredicate && this.joinColumns$1.contains((Object)(c4 = (eqPredicate = (CqlWhereParser.EqPredicate)A1).columnName())) ? c4 : (A1 instanceof CqlWhereParser.InPredicate && this.joinColumns$1.contains((Object)(c3 = (inPredicate = (CqlWhereParser.InPredicate)A1).columnName())) ? c3 : (A1 instanceof CqlWhereParser.InListPredicate && this.joinColumns$1.contains((Object)(c2 = (inListPredicate = (CqlWhereParser.InListPredicate)A1).columnName())) ? c2 : (A1 instanceof CqlWhereParser.RangePredicate && this.joinColumns$1.contains((Object)(c = (rangePredicate = (CqlWhereParser.RangePredicate)A1).columnName())) ? c : function1.apply(x1))));
                return (B1)object;
            }

            public final boolean isDefinedAt(CqlWhereParser.Predicate x1) {
                CqlWhereParser.RangePredicate rangePredicate;
                String c;
                CqlWhereParser.InListPredicate inListPredicate;
                String c2;
                CqlWhereParser.InPredicate inPredicate;
                String c3;
                CqlWhereParser.EqPredicate eqPredicate;
                String c4;
                CqlWhereParser.Predicate predicate2 = x1;
                boolean bl = predicate2 instanceof CqlWhereParser.EqPredicate && this.joinColumns$1.contains((Object)(c4 = (eqPredicate = (CqlWhereParser.EqPredicate)predicate2).columnName())) ? true : (predicate2 instanceof CqlWhereParser.InPredicate && this.joinColumns$1.contains((Object)(c3 = (inPredicate = (CqlWhereParser.InPredicate)predicate2).columnName())) ? true : (predicate2 instanceof CqlWhereParser.InListPredicate && this.joinColumns$1.contains((Object)(c2 = (inListPredicate = (CqlWhereParser.InListPredicate)predicate2).columnName())) ? true : predicate2 instanceof CqlWhereParser.RangePredicate && this.joinColumns$1.contains((Object)(c = (rangePredicate = (CqlWhereParser.RangePredicate)predicate2).columnName()))));
                return bl;
            }
            {
                this.joinColumns$1 = joinColumns$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        Predef$.MODULE$.require(joinColumnPredicates.isEmpty(), (Function0)new Serializable($this, joinColumnPredicates){
            public static final long serialVersionUID = 0L;
            private final Set joinColumnPredicates$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Columns specified in both the join on clause and the where clause.\n         |Partition key columns are always part of the join clause.\n         |Columns in both: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.joinColumnPredicates$1.mkString(", ")})))).stripMargin();
            }
            {
                this.joinColumnPredicates$1 = joinColumnPredicates$1;
            }
        });
        $this.logDebug((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Generating Single Key Query Prepared Statement String";
            }
        });
        $this.logDebug((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraRDD $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SelectedColumns : ", " -- JoinColumnNames : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((CassandraTableRowReaderProvider)((Object)this.$outer)).selectedColumnRefs(), ((AbstractCassandraJoin)((Object)this.$outer)).joinColumnNames()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        String columns = ((TraversableOnce)((CassandraTableRowReaderProvider)((Object)$this)).selectedColumnRefs().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnRef x$6) {
                return x$6.cql();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", ");
        Seq joinWhere = (Seq)((TraversableLike)((AbstractCassandraJoin)((Object)$this)).joinColumnNames().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnRef x$7) {
                return x$7.columnName();
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String name) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " = :", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Quote$.MODULE$.quote(name), name}));
            }
        }, Seq$.MODULE$.canBuildFrom());
        String limitClause = CassandraLimit$.MODULE$.limitToClause($this.limit());
        String orderBy = (String)$this.clusteringOrder().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraRDD $outer;

            public final String apply(ClusteringOrder x$8) {
                return x$8.toCql(((CassandraTableRowReaderProvider)((Object)this.$outer)).tableDef());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        String filter = ((TraversableOnce)$this.where().predicates().$plus$plus((GenTraversableOnce)joinWhere, Seq$.MODULE$.canBuildFrom())).mkString(" AND ");
        String quotedKeyspaceName = Quote$.MODULE$.quote(((CassandraTableRowReaderProvider)((Object)$this)).keyspaceName());
        String quotedTableName = Quote$.MODULE$.quote(((CassandraTableRowReaderProvider)((Object)$this)).tableName());
        String query = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{columns}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FROM ", ".", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{quotedKeyspaceName, quotedTableName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WHERE ", " ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filter, orderBy, limitClause}))).toString();
        $this.logDebug((Function0)new Serializable($this, query){
            public static final long serialVersionUID = 0L;
            private final String query$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Query : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.query$1}));
            }
            {
                this.query$1 = query$1;
            }
        });
        return query;
    }

    private static PreparedStatement getPreparedStatement(CassandraRDD $this, Session session) {
        return session.prepare(((AbstractCassandraJoin)((Object)$this)).singleKeyCqlQuery()).setConsistencyLevel(((CassandraTableRowReaderProvider)((Object)$this)).consistencyLevel()).setIdempotent(Predef$.MODULE$.boolean2Boolean(true));
    }

    private static CassandraRowMetadata getCassandraRowMetadata(CassandraRDD $this, Session session) {
        scala.collection.immutable.IndexedSeq columnNames2 = ((TraversableOnce)((CassandraTableRowReaderProvider)((Object)$this)).selectedColumnRefs().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnRef x$9) {
                return x$9.selectedAs();
            }
        }, Seq$.MODULE$.canBuildFrom())).toIndexedSeq();
        PreparedId id = AbstractCassandraJoin$class.getPreparedStatement((CassandraRDD)((Object)((AbstractCassandraJoin)((Object)$this))), session).getPreparedId();
        return CassandraRowMetadata$.MODULE$.fromPreparedId((IndexedSeq<String>)columnNames2, id);
    }

    public static BoundStatementBuilder boundStatementBuilder(CassandraRDD $this, Session session) {
        ProtocolVersion protocolVersion2 = session.getCluster().getConfiguration().getProtocolOptions().getProtocolVersion();
        PreparedStatement stmt = AbstractCassandraJoin$class.getPreparedStatement((CassandraRDD)((Object)((AbstractCassandraJoin)((Object)$this))), session);
        RowWriter x$14 = ((AbstractCassandraJoin)((Object)$this)).rowWriter();
        PreparedStatement x$15 = stmt;
        Seq<Object> x$16 = $this.where().values();
        ProtocolVersion x$17 = protocolVersion2;
        boolean x$18 = BoundStatementBuilder$.MODULE$.$lessinit$greater$default$4();
        return new BoundStatementBuilder(x$14, x$15, x$16, x$18, x$17);
    }

    public static Iterator compute(CassandraRDD $this, Partition split2, TaskContext context) {
        Session session = ((CassandraTableRowReaderProvider)((Object)$this)).connector().openSession();
        BoundStatementBuilder bsb = ((AbstractCassandraJoin)((Object)$this)).boundStatementBuilder(session);
        CassandraRowMetadata rowMetadata = AbstractCassandraJoin$class.getCassandraRowMetadata((CassandraRDD)((Object)((AbstractCassandraJoin)((Object)$this))), session);
        InputMetricsUpdater metricsUpdater = InputMetricsUpdater$.MODULE$.apply(context, ((CassandraTableRowReaderProvider)((Object)$this)).readConf(), InputMetricsUpdater$.MODULE$.apply$default$3());
        Iterator rowIterator = ((AbstractCassandraJoin)((Object)$this)).fetchIterator(session, bsb, rowMetadata, ((AbstractCassandraJoin)((Object)$this)).left().iterator(split2, context));
        CountingIterator countingIterator = new CountingIterator(rowIterator, (Option<Object>)None$.MODULE$);
        context.addTaskCompletionListener((Function1)new Serializable($this, session, metricsUpdater, countingIterator, split2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraRDD $outer;
            private final Session session$1;
            private final InputMetricsUpdater metricsUpdater$1;
            public final CountingIterator countingIterator$1;
            public final Partition split$1;

            public final void apply(TaskContext context) {
                double duration = (double)this.metricsUpdater$1.finish() / 1.0E9;
                this.$outer.logDebug((Function0)new Serializable(this, duration){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ AbstractCassandraJoin$.anonfun.compute.1 $outer;
                    private final double duration$1;

                    public final String apply() {
                        Integer arg$macro$1 = BoxesRunTime.boxToInteger((int)this.$outer.countingIterator$1.count());
                        String arg$macro$2 = ((CassandraTableRowReaderProvider)((Object)this.$outer.com$datastax$spark$connector$rdd$AbstractCassandraJoin$$anonfun$$$outer())).keyspaceName();
                        String arg$macro$3 = ((CassandraTableRowReaderProvider)((Object)this.$outer.com$datastax$spark$connector$rdd$AbstractCassandraJoin$$anonfun$$$outer())).tableName();
                        Integer arg$macro$4 = BoxesRunTime.boxToInteger((int)this.$outer.split$1.index());
                        double arg$macro$5 = this.duration$1;
                        return new StringBuilder().append((Object)new StringOps("Fetched %s rows ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1}))).append((Object)new StringOps("from %s.%s ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$2, arg$macro$3}))).append((Object)new StringOps("for partition %s in %.3f s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$4, BoxesRunTime.boxToDouble((double)arg$macro$5)}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.duration$1 = duration$1;
                    }
                });
                this.session$1.close();
            }

            public /* synthetic */ CassandraRDD com$datastax$spark$connector$rdd$AbstractCassandraJoin$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                void var5_5;
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.session$1 = session$1;
                this.metricsUpdater$1 = var3_3;
                this.countingIterator$1 = var4_4;
                this.split$1 = var5_5;
            }
        });
        return countingIterator;
    }

    public static Partition[] getPartitions(CassandraRDD $this) {
        ((CassandraTableRowReaderProvider)((Object)$this)).verify();
        ((AbstractCassandraJoin)((Object)$this)).checkValidJoin();
        return ((AbstractCassandraJoin)((Object)$this)).left().partitions();
    }

    public static Seq getPreferredLocations(CassandraRDD $this, Partition split2) {
        return ((AbstractCassandraJoin)((Object)$this)).left().preferredLocations(split2);
    }

    public static EmptyCassandraRDD toEmptyCassandraRDD(CassandraRDD $this) {
        return new EmptyCassandraRDD(((AbstractCassandraJoin)((Object)$this)).left().sparkContext(), ((CassandraTableRowReaderProvider)((Object)$this)).keyspaceName(), ((CassandraTableRowReaderProvider)((Object)$this)).tableName(), ((CassandraTableRowReaderProvider)((Object)$this)).columnNames(), $this.where(), $this.limit(), $this.clusteringOrder(), ((CassandraTableRowReaderProvider)((Object)$this)).readConf(), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public static Iterator slidingPrefetchIterator(CassandraRDD $this, Iterator it, int batchSize) {
        int x$20;
        int x$19;
        Iterator.GroupedIterator qual$1 = it.grouped(batchSize);
        Tuple2 tuple2 = qual$1.sliding(x$19 = 2, x$20 = qual$1.sliding$default$2()).span((Function1)new Serializable($this, it){
            public static final long serialVersionUID = 0L;
            private final Iterator it$1;

            public final boolean apply(Seq<Seq<Future<T>>> x$10) {
                return this.it$1.hasNext();
            }
            {
                this.it$1 = it$1;
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            Iterator firstElements = (Iterator)tuple2._1();
            Iterator lastElement = (Iterator)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)firstElements, (Object)lastElement);
            Iterator firstElements2 = (Iterator)tuple23._1();
            Iterator lastElement2 = (Iterator)tuple23._2();
            return TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)firstElements2.map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final Seq<Future<T>> apply(Seq<Seq<Future<T>>> x$12) {
                    return (Seq)x$12.head();
                }
            }).$plus$plus((Function0)new Serializable($this, lastElement2){
                public static final long serialVersionUID = 0L;
                private final Iterator lastElement$1;

                public final Iterator<Seq<Future<T>>> apply() {
                    return TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)this.lastElement$1, (Function1)Predef$.MODULE$.$conforms()).flatten();
                }
                {
                    this.lastElement$1 = lastElement$1;
                }
            }), (Function1)Predef$.MODULE$.$conforms()).flatten().map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final T apply(Future<T> x$13) {
                    return x$13.get();
                }
            });
        }
        throw new MatchError((Object)tuple2);
    }

    public static final void checkSingleColumn$1(CassandraRDD $this, ColumnRef column, Set primaryKeyColumnNames$1) {
        Predef$.MODULE$.require(primaryKeyColumnNames$1.contains((Object)column.columnName()), (Function0)new Serializable($this, column){
            public static final long serialVersionUID = 0L;
            private final ColumnRef column$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't pushdown join on column ", " because it is not part of the PRIMARY KEY"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.column$1}));
            }
            {
                this.column$1 = column$1;
            }
        });
    }

    public static void $init$(CassandraRDD $this) {
    }
}

