/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd;

import com.datastax.spark.connector.rdd.ReadConf;
import com.datastax.spark.connector.util.ConfigCheck$;
import com.datastax.spark.connector.util.ConfigParameter;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.util.Logging$class;
import org.apache.spark.SparkConf;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple7;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import shade.com.datastax.spark.connector.driver.core.ConsistencyLevel;

public final class ReadConf$
implements Logging,
Serializable {
    public static final ReadConf$ MODULE$;
    private final String ReferenceSection;
    private final ConfigParameter<Option<Object>> SplitCountParam;
    private final ConfigParameter<Object> SplitSizeInMBParam;
    private final ConfigParameter<Object> FetchSizeInRowsParam;
    private final ConfigParameter<ConsistencyLevel> ConsistencyLevelParam;
    private final ConfigParameter<Object> TaskMetricParam;
    private final ConfigParameter<Object> ThroughputJoinQueryPerSecParam;
    private final ConfigParameter<Object> ParallelismLevelParam;
    private final ConfigParameter<Object> ReadsPerSecParam;
    private final Set<ConfigParameter<? super Object>> Properties;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    static {
        new ReadConf$();
    }

    @Override
    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    @Override
    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public String ReferenceSection() {
        return this.ReferenceSection;
    }

    public ConfigParameter<Option<Object>> SplitCountParam() {
        return this.SplitCountParam;
    }

    public ConfigParameter<Object> SplitSizeInMBParam() {
        return this.SplitSizeInMBParam;
    }

    public ConfigParameter<Object> FetchSizeInRowsParam() {
        return this.FetchSizeInRowsParam;
    }

    public ConfigParameter<ConsistencyLevel> ConsistencyLevelParam() {
        return this.ConsistencyLevelParam;
    }

    public ConfigParameter<Object> TaskMetricParam() {
        return this.TaskMetricParam;
    }

    public ConfigParameter<Object> ThroughputJoinQueryPerSecParam() {
        return this.ThroughputJoinQueryPerSecParam;
    }

    public ConfigParameter<Object> ParallelismLevelParam() {
        return this.ParallelismLevelParam;
    }

    public ConfigParameter<Object> ReadsPerSecParam() {
        return this.ReadsPerSecParam;
    }

    public Set<ConfigParameter<? super Object>> Properties() {
        return this.Properties;
    }

    public ReadConf fromSparkConf(SparkConf conf) {
        ConfigCheck$.MODULE$.checkConfig(conf);
        Option throughtputJoinQueryPerSec = conf.getOption(this.ThroughputJoinQueryPerSecParam().name()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String str2) {
                int n;
                ReadConf$.MODULE$.logWarning((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is deprecated\n             | please use ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ReadConf$.MODULE$.ThroughputJoinQueryPerSecParam().name(), ReadConf$.MODULE$.ReadsPerSecParam().name()})))).stripMargin();
                    }
                });
                long longStr = new StringOps(Predef$.MODULE$.augmentString(str2)).toLong();
                if (longStr > Integer.MAX_VALUE) {
                    ReadConf$.MODULE$.logDebug((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " was set to a value larger than\n               | ", " using ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ReadConf$.MODULE$.ThroughputJoinQueryPerSecParam().name(), BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)})))).stripMargin();
                        }
                    });
                    n = Integer.MAX_VALUE;
                } else {
                    n = (int)longStr;
                }
                return n;
            }
        });
        int x$3 = conf.getInt(this.FetchSizeInRowsParam().name(), BoxesRunTime.unboxToInt((Object)this.FetchSizeInRowsParam().default()));
        int x$4 = conf.getInt(this.SplitSizeInMBParam().name(), BoxesRunTime.unboxToInt((Object)this.SplitSizeInMBParam().default()));
        ConsistencyLevel x$5 = ConsistencyLevel.valueOf(conf.get(this.ConsistencyLevelParam().name(), ((Enum)this.ConsistencyLevelParam().default()).name()));
        boolean x$6 = conf.getBoolean(this.TaskMetricParam().name(), BoxesRunTime.unboxToBoolean((Object)this.TaskMetricParam().default()));
        int x$7 = conf.getInt(this.ReadsPerSecParam().name(), BoxesRunTime.unboxToInt((Object)throughtputJoinQueryPerSec.getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return BoxesRunTime.unboxToInt((Object)ReadConf$.MODULE$.ReadsPerSecParam().default());
            }
        })));
        int x$8 = conf.getInt(this.ParallelismLevelParam().name(), BoxesRunTime.unboxToInt((Object)this.ParallelismLevelParam().default()));
        Option x$9 = conf.getOption(this.SplitCountParam().name()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
            }
        });
        return new ReadConf((Option<Object>)x$9, x$4, x$3, x$5, x$6, x$8, x$7);
    }

    public ReadConf apply(Option<Object> splitCount, int splitSizeInMB, int fetchSizeInRows, ConsistencyLevel consistencyLevel, boolean taskMetricsEnabled, int parallelismLevel, int readsPerSec) {
        return new ReadConf(splitCount, splitSizeInMB, fetchSizeInRows, consistencyLevel, taskMetricsEnabled, parallelismLevel, readsPerSec);
    }

    public Option<Tuple7<Option<Object>, Object, Object, ConsistencyLevel, Object, Object, Object>> unapply(ReadConf x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple7(x$0.splitCount(), (Object)BoxesRunTime.boxToInteger((int)x$0.splitSizeInMB()), (Object)BoxesRunTime.boxToInteger((int)x$0.fetchSizeInRows()), (Object)x$0.consistencyLevel(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.taskMetricsEnabled()), (Object)BoxesRunTime.boxToInteger((int)x$0.parallelismLevel()), (Object)BoxesRunTime.boxToInteger((int)x$0.readsPerSec())));
    }

    public Option<Object> apply$default$1() {
        return None$.MODULE$;
    }

    public int apply$default$2() {
        return BoxesRunTime.unboxToInt((Object)this.SplitSizeInMBParam().default());
    }

    public int apply$default$3() {
        return BoxesRunTime.unboxToInt((Object)this.FetchSizeInRowsParam().default());
    }

    public ConsistencyLevel apply$default$4() {
        return this.ConsistencyLevelParam().default();
    }

    public boolean apply$default$5() {
        return BoxesRunTime.unboxToBoolean((Object)this.TaskMetricParam().default());
    }

    public int apply$default$6() {
        return BoxesRunTime.unboxToInt((Object)this.ParallelismLevelParam().default());
    }

    public int apply$default$7() {
        return BoxesRunTime.unboxToInt((Object)this.ReadsPerSecParam().default());
    }

    public Option<Object> $lessinit$greater$default$1() {
        return None$.MODULE$;
    }

    public int $lessinit$greater$default$2() {
        return BoxesRunTime.unboxToInt((Object)this.SplitSizeInMBParam().default());
    }

    public int $lessinit$greater$default$3() {
        return BoxesRunTime.unboxToInt((Object)this.FetchSizeInRowsParam().default());
    }

    public ConsistencyLevel $lessinit$greater$default$4() {
        return this.ConsistencyLevelParam().default();
    }

    public boolean $lessinit$greater$default$5() {
        return BoxesRunTime.unboxToBoolean((Object)this.TaskMetricParam().default());
    }

    public int $lessinit$greater$default$6() {
        return BoxesRunTime.unboxToInt((Object)this.ParallelismLevelParam().default());
    }

    public int $lessinit$greater$default$7() {
        return BoxesRunTime.unboxToInt((Object)this.ReadsPerSecParam().default());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ReadConf$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.ReferenceSection = "Read Tuning Parameters";
        this.SplitCountParam = new ConfigParameter<None$>("splitCount", this.ReferenceSection(), None$.MODULE$, new StringOps(Predef$.MODULE$.augmentString("Specify the number of Spark partitions to\n        |read the Cassandra table into. This parameter is\n        |used in SparkSql and DataFrame Options.\n      ")).stripMargin());
        this.SplitSizeInMBParam = new ConfigParameter<Integer>("spark.cassandra.input.split.size_in_mb", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)64), (String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString("Approx amount of data to be fetched into a Spark partition. Minimum number of resulting Spark\n        | partitions is <code>1 + 2 * SparkContext.defaultParallelism</code>\n        |")).stripMargin())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$1) {
                return x$1 >= ' ';
            }
        }));
        this.FetchSizeInRowsParam = new ConfigParameter<Integer>("spark.cassandra.input.fetch.size_in_rows", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)1000), "Number of CQL rows fetched per driver request");
        this.ConsistencyLevelParam = new ConfigParameter<ConsistencyLevel>("spark.cassandra.input.consistency.level", this.ReferenceSection(), ConsistencyLevel.LOCAL_ONE, "Consistency level to use when reading\t");
        this.TaskMetricParam = new ConfigParameter<Boolean>("spark.cassandra.input.metrics", this.ReferenceSection(), BoxesRunTime.boxToBoolean((boolean)true), "Sets whether to record connector specific metrics on write");
        this.ThroughputJoinQueryPerSecParam = new ConfigParameter<Long>("spark.cassandra.input.join.throughput_query_per_sec", this.ReferenceSection(), BoxesRunTime.boxToLong((long)Integer.MAX_VALUE), "**Deprecated** Please use input.reads_per_sec. Maximum read throughput allowed per single core in query/s while joining RDD with Cassandra table");
        this.ParallelismLevelParam = new ConfigParameter<Integer>("spark.cassandra.concurrent.reads", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)512), "Sets read parallelism for joinWithCassandra tables");
        this.ReadsPerSecParam = new ConfigParameter<Integer>("spark.cassandra.input.reads_per_sec", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), "Sets max requests per core per second for joinWithCassandraTable and some Enterprise integrations");
        this.Properties = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigParameter[]{this.SplitCountParam(), this.ConsistencyLevelParam(), this.FetchSizeInRowsParam(), this.ReadsPerSecParam(), this.SplitSizeInMBParam(), this.TaskMetricParam(), this.ThroughputJoinQueryPerSecParam(), this.ParallelismLevelParam()}));
    }
}

