/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd.partitioner;

import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.Schema$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.rdd.partitioner.ReplicaPartition;
import com.datastax.spark.connector.rdd.partitioner.TokenGenerator;
import com.datastax.spark.connector.writer.RowWriter;
import com.datastax.spark.connector.writer.RowWriterFactory;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import org.apache.spark.Partition;
import org.apache.spark.Partitioner;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import shade.com.datastax.spark.connector.driver.core.Cluster;
import shade.com.datastax.spark.connector.driver.core.Host;
import shade.com.datastax.spark.connector.driver.core.Metadata;
import shade.com.datastax.spark.connector.driver.core.ProtocolVersion;

@ScalaSignature(bytes="\u0006\u0001\t5a\u0001B\u0001\u0003\u0001=\u0011!CU3qY&\u001c\u0017\rU1si&$\u0018n\u001c8fe*\u00111\u0001B\u0001\fa\u0006\u0014H/\u001b;j_:,'O\u0003\u0002\u0006\r\u0005\u0019!\u000f\u001a3\u000b\u0005\u001dA\u0011!C2p]:,7\r^8s\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u0005AA-\u0019;bgR\f\u0007PC\u0001\u000e\u0003\r\u0019w.\\\u0002\u0001+\t\u0001ri\u0005\u0002\u0001#A\u0011!\u0003G\u0007\u0002')\u0011\u0011\u0002\u0006\u0006\u0003+Y\ta!\u00199bG\",'\"A\f\u0002\u0007=\u0014x-\u0003\u0002\u001a'\tY\u0001+\u0019:uSRLwN\\3s\u0011!Y\u0002A!A!\u0002\u0013a\u0012!\u0002;bE2,\u0007CA\u000f$\u001d\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0003\u0019\u0001&/\u001a3fM&\u0011A%\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\tz\u0002\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u0011-,\u0017p\u001d9bG\u0016D\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IAK\u0001\u0018a\u0006\u0014H/\u001b;j_:\u001c\b+\u001a:SKBd\u0017nY1TKR\u0004\"AH\u0016\n\u00051z\"aA%oi\"Aa\u0006\u0001B\u0001B\u0003%q&\u0001\nqCJ$\u0018\u000e^5p].+\u00170T1qa\u0016\u0014\bC\u0001\u00192\u001b\u00051\u0011B\u0001\u001a\u0007\u00059\u0019u\u000e\\;n]N+G.Z2u_JD\u0001b\u0002\u0001\u0003\u0006\u0004%\t\u0001N\u000b\u0002kA\u0011a'O\u0007\u0002o)\u0011\u0001HB\u0001\u0004GFd\u0017B\u0001\u001e8\u0005I\u0019\u0015m]:b]\u0012\u0014\u0018mQ8o]\u0016\u001cGo\u001c:\t\u0011q\u0002!\u0011!Q\u0001\nU\n!bY8o]\u0016\u001cGo\u001c:!\u0011!q\u0004A!A!\u0002\u0017y\u0014aC2veJ,g\u000e\u001e+za\u0016\u00042\u0001Q\"F\u001b\u0005\t%B\u0001\" \u0003\u001d\u0011XM\u001a7fGRL!\u0001R!\u0003\u0011\rc\u0017m]:UC\u001e\u0004\"AR$\r\u0001\u0011)\u0001\n\u0001b\u0001\u0013\n\tA+\u0005\u0002K\u001bB\u0011adS\u0005\u0003\u0019~\u0011qAT8uQ&tw\r\u0005\u0002\u001f\u001d&\u0011qj\b\u0002\u0004\u0003:L\b\u0002C)\u0001\u0005\u0003\u0005\u000b1\u0002*\u0002\u0007I<h\rE\u0002T-\u0016k\u0011\u0001\u0016\u0006\u0003+\u001a\taa\u001e:ji\u0016\u0014\u0018BA,U\u0005A\u0011vn^,sSR,'OR1di>\u0014\u0018\u0010\u000b\u0002Q3B\u0011aDW\u0005\u00037~\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u000bu\u0003A\u0011\u00010\u0002\rqJg.\u001b;?)\u0019yF-\u001a4hQR\u0019\u0001MY2\u0011\u0007\u0005\u0004Q)D\u0001\u0003\u0011\u0015qD\fq\u0001@\u0011\u0015\tF\fq\u0001S\u0011\u0015YB\f1\u0001\u001d\u0011\u00159C\f1\u0001\u001d\u0011\u0015IC\f1\u0001+\u0011\u0015qC\f1\u00010\u0011\u00159A\f1\u00016\u0011\u001dQ\u0007A1A\u0005\u0002-\f\u0001\u0002^1cY\u0016$UMZ\u000b\u0002YB\u0011a'\\\u0005\u0003]^\u0012\u0001\u0002V1cY\u0016$UM\u001a\u0005\u0007a\u0002\u0001\u000b\u0011\u00027\u0002\u0013Q\f'\r\\3EK\u001a\u0004\u0003b\u0002:\u0001\u0005\u0004%\ta]\u0001\ne><xK]5uKJ,\u0012\u0001\u001e\t\u0004'V,\u0015B\u0001<U\u0005%\u0011vn^,sSR,'\u000f\u0003\u0004y\u0001\u0001\u0006I\u0001^\u0001\u000be><xK]5uKJ\u0004\u0003\"\u0003>\u0001\u0011\u000b\u0007I\u0011\u0001\u0005|\u00039!xn[3o\u000f\u0016tWM]1u_J,\u0012\u0001 \t\u0004Cv,\u0015B\u0001@\u0003\u00059!vn[3o\u000f\u0016tWM]1u_JD\u0011\"!\u0001\u0001\u0011\u0003\u0005\u000b\u0015\u0002?\u0002\u001fQ|7.\u001a8HK:,'/\u0019;pe\u0002B#a`-\t\u0015\u0005\u001d\u0001\u0001#b\u0001\n\u0013\tI!\u0001\u0005nKR\fG-\u0019;b+\t\tY\u0001\u0005\u0003\u0002\u000e\u0005]QBAA\b\u0015\u0011\t\t\"a\u0005\u0002\t\r|'/\u001a\u0006\u0004\u0003+Q\u0011A\u00023sSZ,'/\u0003\u0003\u0002\u001a\u0005=!\u0001C'fi\u0006$\u0017\r^1\t\u0015\u0005u\u0001\u0001#A!B\u0013\tY!A\u0005nKR\fG-\u0019;bA!\u001a\u00111D-\t\u0015\u0005\r\u0002\u0001#b\u0001\n\u0013\t)#A\bqe>$xnY8m-\u0016\u00148/[8o+\t\t9\u0003\u0005\u0003\u0002\u000e\u0005%\u0012\u0002BA\u0016\u0003\u001f\u0011q\u0002\u0015:pi>\u001cw\u000e\u001c,feNLwN\u001c\u0005\u000b\u0003_\u0001\u0001\u0012!Q!\n\u0005\u001d\u0012\u0001\u00059s_R|7m\u001c7WKJ\u001c\u0018n\u001c8!Q\r\ti#\u0017\u0005\u000b\u0003k\u0001\u0001R1A\u0005\n\u0005]\u0012!B2mCjTXCAA\u001da\u0011\tY$!\u0014\u0011\r\u0005u\u0012qIA&\u001b\t\tyD\u0003\u0003\u0002B\u0005\r\u0013\u0001\u00027b]\u001eT!!!\u0012\u0002\t)\fg/Y\u0005\u0005\u0003\u0013\nyDA\u0003DY\u0006\u001c8\u000fE\u0002G\u0003\u001b\"1\"a\u0014\u0002R\u0005\u0005\t\u0011!B\u0001\u0013\n\u0019q\fJ\u0019\t\u0015\u0005M\u0003\u0001#A!B\u0013\tI$\u0001\u0004dY\u0006T(\u0010\t\u0015\u0004\u0003#J\u0006\"CA-\u0001\t\u0007I\u0011BA.\u0003\u0015Awn\u001d;t+\t\ti\u0006\u0005\u0004\u0002`\u0005\u0015\u00141\u000e\b\u0004=\u0005\u0005\u0014bAA2?\u00059\u0001/Y2lC\u001e,\u0017\u0002BA4\u0003S\u0012aAV3di>\u0014(bAA2?A!\u0011QNA:\u001b\t\tyG\u0003\u0003\u0002r\u0005\r\u0013a\u00018fi&!\u0011QOA8\u0005-Ie.\u001a;BI\u0012\u0014Xm]:\t\u0011\u0005e\u0004\u0001)A\u0005\u0003;\na\u0001[8tiN\u0004\u0003\"CA?\u0001\t\u0007I\u0011BA@\u0003\u001dAwn\u001d;TKR,\"!!!\u0011\u000bu\t\u0019)a\u001b\n\u0007\u0005\u0015UEA\u0002TKRD\u0001\"!#\u0001A\u0003%\u0011\u0011Q\u0001\tQ>\u001cHoU3uA!I\u0011Q\u0012\u0001C\u0002\u0013%\u0011qR\u0001\t]Vl\u0007j\\:ugV\t!\u0006C\u0004\u0002\u0014\u0002\u0001\u000b\u0011\u0002\u0016\u0002\u00139,X\u000eS8tiN\u0004\u0003\"CAL\u0001\t\u0007I\u0011BAM\u0003A\u0001\u0018M\u001d;ji&|g.\u00138eKb,7/\u0006\u0002\u0002\u001cB1\u0011qLAO\u0003CKA!a(\u0002j\t!A*[:u!\u0015\t\u0019+!,+\u001b\t\t)K\u0003\u0003\u0002(\u0006%\u0016!C5n[V$\u0018M\u00197f\u0015\r\tYkH\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAX\u0003K\u0013!\"\u00138eKb,GmU3r\u0011!\t\u0019\f\u0001Q\u0001\n\u0005m\u0015!\u00059beRLG/[8o\u0013:$W\r_3tA!I\u0011q\u0017\u0001C\u0002\u0013%\u0011\u0011X\u0001\bQ>\u001cH/T1q+\t\tY\f\u0005\u0005\u0002$\u0006u\u00161NAQ\u0013\u0011\ty,!*\u0003\u00075\u000b\u0007\u000f\u0003\u0005\u0002D\u0002\u0001\u000b\u0011BA^\u0003!Awn\u001d;NCB\u0004\u0003\"CAd\u0001\t\u0007I\u0011BAe\u0003!Ig\u000eZ3y\u001b\u0006\u0004XCAAf!\u001d\t\u0019+!0+\u0003WB\u0001\"a4\u0001A\u0003%\u00111Z\u0001\nS:$W\r_'ba\u0002Bq!a5\u0001\t\u0013\t).A\u0005bENlu\u000eZ;m_R)!&a6\u0002\\\"9\u0011\u0011\\Ai\u0001\u0004Q\u0013\u0001\u00033jm&$WM\u001c3\t\u000f\u0005u\u0017\u0011\u001ba\u0001U\u00059A-\u001b<jg>\u0014\bbBAq\u0001\u0011%\u00111]\u0001\u000be\u0006tGm\\7I_N$H\u0003BA6\u0003KDq!a:\u0002`\u0002\u0007!&A\u0003j]\u0012,\u0007\u0010C\u0004\u0002l\u0002!\t%!<\u0002\u0019\u001d,G\u000fU1si&$\u0018n\u001c8\u0015\u0007)\ny\u000fC\u0004\u0002r\u0006%\b\u0019A'\u0002\u0007-,\u0017\u0010C\u0004\u0002v\u0002!\t%a$\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t\u0011\u001d\tI\u0010\u0001C\u0001\u0003w\fAcZ3u\u000b:$\u0007o\\5oiB\u000b'\u000f^5uS>tG\u0003BA\u007f\u0005\u0007\u00012!YA\u0000\u0013\r\u0011\tA\u0001\u0002\u0011%\u0016\u0004H.[2b!\u0006\u0014H/\u001b;j_:D\u0001B!\u0002\u0002x\u0002\u0007!qA\u0001\na\u0006\u0014H/\u001b;j_:\u00042A\u0005B\u0005\u0013\r\u0011Ya\u0005\u0002\n!\u0006\u0014H/\u001b;j_:\u0004")
public class ReplicaPartitioner<T>
extends Partitioner {
    private final String keyspace;
    private final int partitionsPerReplicaSet;
    private final CassandraConnector connector;
    private final ClassTag<T> currentType;
    private final TableDef tableDef;
    private final RowWriter<T> rowWriter;
    private transient TokenGenerator<T> tokenGenerator;
    private transient Metadata metadata;
    private transient ProtocolVersion protocolVersion;
    private transient Class<?> clazz;
    private final Vector<InetAddress> hosts;
    private final scala.collection.immutable.Set<InetAddress> hostSet;
    private final int numHosts;
    private final List<IndexedSeq<Object>> partitionIndexes;
    private final Map<InetAddress, IndexedSeq<Object>> hostMap;
    private final Map<Object, InetAddress> com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap;
    private volatile transient byte bitmap$trans$0;

    private TokenGenerator tokenGenerator$lzycompute() {
        ReplicaPartitioner replicaPartitioner = this;
        synchronized (replicaPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.tokenGenerator = new TokenGenerator<T>(this.connector(), this.tableDef(), this.rowWriter());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
            return this.tokenGenerator;
        }
    }

    private Metadata metadata$lzycompute() {
        ReplicaPartitioner replicaPartitioner = this;
        synchronized (replicaPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.metadata = (Metadata)this.connector().withClusterDo(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Metadata apply(Cluster x$1) {
                        return x$1.getMetadata();
                    }
                });
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
            return this.metadata;
        }
    }

    private ProtocolVersion protocolVersion$lzycompute() {
        ReplicaPartitioner replicaPartitioner = this;
        synchronized (replicaPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.protocolVersion = (ProtocolVersion)((Object)this.connector().withClusterDo(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ProtocolVersion apply(Cluster x$2) {
                        return x$2.getConfiguration().getProtocolOptions().getProtocolVersion();
                    }
                }));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
            return this.protocolVersion;
        }
    }

    private Class clazz$lzycompute() {
        ReplicaPartitioner replicaPartitioner = this;
        synchronized (replicaPartitioner) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.clazz = ((ClassTag)Predef$.MODULE$.implicitly(this.currentType)).runtimeClass();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
            return this.clazz;
        }
    }

    public CassandraConnector connector() {
        return this.connector;
    }

    public TableDef tableDef() {
        return this.tableDef;
    }

    public RowWriter<T> rowWriter() {
        return this.rowWriter;
    }

    public TokenGenerator<T> tokenGenerator() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.tokenGenerator$lzycompute() : this.tokenGenerator;
    }

    private Metadata metadata() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.metadata$lzycompute() : this.metadata;
    }

    private ProtocolVersion protocolVersion() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.protocolVersion$lzycompute() : this.protocolVersion;
    }

    private Class<?> clazz() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.clazz$lzycompute() : this.clazz;
    }

    private Vector<InetAddress> hosts() {
        return this.hosts;
    }

    private scala.collection.immutable.Set<InetAddress> hostSet() {
        return this.hostSet;
    }

    private int numHosts() {
        return this.numHosts;
    }

    private List<IndexedSeq<Object>> partitionIndexes() {
        return this.partitionIndexes;
    }

    private Map<InetAddress, IndexedSeq<Object>> hostMap() {
        return this.hostMap;
    }

    public Map<Object, InetAddress> com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap() {
        return this.com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap;
    }

    private int absModulo(int dividend, int divisor) {
        return Math.abs(dividend % divisor);
    }

    private InetAddress randomHost(int index) {
        return (InetAddress)this.hosts().apply(this.absModulo(index, this.hosts().length()));
    }

    public int getPartition(Object key) {
        Object object = key;
        Option option = this.currentType.unapply(object);
        if (!option.isEmpty() && option.get() instanceof Object && this.clazz().isInstance(object)) {
            int n;
            ByteBuffer keyBuffer = this.tokenGenerator().getPartitionKeyBufferFor(object);
            int keyHash = Math.abs(keyBuffer.hashCode());
            Set replicas = (Set)JavaConversions$.MODULE$.asScalaSet(this.metadata().getReplicas(this.keyspace, keyBuffer)).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final InetAddress apply(Host x$4) {
                    return x$4.getBroadcastAddress();
                }
            }, Set$.MODULE$.canBuildFrom());
            Vector replicaSetInDC = ((TraversableOnce)this.hostSet().$amp((GenSet)replicas)).toVector();
            if (replicaSetInDC.nonEmpty()) {
                InetAddress endpoint = (InetAddress)replicaSetInDC.apply(this.absModulo(keyHash, replicaSetInDC.size()));
                n = BoxesRunTime.unboxToInt((Object)((SeqLike)this.hostMap().apply((Object)endpoint)).apply(this.absModulo(keyHash, this.partitionsPerReplicaSet)));
            } else {
                n = BoxesRunTime.unboxToInt((Object)((SeqLike)this.hostMap().apply((Object)this.randomHost(keyHash))).apply(this.absModulo(keyHash, this.partitionsPerReplicaSet)));
            }
            int n2 = n;
            return n2;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"ReplicaPartitioner can only determine the partition of a tuple whose key is a non-empty Set[InetAddress]. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid key: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key}))).toString());
    }

    public int numPartitions() {
        return this.partitionsPerReplicaSet * this.numHosts();
    }

    public ReplicaPartition getEndpointPartition(Partition partition) {
        InetAddress endpoints = (InetAddress)this.com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap().getOrElse((Object)BoxesRunTime.boxToInteger((int)partition.index()), (Function0)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaPartitioner $outer;
            private final Partition partition$1;

            public final Nothing$ apply() {
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " : Can't get an endpoint for Partition ", ".index"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap(), this.partition$1})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$1 = partition$1;
            }
        });
        return new ReplicaPartition(partition.index(), (scala.collection.immutable.Set<InetAddress>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{endpoints}))));
    }

    public ReplicaPartitioner(String table, String keyspace, int partitionsPerReplicaSet, ColumnSelector partitionKeyMapper, CassandraConnector connector, ClassTag<T> currentType, RowWriterFactory<T> rwf) {
        this.keyspace = keyspace;
        this.partitionsPerReplicaSet = partitionsPerReplicaSet;
        this.connector = connector;
        this.currentType = currentType;
        this.tableDef = Schema$.MODULE$.tableFromCassandra(connector, keyspace, table);
        this.rowWriter = ((RowWriterFactory)Predef$.MODULE$.implicitly(rwf)).rowWriter(this.tableDef(), partitionKeyMapper.selectFrom(this.tableDef()));
        this.hosts = connector.hosts().toVector();
        this.hostSet = connector.hosts();
        this.numHosts = this.hosts().size();
        this.partitionIndexes = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionsPerReplicaSet * this.numHosts()).grouped(partitionsPerReplicaSet).toList();
        this.hostMap = ((TraversableOnce)this.hosts().zip(this.partitionIndexes(), Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap = (Map)this.hostMap().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<InetAddress, IndexedSeq<Object>> check$ifrefutable$1) {
                Tuple2<InetAddress, IndexedSeq<Object>> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final IndexedSeq<Tuple2<Object, InetAddress>> apply(Tuple2<InetAddress, IndexedSeq<Object>> x$3) {
                Tuple2<InetAddress, IndexedSeq<Object>> tuple2 = x$3;
                if (tuple2 != null) {
                    InetAddress ip = (InetAddress)tuple2._1();
                    IndexedSeq partitions2 = (IndexedSeq)tuple2._2();
                    IndexedSeq indexedSeq = (IndexedSeq)partitions2.map((Function1)new Serializable(this, ip){
                        public static final long serialVersionUID = 0L;
                        private final InetAddress ip$1;

                        public final Tuple2<Object, InetAddress> apply(int partition) {
                            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)partition), (Object)this.ip$1);
                        }
                        {
                            this.ip$1 = ip$1;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                    return indexedSeq;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
    }
}

