/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.writer;

import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.util.Logging$class;
import com.datastax.spark.connector.writer.AsyncExecutor$;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.concurrent.TrieMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;
import scala.util.Try;
import scala.util.Try$;
import shade.com.datastax.spark.connector.driver.core.exceptions.BusyPoolException;
import shade.com.datastax.spark.connector.driver.core.exceptions.NoHostAvailableException;
import shade.com.datastax.spark.connector.google.common.util.concurrent.FutureCallback;
import shade.com.datastax.spark.connector.google.common.util.concurrent.Futures;
import shade.com.datastax.spark.connector.google.common.util.concurrent.ListenableFuture;
import shade.com.datastax.spark.connector.google.common.util.concurrent.SettableFuture;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u0001\u0003\u00015\u0011Q\"Q:z]\u000e,\u00050Z2vi>\u0014(BA\u0002\u0005\u0003\u00199(/\u001b;fe*\u0011QAB\u0001\nG>tg.Z2u_JT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011\u0001\u00033bi\u0006\u001cH/\u0019=\u000b\u0003-\t1aY8n\u0007\u0001)2A\u0004\u00128'\r\u0001q\"\u0006\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005YIR\"A\f\u000b\u0005a!\u0011\u0001B;uS2L!AG\f\u0003\u000f1{wmZ5oO\"AA\u0004\u0001B\u0001B\u0003%Q$A\u0006bgft7-Q2uS>t\u0007\u0003\u0002\t\u001fA-J!aH\t\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CA\u0011#\u0019\u0001!Qa\t\u0001C\u0002\u0011\u0012\u0011\u0001V\t\u0003K!\u0002\"\u0001\u0005\u0014\n\u0005\u001d\n\"a\u0002(pi\"Lgn\u001a\t\u0003!%J!AK\t\u0003\u0007\u0005s\u0017\u0010E\u0002-iYj\u0011!\f\u0006\u0003]=\n!bY8oGV\u0014(/\u001a8u\u0015\tA\u0002G\u0003\u00022e\u000511m\\7n_:T!a\r\u0006\u0002\r\u001d|wn\u001a7f\u0013\t)TF\u0001\tMSN$XM\\1cY\u00164U\u000f^;sKB\u0011\u0011e\u000e\u0003\u0006q\u0001\u0011\r\u0001\n\u0002\u0002%\"A!\b\u0001B\u0001B\u0003%1(\u0001\nnCb\u001cuN\\2veJ,g\u000e\u001e+bg.\u001c\bC\u0001\t=\u0013\ti\u0014CA\u0002J]RD\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001Q\u0001\u000fgV\u001c7-Z:t\u0011\u0006tG\r\\3s!\r\u0001\u0012iQ\u0005\u0003\u0005F\u0011aa\u00149uS>t\u0007c\u0001#OA9\u0011QIR\u0007\u0002\u0005\u001d)qI\u0001E\u0001\u0011\u0006i\u0011i]=oG\u0016CXmY;u_J\u0004\"!R%\u0007\u000b\u0005\u0011\u0001\u0012\u0001&\u0014\u0005%{\u0001\"\u0002'J\t\u0003i\u0015A\u0002\u001fj]&$h\bF\u0001I\u000b\u0011y\u0015\n\u0001)\u0003\u000f!\u000bg\u000e\u001a7feV\u0011\u0011+\u0016\t\u0007!I#fKV-\n\u0005M\u000b\"!\u0003$v]\u000e$\u0018n\u001c84!\t\tS\u000bB\u0003$\u001d\n\u0007A\u0005\u0005\u0002\u0011/&\u0011\u0001,\u0005\u0002\u0005\u0019>tw\r\u0005\u0002\u00115&\u00111,\u0005\u0002\u0005+:LG\u000fC\u0004^\u0013F\u0005I\u0011\u00010\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\ryVN\\\u000b\u0002A*\u0012\u0011\r\u001a\b\u0003!\tL!aY\t\u0002\t9{g.Z\u0016\u0002KB\u0011am[\u0007\u0002O*\u0011\u0001.[\u0001\nk:\u001c\u0007.Z2lK\u0012T!A[\t\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002mO\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\u000b\rb&\u0019\u0001\u0013\u0005\u000bab&\u0019\u0001\u0013\t\u0011A\u0004!\u0011!Q\u0001\n\u0001\u000baBZ1jYV\u0014X\rS1oI2,'\u000fC\u0003M\u0001\u0011\u0005!\u000fF\u0003tiV4x\u000f\u0005\u0003F\u0001\u00012\u0004\"\u0002\u000fr\u0001\u0004i\u0002\"\u0002\u001er\u0001\u0004Y\u0004bB r!\u0003\u0005\r\u0001\u0011\u0005\u0006aF\u0004\r\u0001\u0011\u0005\bs\u0002\u0011\r\u0011\"\u0003{\u0003%\u0019X-\\1qQ>\u0014X-F\u0001|!\ra\u00181A\u0007\u0002{*\u0011aF \u0006\u00031}T!!!\u0001\u0002\t)\fg/Y\u0005\u0004\u0003\u000bi(!C*f[\u0006\u0004\bn\u001c:f\u0011\u001d\tI\u0001\u0001Q\u0001\nm\f!b]3nCBDwN]3!\u0011%\ti\u0001\u0001b\u0001\n\u0013\ty!\u0001\bqK:$\u0017N\\4GkR,(/Z:\u0016\u0005\u0005E\u0001cBA\n\u00037Y\u0013qD\u0007\u0003\u0003+Q1ALA\f\u0015\r\tI\"E\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u000f\u0003+\u0011q\u0001\u0016:jK6\u000b\u0007\u000fE\u0002\u0011\u0003CI1!a\t\u0012\u0005\u001d\u0011un\u001c7fC:D\u0001\"a\n\u0001A\u0003%\u0011\u0011C\u0001\u0010a\u0016tG-\u001b8h\rV$XO]3tA!I\u00111\u0006\u0001A\u0002\u0013%\u0011QF\u0001\u0010Y\u0006$Xm\u001d;Fq\u000e,\u0007\u000f^5p]V\u0011\u0011q\u0006\t\u0005!\u0005\u000b\t\u0004\u0005\u0003\u00024\u0005\rc\u0002BA\u001b\u0003\u007fqA!a\u000e\u0002>5\u0011\u0011\u0011\b\u0006\u0004\u0003wa\u0011A\u0002\u001fs_>$h(C\u0001\u0013\u0013\r\t\t%E\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)%a\u0012\u0003\u0013QC'o\\<bE2,'bAA!#!I\u00111\n\u0001A\u0002\u0013%\u0011QJ\u0001\u0014Y\u0006$Xm\u001d;Fq\u000e,\u0007\u000f^5p]~#S-\u001d\u000b\u00043\u0006=\u0003BCA)\u0003\u0013\n\t\u00111\u0001\u00020\u0005\u0019\u0001\u0010J\u0019\t\u0011\u0005U\u0003\u0001)Q\u0005\u0003_\t\u0001\u0003\\1uKN$X\t_2faRLwN\u001c\u0011)\t\u0005M\u0013\u0011\f\t\u0004!\u0005m\u0013bAA/#\tAao\u001c7bi&dW\rC\u0004\u0002b\u0001!\t!a\u0019\u0002%\u001d,G\u000fT1uKN$X\t_2faRLwN\u001c\u000b\u0003\u0003_Aq!a\u001a\u0001\t\u0003\tI'\u0001\u0007fq\u0016\u001cW\u000f^3Bgft7\rF\u0002,\u0003WBq!!\u001c\u0002f\u0001\u0007\u0001%\u0001\u0003uCN\\\u0007bBA9\u0001\u0011\u0005\u00111O\u0001\u001fo\u0006LGOR8s\u0007V\u0014(/\u001a8uYf,\u00050Z2vi&tw\rV1tWN$\u0012!\u0017")
public class AsyncExecutor<T, R>
implements Logging {
    private final Function1<T, ListenableFuture<R>> asyncAction;
    public final Option<Function3<T, Object, Object, BoxedUnit>> com$datastax$spark$connector$writer$AsyncExecutor$$successHandler;
    public final Option<Function3<T, Object, Object, BoxedUnit>> com$datastax$spark$connector$writer$AsyncExecutor$$failureHandler;
    private final Semaphore com$datastax$spark$connector$writer$AsyncExecutor$$semaphore;
    private final TrieMap<ListenableFuture<R>, Object> com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures;
    private volatile Option<Throwable> com$datastax$spark$connector$writer$AsyncExecutor$$latestException;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    public static <T, R> None$ $lessinit$greater$default$3() {
        return AsyncExecutor$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    @Override
    @TraitSetter
    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public Semaphore com$datastax$spark$connector$writer$AsyncExecutor$$semaphore() {
        return this.com$datastax$spark$connector$writer$AsyncExecutor$$semaphore;
    }

    public TrieMap<ListenableFuture<R>, Object> com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures() {
        return this.com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures;
    }

    private Option<Throwable> com$datastax$spark$connector$writer$AsyncExecutor$$latestException() {
        return this.com$datastax$spark$connector$writer$AsyncExecutor$$latestException;
    }

    public void com$datastax$spark$connector$writer$AsyncExecutor$$latestException_$eq(Option<Throwable> x$1) {
        this.com$datastax$spark$connector$writer$AsyncExecutor$$latestException = x$1;
    }

    public Option<Throwable> getLatestException() {
        return this.com$datastax$spark$connector$writer$AsyncExecutor$$latestException();
    }

    public ListenableFuture<R> executeAsync(T task) {
        long submissionTimestamp = System.nanoTime();
        this.com$datastax$spark$connector$writer$AsyncExecutor$$semaphore().acquire();
        SettableFuture settable = SettableFuture.create();
        this.com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures().put(settable, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        long executionTimestamp = System.nanoTime();
        return this.com$datastax$spark$connector$writer$AsyncExecutor$$tryFuture$1(task, submissionTimestamp, settable, executionTimestamp);
    }

    public void waitForCurrentlyExecutingTasks() {
        this.com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures().snapshot().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<ListenableFuture<R>, Object> check$ifrefutable$1) {
                Tuple2<ListenableFuture<R>, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Try<R> apply(Tuple2<ListenableFuture<R>, Object> x$4) {
                Tuple2<ListenableFuture<R>, Object> tuple2 = x$4;
                if (tuple2 != null) {
                    ListenableFuture future = (ListenableFuture)tuple2._1();
                    Try try_ = Try$.MODULE$.apply((Function0)new Serializable(this, future){
                        public static final long serialVersionUID = 0L;
                        private final ListenableFuture future$1;

                        public final R apply() {
                            return (R)this.future$1.get();
                        }
                        {
                            this.future$1 = future$1;
                        }
                    });
                    return try_;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public final SettableFuture com$datastax$spark$connector$writer$AsyncExecutor$$tryFuture$1(Object task$1, long submissionTimestamp$1, SettableFuture settable$1, long executionTimestamp$1) {
        ListenableFuture future = (ListenableFuture)this.asyncAction.apply(task$1);
        Futures.addCallback(future, new FutureCallback<R>(this, task$1, submissionTimestamp$1, settable$1, executionTimestamp$1){
            private final /* synthetic */ AsyncExecutor $outer;
            public final Object task$1;
            public final long submissionTimestamp$1;
            private final SettableFuture settable$1;
            public final long executionTimestamp$1;

            private void release() {
                this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$semaphore().release();
                this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures().remove((Object)this.settable$1);
            }

            public void onSuccess(R result) {
                this.release();
                this.settable$1.set(result);
                this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$successHandler.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;

                    public final void apply(Function3<T, Object, Object, BoxedUnit> x$1) {
                        x$1.apply(this.$outer.task$1, (Object)BoxesRunTime.boxToLong((long)this.$outer.submissionTimestamp$1), (Object)BoxesRunTime.boxToLong((long)this.$outer.executionTimestamp$1));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public void onFailure(Throwable throwable) {
                NoHostAvailableException noHostAvailableException;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof NoHostAvailableException && ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((noHostAvailableException = (NoHostAvailableException)throwable2).getErrors()).asScala()).values().exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Throwable x$2) {
                        return x$2 instanceof BusyPoolException;
                    }
                })) {
                    this.$outer.logWarning((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "BusyPoolException ... Retrying";
                        }
                    });
                    this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$tryFuture$1(this.task$1, this.submissionTimestamp$1, this.settable$1, this.executionTimestamp$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.$outer.logError((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anon$1 $outer;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Failed to execute: ").append(this.$outer.task$1).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, throwable);
                    this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$latestException_$eq((Option<Throwable>)new Some((Object)throwable));
                    this.release();
                    this.settable$1.setException(throwable);
                    this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$failureHandler.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anon$1 $outer;

                        public final void apply(Function3<T, Object, Object, BoxedUnit> x$3) {
                            x$3.apply(this.$outer.task$1, (Object)BoxesRunTime.boxToLong((long)this.$outer.submissionTimestamp$1), (Object)BoxesRunTime.boxToLong((long)this.$outer.executionTimestamp$1));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                void var5_4;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.task$1 = task$1;
                this.submissionTimestamp$1 = submissionTimestamp$1;
                this.settable$1 = var5_4;
                this.executionTimestamp$1 = executionTimestamp$1;
            }
        });
        return settable$1;
    }

    public AsyncExecutor(Function1<T, ListenableFuture<R>> asyncAction, int maxConcurrentTasks, Option<Function3<T, Object, Object, BoxedUnit>> successHandler, Option<Function3<T, Object, Object, BoxedUnit>> failureHandler) {
        this.asyncAction = asyncAction;
        this.com$datastax$spark$connector$writer$AsyncExecutor$$successHandler = successHandler;
        this.com$datastax$spark$connector$writer$AsyncExecutor$$failureHandler = failureHandler;
        Logging$class.$init$(this);
        this.com$datastax$spark$connector$writer$AsyncExecutor$$semaphore = new Semaphore(maxConcurrentTasks);
        this.com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures = new TrieMap();
        this.com$datastax$spark$connector$writer$AsyncExecutor$$latestException = None$.MODULE$;
    }
}

