/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.redis;

import io.netty.util.CharsetUtil;
import io.netty.util.internal.PlatformDependent;

final class RedisCodecUtil {
    private RedisCodecUtil() {
    }

    static byte[] longToAsciiBytes(long value2) {
        return Long.toString(value2).getBytes(CharsetUtil.US_ASCII);
    }

    static short makeShort(char first, char second) {
        return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? (short)(second << 8 | first) : (short)(first << 8 | second);
    }

    static byte[] shortToBytes(short value2) {
        byte[] bytes = new byte[2];
        if (PlatformDependent.BIG_ENDIAN_NATIVE_ORDER) {
            bytes[1] = (byte)(value2 >> 8 & 0xFF);
            bytes[0] = (byte)(value2 & 0xFF);
        } else {
            bytes[0] = (byte)(value2 >> 8 & 0xFF);
            bytes[1] = (byte)(value2 & 0xFF);
        }
        return bytes;
    }
}

