/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.converters;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.AbstractConverter;

public abstract class NumberConverter
extends AbstractConverter {
    private static final Integer ZERO = new Integer(0);
    private static final Integer ONE = new Integer(1);
    private String pattern;
    private final boolean allowDecimals;
    private boolean useLocaleFormat;
    private Locale locale;

    public NumberConverter(boolean allowDecimals) {
        this.allowDecimals = allowDecimals;
    }

    public NumberConverter(boolean allowDecimals, Object defaultValue) {
        this.allowDecimals = allowDecimals;
        this.setDefaultValue(defaultValue);
    }

    public boolean isAllowDecimals() {
        return this.allowDecimals;
    }

    public void setUseLocaleFormat(boolean useLocaleFormat) {
        this.useLocaleFormat = useLocaleFormat;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.setUseLocaleFormat(true);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.setUseLocaleFormat(true);
    }

    @Override
    protected String convertToString(Object value2) throws Throwable {
        String result = null;
        if (this.useLocaleFormat && value2 instanceof Number) {
            NumberFormat format = this.getFormat();
            format.setGroupingUsed(false);
            result = format.format(value2);
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("    Converted  to String using format '" + result + "'"));
            }
        } else {
            result = value2.toString();
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("    Converted  to String using toString() '" + result + "'"));
            }
        }
        return result;
    }

    @Override
    protected <T> T convertToType(Class<T> targetType, Object value2) throws Throwable {
        Class<?> sourceType = value2.getClass();
        if (value2 instanceof Number) {
            return this.toNumber(sourceType, targetType, (Number)value2);
        }
        if (value2 instanceof Boolean) {
            return this.toNumber(sourceType, targetType, (Boolean)value2 != false ? ONE : ZERO);
        }
        if (value2 instanceof Date && Long.class.equals(targetType)) {
            return targetType.cast(new Long(((Date)value2).getTime()));
        }
        if (value2 instanceof Calendar && Long.class.equals(targetType)) {
            return targetType.cast(new Long(((Calendar)value2).getTime().getTime()));
        }
        String stringValue = value2.toString().trim();
        if (stringValue.length() == 0) {
            return this.handleMissing(targetType);
        }
        Number number = null;
        if (this.useLocaleFormat) {
            NumberFormat format = this.getFormat();
            number = this.parse(sourceType, targetType, stringValue, format);
        } else {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"    No NumberFormat, using default conversion");
            }
            number = this.toNumber(sourceType, targetType, stringValue);
        }
        return this.toNumber(sourceType, targetType, number);
    }

    private <T> T toNumber(Class<?> sourceType, Class<T> targetType, Number value2) {
        if (targetType.equals(value2.getClass())) {
            return targetType.cast(value2);
        }
        if (targetType.equals(Byte.class)) {
            long longValue = value2.longValue();
            if (longValue > 127L) {
                throw new ConversionException(this.toString(sourceType) + " value '" + value2 + "' is too large for " + this.toString(targetType));
            }
            if (longValue < -128L) {
                throw new ConversionException(this.toString(sourceType) + " value '" + value2 + "' is too small " + this.toString(targetType));
            }
            return targetType.cast(new Byte(value2.byteValue()));
        }
        if (targetType.equals(Short.class)) {
            long longValue = value2.longValue();
            if (longValue > 32767L) {
                throw new ConversionException(this.toString(sourceType) + " value '" + value2 + "' is too large for " + this.toString(targetType));
            }
            if (longValue < -32768L) {
                throw new ConversionException(this.toString(sourceType) + " value '" + value2 + "' is too small " + this.toString(targetType));
            }
            return targetType.cast(new Short(value2.shortValue()));
        }
        if (targetType.equals(Integer.class)) {
            long longValue = value2.longValue();
            if (longValue > Integer.MAX_VALUE) {
                throw new ConversionException(this.toString(sourceType) + " value '" + value2 + "' is too large for " + this.toString(targetType));
            }
            if (longValue < Integer.MIN_VALUE) {
                throw new ConversionException(this.toString(sourceType) + " value '" + value2 + "' is too small " + this.toString(targetType));
            }
            return targetType.cast(new Integer(value2.intValue()));
        }
        if (targetType.equals(Long.class)) {
            return targetType.cast(new Long(value2.longValue()));
        }
        if (targetType.equals(Float.class)) {
            if (value2.doubleValue() > 3.4028234663852886E38) {
                throw new ConversionException(this.toString(sourceType) + " value '" + value2 + "' is too large for " + this.toString(targetType));
            }
            return targetType.cast(new Float(value2.floatValue()));
        }
        if (targetType.equals(Double.class)) {
            return targetType.cast(new Double(value2.doubleValue()));
        }
        if (targetType.equals(BigDecimal.class)) {
            if (value2 instanceof Float || value2 instanceof Double) {
                return targetType.cast(new BigDecimal(value2.toString()));
            }
            if (value2 instanceof BigInteger) {
                return targetType.cast(new BigDecimal((BigInteger)value2));
            }
            if (value2 instanceof BigDecimal) {
                return targetType.cast(new BigDecimal(value2.toString()));
            }
            return targetType.cast(BigDecimal.valueOf(value2.longValue()));
        }
        if (targetType.equals(BigInteger.class)) {
            if (value2 instanceof BigDecimal) {
                return targetType.cast(((BigDecimal)value2).toBigInteger());
            }
            return targetType.cast(BigInteger.valueOf(value2.longValue()));
        }
        String msg = this.toString(this.getClass()) + " cannot handle conversion to '" + this.toString(targetType) + "'";
        if (this.log().isWarnEnabled()) {
            this.log().warn((Object)("    " + msg));
        }
        throw new ConversionException(msg);
    }

    private Number toNumber(Class<?> sourceType, Class<?> targetType, String value2) {
        if (targetType.equals(Byte.class)) {
            return new Byte(value2);
        }
        if (targetType.equals(Short.class)) {
            return new Short(value2);
        }
        if (targetType.equals(Integer.class)) {
            return new Integer(value2);
        }
        if (targetType.equals(Long.class)) {
            return new Long(value2);
        }
        if (targetType.equals(Float.class)) {
            return new Float(value2);
        }
        if (targetType.equals(Double.class)) {
            return new Double(value2);
        }
        if (targetType.equals(BigDecimal.class)) {
            return new BigDecimal(value2);
        }
        if (targetType.equals(BigInteger.class)) {
            return new BigInteger(value2);
        }
        String msg = this.toString(this.getClass()) + " cannot handle conversion from '" + this.toString(sourceType) + "' to '" + this.toString(targetType) + "'";
        if (this.log().isWarnEnabled()) {
            this.log().warn((Object)("    " + msg));
        }
        throw new ConversionException(msg);
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.toString(this.getClass()));
        buffer.append("[UseDefault=");
        buffer.append(this.isUseDefault());
        buffer.append(", UseLocaleFormat=");
        buffer.append(this.useLocaleFormat);
        if (this.pattern != null) {
            buffer.append(", Pattern=");
            buffer.append(this.pattern);
        }
        if (this.locale != null) {
            buffer.append(", Locale=");
            buffer.append(this.locale);
        }
        buffer.append(']');
        return buffer.toString();
    }

    private NumberFormat getFormat() {
        NumberFormat format = null;
        if (this.pattern != null) {
            if (this.locale == null) {
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("    Using pattern '" + this.pattern + "'"));
                }
                format = new DecimalFormat(this.pattern);
            } else {
                if (this.log().isDebugEnabled()) {
                    this.log().debug((Object)("    Using pattern '" + this.pattern + "'" + " with Locale[" + this.locale + "]"));
                }
                DecimalFormatSymbols symbols = new DecimalFormatSymbols(this.locale);
                format = new DecimalFormat(this.pattern, symbols);
            }
        } else if (this.locale == null) {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)"    Using default Locale format");
            }
            format = NumberFormat.getInstance();
        } else {
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("    Using Locale[" + this.locale + "] format"));
            }
            format = NumberFormat.getInstance(this.locale);
        }
        if (!this.allowDecimals) {
            format.setParseIntegerOnly(true);
        }
        return format;
    }

    private Number parse(Class<?> sourceType, Class<?> targetType, String value2, NumberFormat format) {
        ParsePosition pos = new ParsePosition(0);
        Number parsedNumber = format.parse(value2, pos);
        if (pos.getErrorIndex() >= 0 || pos.getIndex() != value2.length() || parsedNumber == null) {
            String msg = "Error converting from '" + this.toString(sourceType) + "' to '" + this.toString(targetType) + "'";
            if (format instanceof DecimalFormat) {
                msg = msg + " using pattern '" + ((DecimalFormat)format).toPattern() + "'";
            }
            if (this.locale != null) {
                msg = msg + " for locale=[" + this.locale + "]";
            }
            if (this.log().isDebugEnabled()) {
                this.log().debug((Object)("    " + msg));
            }
            throw new ConversionException(msg);
        }
        return parsedNumber;
    }
}

