/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.joda.convert.ReflectionStringConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MethodConstructorStringConverter<T>
extends ReflectionStringConverter<T> {
    private final Constructor<T> fromString;

    MethodConstructorStringConverter(Class<T> clazz, Method method2, Constructor<T> constructor) {
        super(clazz, method2);
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers()) || clazz.isLocalClass() || clazz.isMemberClass()) {
            throw new IllegalArgumentException("FromString constructor must be on an instantiable class");
        }
        if (constructor.getDeclaringClass() != clazz) {
            throw new IllegalStateException("FromString constructor must be defined on specified class");
        }
        this.fromString = constructor;
    }

    @Override
    public T convertFromString(Class<? extends T> clazz, String string) {
        try {
            return this.fromString.newInstance(string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException("Constructor is not accessible");
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException("Constructor is not valid");
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException.getCause();
            }
            throw new RuntimeException(invocationTargetException.getMessage(), invocationTargetException.getCause());
        }
    }
}

