/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shade.com.datastax.spark.connector.driver.core.ClusterNameMismatchException;
import shade.com.datastax.spark.connector.driver.core.Connection;
import shade.com.datastax.spark.connector.driver.core.Host;
import shade.com.datastax.spark.connector.driver.core.exceptions.AuthenticationException;
import shade.com.datastax.spark.connector.driver.core.exceptions.ConnectionException;
import shade.com.datastax.spark.connector.driver.core.exceptions.UnsupportedProtocolVersionException;
import shade.com.datastax.spark.connector.driver.core.policies.ReconnectionPolicy;
import shade.com.datastax.spark.connector.google.common.annotations.VisibleForTesting;
import shade.com.datastax.spark.connector.google.common.util.concurrent.AbstractFuture;
import shade.com.datastax.spark.connector.google.common.util.concurrent.ListenableFuture;

abstract class AbstractReconnectionHandler
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractReconnectionHandler.class);
    private final String name;
    private final ScheduledExecutorService executor;
    private final ReconnectionPolicy.ReconnectionSchedule schedule;
    private final AtomicReference<ListenableFuture<?>> currentAttempt;
    @VisibleForTesting
    final HandlerFuture handlerFuture = new HandlerFuture();
    private final long initialDelayMs;
    private final CountDownLatch ready = new CountDownLatch(1);

    public AbstractReconnectionHandler(String name, ScheduledExecutorService executor, ReconnectionPolicy.ReconnectionSchedule schedule, AtomicReference<ListenableFuture<?>> currentAttempt) {
        this(name, executor, schedule, currentAttempt, -1L);
    }

    public AbstractReconnectionHandler(String name, ScheduledExecutorService executor, ReconnectionPolicy.ReconnectionSchedule schedule, AtomicReference<ListenableFuture<?>> currentAttempt, long initialDelayMs) {
        this.name = name;
        this.executor = executor;
        this.schedule = schedule;
        this.currentAttempt = currentAttempt;
        this.initialDelayMs = initialDelayMs;
    }

    protected abstract Connection tryReconnect() throws ConnectionException, InterruptedException, UnsupportedProtocolVersionException, ClusterNameMismatchException;

    protected abstract void onReconnection(Connection var1);

    protected boolean onConnectionException(ConnectionException e, long nextDelayMs) {
        return true;
    }

    protected boolean onUnknownException(Exception e, long nextDelayMs) {
        return true;
    }

    protected boolean onAuthenticationException(AuthenticationException e, long nextDelayMs) {
        return true;
    }

    protected boolean onUnsupportedProtocolVersionException(UnsupportedProtocolVersionException e, long nextDelayMs) {
        return false;
    }

    protected boolean onClusterNameMismatchException(ClusterNameMismatchException e, long nextDelayMs) {
        return false;
    }

    public void start() {
        long firstDelay = this.initialDelayMs >= 0L ? this.initialDelayMs : this.schedule.nextDelayMs();
        logger.debug("First reconnection scheduled in {}ms", (Object)firstDelay);
        try {
            block3: {
                ListenableFuture<?> previous;
                this.handlerFuture.nextTry = this.executor.schedule(this, firstDelay, TimeUnit.MILLISECONDS);
                do {
                    if ((previous = this.currentAttempt.get()) == null || previous.isCancelled()) continue;
                    logger.debug("Found another already active handler, cancelling");
                    this.handlerFuture.cancel(false);
                    break block3;
                } while (!this.currentAttempt.compareAndSet(previous, this.handlerFuture));
                Host.statesLogger.debug("[{}] starting reconnection attempt", (Object)this.name);
            }
            this.ready.countDown();
        }
        catch (RejectedExecutionException e) {
            logger.debug("Aborting reconnection handling since the cluster is shutting down");
        }
    }

    @Override
    public void run() {
        try {
            this.ready.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        if (this.handlerFuture.isCancelled()) {
            logger.debug("Got cancelled, stopping");
            return;
        }
        try {
            this.onReconnection(this.tryReconnect());
            this.handlerFuture.markAsDone();
            this.currentAttempt.compareAndSet(this.handlerFuture, null);
            logger.debug("Reconnection successful, cleared the future");
        }
        catch (ConnectionException e) {
            long nextDelay = this.schedule.nextDelayMs();
            if (this.onConnectionException(e, nextDelay)) {
                this.reschedule(nextDelay);
            } else {
                this.currentAttempt.compareAndSet(this.handlerFuture, null);
            }
        }
        catch (AuthenticationException e) {
            logger.error(e.getMessage());
            long nextDelay = this.schedule.nextDelayMs();
            if (this.onAuthenticationException(e, nextDelay)) {
                this.reschedule(nextDelay);
            } else {
                logger.error("Retries against {} have been suspended. It won't be retried unless the node is restarted.", (Object)e.getHost());
                this.currentAttempt.compareAndSet(this.handlerFuture, null);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (UnsupportedProtocolVersionException e) {
            logger.error(e.getMessage());
            long nextDelay = this.schedule.nextDelayMs();
            if (this.onUnsupportedProtocolVersionException(e, nextDelay)) {
                this.reschedule(nextDelay);
            } else {
                logger.error("Retries against {} have been suspended. It won't be retried unless the node is restarted.", (Object)e.getHost());
                this.currentAttempt.compareAndSet(this.handlerFuture, null);
            }
        }
        catch (ClusterNameMismatchException e) {
            logger.error(e.getMessage());
            long nextDelay = this.schedule.nextDelayMs();
            if (this.onClusterNameMismatchException(e, nextDelay)) {
                this.reschedule(nextDelay);
            } else {
                logger.error("Retries against {} have been suspended. It won't be retried unless the node is restarted.", (Object)e.address.getAddress());
                this.currentAttempt.compareAndSet(this.handlerFuture, null);
            }
        }
        catch (Exception e) {
            long nextDelay = this.schedule.nextDelayMs();
            if (this.onUnknownException(e, nextDelay)) {
                this.reschedule(nextDelay);
            }
            this.currentAttempt.compareAndSet(this.handlerFuture, null);
        }
    }

    private void reschedule(long nextDelay) {
        if (this.handlerFuture.isCancelled()) {
            this.currentAttempt.compareAndSet(this.handlerFuture, null);
            return;
        }
        Host.statesLogger.debug("[{}] next reconnection attempt in {} ms", (Object)this.name, (Object)nextDelay);
        this.handlerFuture.nextTry = this.executor.schedule(this, nextDelay, TimeUnit.MILLISECONDS);
    }

    @VisibleForTesting
    static class HandlerFuture
    extends AbstractFuture<Void> {
        volatile ScheduledFuture<?> nextTry;

        HandlerFuture() {
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.nextTry != null) {
                this.nextTry.cancel(mayInterruptIfRunning);
            }
            return super.cancel(mayInterruptIfRunning);
        }

        void markAsDone() {
            super.set(null);
        }
    }
}

