/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import shade.com.datastax.spark.connector.driver.core.BoundStatement;
import shade.com.datastax.spark.connector.driver.core.CodecRegistry;
import shade.com.datastax.spark.connector.driver.core.ConsistencyLevel;
import shade.com.datastax.spark.connector.driver.core.ProtocolVersion;
import shade.com.datastax.spark.connector.driver.core.RegularStatement;
import shade.com.datastax.spark.connector.driver.core.Statement;
import shade.com.datastax.spark.connector.driver.core.StatementWrapper;
import shade.com.datastax.spark.connector.google.common.collect.ImmutableList;

public class BatchStatement
extends Statement {
    final Type batchType;
    private final List<Statement> statements = new ArrayList<Statement>();

    public BatchStatement() {
        this(Type.LOGGED);
    }

    public BatchStatement(Type batchType) {
        this.batchType = batchType;
    }

    IdAndValues getIdAndValues(ProtocolVersion protocolVersion2, CodecRegistry codecRegistry) {
        IdAndValues idAndVals = new IdAndValues(this.statements.size());
        for (Statement statement : this.statements) {
            Statement st;
            if (statement instanceof StatementWrapper) {
                statement = ((StatementWrapper)statement).getWrappedStatement();
            }
            if (statement instanceof RegularStatement) {
                st = (RegularStatement)statement;
                ByteBuffer[] vals = ((RegularStatement)st).getValues(protocolVersion2, codecRegistry);
                String query = ((RegularStatement)st).getQueryString(codecRegistry);
                idAndVals.ids.add(query);
                idAndVals.values.add(vals == null ? Collections.emptyList() : Arrays.asList(vals));
                continue;
            }
            assert (statement instanceof BoundStatement);
            st = (BoundStatement)statement;
            idAndVals.ids.add(((BoundStatement)st).statement.getPreparedId().id);
            idAndVals.values.add(Arrays.asList(((BoundStatement)st).wrapper.values));
        }
        return idAndVals;
    }

    public BatchStatement add(Statement statement) {
        if (statement instanceof StatementWrapper) {
            statement = ((StatementWrapper)statement).getWrappedStatement();
        }
        if (statement instanceof RegularStatement && ((RegularStatement)statement).usesNamedValues()) {
            throw new IllegalArgumentException("Batch statement cannot contain regular statements with named values (" + ((RegularStatement)statement).getQueryString() + ")");
        }
        if (statement instanceof BatchStatement) {
            for (Statement subStatements : ((BatchStatement)statement).statements) {
                this.add(subStatements);
            }
        } else {
            if (this.statements.size() >= 65535) {
                throw new IllegalStateException("Batch statement cannot contain more than 65535 statements.");
            }
            this.statements.add(statement);
        }
        return this;
    }

    public BatchStatement addAll(Iterable<? extends Statement> statements) {
        for (Statement statement : statements) {
            this.add(statement);
        }
        return this;
    }

    public Collection<Statement> getStatements() {
        return ImmutableList.copyOf(this.statements);
    }

    public BatchStatement clear() {
        this.statements.clear();
        return this;
    }

    public int size() {
        return this.statements.size();
    }

    @Override
    public BatchStatement setSerialConsistencyLevel(ConsistencyLevel serialConsistency) {
        return (BatchStatement)super.setSerialConsistencyLevel(serialConsistency);
    }

    @Override
    public ByteBuffer getRoutingKey(ProtocolVersion protocolVersion2, CodecRegistry codecRegistry) {
        for (Statement statement : this.statements) {
            ByteBuffer rk;
            if (statement instanceof StatementWrapper) {
                statement = ((StatementWrapper)statement).getWrappedStatement();
            }
            if ((rk = statement.getRoutingKey(protocolVersion2, codecRegistry)) == null) continue;
            return rk;
        }
        return null;
    }

    @Override
    public String getKeyspace() {
        for (Statement statement : this.statements) {
            String keyspace = statement.getKeyspace();
            if (keyspace == null) continue;
            return keyspace;
        }
        return null;
    }

    @Override
    public Boolean isIdempotent() {
        if (this.idempotent != null) {
            return this.idempotent;
        }
        return BatchStatement.isBatchIdempotent(this.statements);
    }

    void ensureAllSet() {
        for (Statement statement : this.statements) {
            if (!(statement instanceof BoundStatement)) continue;
            ((BoundStatement)statement).ensureAllSet();
        }
    }

    static class IdAndValues {
        public final List<Object> ids;
        public final List<List<ByteBuffer>> values;

        IdAndValues(int nbstatements) {
            this.ids = new ArrayList<Object>(nbstatements);
            this.values = new ArrayList<List<ByteBuffer>>(nbstatements);
        }
    }

    public static enum Type {
        LOGGED,
        UNLOGGED,
        COUNTER;

    }
}

