/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shade.com.datastax.spark.connector.driver.core.Clock;
import shade.com.datastax.spark.connector.driver.core.Native;
import shade.com.datastax.spark.connector.driver.core.NativeClock;
import shade.com.datastax.spark.connector.driver.core.SystemClock;
import shade.com.datastax.spark.connector.driver.core.SystemProperties;

class ClockFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClockFactory.class);
    private static final String USE_NATIVE_CLOCK_SYSTEM_PROPERTY = "shade.com.datastax.spark.connector.driver.USE_NATIVE_CLOCK";

    ClockFactory() {
    }

    static Clock newInstance() {
        if (SystemProperties.getBoolean(USE_NATIVE_CLOCK_SYSTEM_PROPERTY, true) && Native.isGettimeofdayAvailable()) {
            LOGGER.info("Using native clock to generate timestamps.");
            return new NativeClock();
        }
        LOGGER.info("Using java.lang.System clock to generate timestamps.");
        return new SystemClock();
    }
}

