/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core;

import java.nio.ByteBuffer;
import shade.com.datastax.spark.connector.driver.core.ProtocolVersion;

public final class CodecUtils {
    private static final long MAX_CQL_LONG_VALUE = 0xFFFFFFFFL;
    private static final long EPOCH_AS_CQL_LONG = 0x80000000L;

    private CodecUtils() {
    }

    public static ByteBuffer pack(ByteBuffer[] buffers, int elements, ProtocolVersion version) {
        int size = 0;
        for (ByteBuffer bb : buffers) {
            int elemSize = CodecUtils.sizeOfValue(bb, version);
            size += elemSize;
        }
        ByteBuffer result = ByteBuffer.allocate(CodecUtils.sizeOfCollectionSize(version) + size);
        CodecUtils.writeSize(result, elements, version);
        for (ByteBuffer bb : buffers) {
            CodecUtils.writeValue(result, bb, version);
        }
        return (ByteBuffer)result.flip();
    }

    public static int readSize(ByteBuffer input, ProtocolVersion version) {
        switch (version) {
            case V1: 
            case V2: {
                return CodecUtils.getUnsignedShort(input);
            }
            case V3: 
            case V4: {
                return input.getInt();
            }
        }
        throw version.unsupported();
    }

    public static void writeSize(ByteBuffer output, int size, ProtocolVersion version) {
        switch (version) {
            case V1: 
            case V2: {
                if (size > 65535) {
                    throw new IllegalArgumentException(String.format("Native protocol version %d supports up to 65535 elements in any collection - but collection contains %d elements", version.toInt(), size));
                }
                output.putShort((short)size);
                break;
            }
            case V3: 
            case V4: {
                output.putInt(size);
                break;
            }
            default: {
                throw version.unsupported();
            }
        }
    }

    public static ByteBuffer readValue(ByteBuffer input, ProtocolVersion version) {
        int size = CodecUtils.readSize(input, version);
        return size < 0 ? null : CodecUtils.readBytes(input, size);
    }

    public static void writeValue(ByteBuffer output, ByteBuffer value2, ProtocolVersion version) {
        switch (version) {
            case V1: 
            case V2: {
                assert (value2 != null);
                output.putShort((short)value2.remaining());
                output.put(value2.duplicate());
                break;
            }
            case V3: 
            case V4: {
                if (value2 == null) {
                    output.putInt(-1);
                    break;
                }
                output.putInt(value2.remaining());
                output.put(value2.duplicate());
                break;
            }
            default: {
                throw version.unsupported();
            }
        }
    }

    public static ByteBuffer readBytes(ByteBuffer bb, int length) {
        ByteBuffer copy2 = bb.duplicate();
        copy2.limit(copy2.position() + length);
        bb.position(bb.position() + length);
        return copy2;
    }

    public static int fromUnsignedToSignedInt(int unsigned) {
        return unsigned + Integer.MIN_VALUE;
    }

    public static int fromSignedToUnsignedInt(int signed) {
        return signed - Integer.MIN_VALUE;
    }

    public static int fromCqlDateToDaysSinceEpoch(long raw) {
        if (raw < 0L || raw > 0xFFFFFFFFL) {
            throw new IllegalArgumentException(String.format("Numeric literals for DATE must be between 0 and %d (got %d)", 0xFFFFFFFFL, raw));
        }
        return (int)(raw - 0x80000000L);
    }

    public static long fromDaysSinceEpochToCqlDate(int days) {
        return (long)days + 0x80000000L;
    }

    private static int sizeOfCollectionSize(ProtocolVersion version) {
        switch (version) {
            case V1: 
            case V2: {
                return 2;
            }
            case V3: 
            case V4: {
                return 4;
            }
        }
        throw version.unsupported();
    }

    private static int sizeOfValue(ByteBuffer value2, ProtocolVersion version) {
        switch (version) {
            case V1: 
            case V2: {
                int elemSize = value2.remaining();
                if (elemSize > 65535) {
                    throw new IllegalArgumentException(String.format("Native protocol version %d supports only elements with size up to 65535 bytes - but element size is %d bytes", version.toInt(), elemSize));
                }
                return 2 + elemSize;
            }
            case V3: 
            case V4: {
                return value2 == null ? 4 : 4 + value2.remaining();
            }
        }
        throw version.unsupported();
    }

    private static int getUnsignedShort(ByteBuffer bb) {
        int length = (bb.get() & 0xFF) << 8;
        return length | bb.get() & 0xFF;
    }
}

