/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core;

import java.util.HashMap;
import java.util.Map;
import shade.com.datastax.spark.connector.driver.core.exceptions.DriverInternalError;

enum ExceptionCode {
    SERVER_ERROR(0),
    PROTOCOL_ERROR(10),
    BAD_CREDENTIALS(256),
    UNAVAILABLE(4096),
    OVERLOADED(4097),
    IS_BOOTSTRAPPING(4098),
    TRUNCATE_ERROR(4099),
    WRITE_TIMEOUT(4352),
    READ_TIMEOUT(4608),
    READ_FAILURE(4864),
    FUNCTION_FAILURE(5120),
    WRITE_FAILURE(5376),
    SYNTAX_ERROR(8192),
    UNAUTHORIZED(8448),
    INVALID(8704),
    CONFIG_ERROR(8960),
    ALREADY_EXISTS(9216),
    UNPREPARED(9472);

    public final int value;
    private static final Map<Integer, ExceptionCode> valueToCode;

    private ExceptionCode(int value2) {
        this.value = value2;
    }

    public static ExceptionCode fromValue(int value2) {
        ExceptionCode code = valueToCode.get(value2);
        if (code == null) {
            throw new DriverInternalError(String.format("Unknown error code %d", value2));
        }
        return code;
    }

    static {
        valueToCode = new HashMap<Integer, ExceptionCode>(ExceptionCode.values().length);
        for (ExceptionCode code : ExceptionCode.values()) {
            valueToCode.put(code.value, code);
        }
    }
}

