/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import shade.com.datastax.spark.connector.driver.core.Clock;
import shade.com.datastax.spark.connector.driver.core.Native;

class NativeClock
implements Clock {
    private static final long ONE_SECOND_NS = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS);
    private static final long ONE_MILLISECOND_NS = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.MILLISECONDS);
    private final AtomicReference<FetchedTime> lastFetchedTime = new AtomicReference<FetchedTime>(NativeClock.fetchTimeMicros());

    NativeClock() {
    }

    @Override
    public long currentTimeMicros() {
        FetchedTime spec = this.lastFetchedTime.get();
        long curNano = System.nanoTime();
        if (curNano > spec.nanoTimeAtCheck + ONE_SECOND_NS) {
            FetchedTime fetchedTime = spec;
            spec = NativeClock.fetchTimeMicros();
            this.lastFetchedTime.compareAndSet(fetchedTime, spec);
        }
        return spec.timeInMicros + (curNano - spec.nanoTimeAtCheck) / 1000L;
    }

    private static FetchedTime fetchTimeMicros() {
        long start = System.nanoTime();
        long micros = Native.currentTimeMicros();
        long end = System.nanoTime();
        if (end - start > ONE_MILLISECOND_NS) {
            return new FetchedTime(System.currentTimeMillis() * 1000L, System.nanoTime());
        }
        return new FetchedTime(micros, (end + start) / 2L);
    }

    private static class FetchedTime {
        private final long timeInMicros;
        private final long nanoTimeAtCheck;

        private FetchedTime(long timeInMicros, long nanoTimeAtCheck) {
            this.timeInMicros = timeInMicros;
            this.nanoTimeAtCheck = nanoTimeAtCheck;
        }
    }
}

