/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import java.util.concurrent.ThreadFactory;
import shade.com.datastax.spark.connector.driver.core.NettyUtil;

public class NettyOptions {
    public static final NettyOptions DEFAULT_INSTANCE = new NettyOptions();

    public EventLoopGroup eventLoopGroup(ThreadFactory threadFactory) {
        return NettyUtil.newEventLoopGroupInstance(threadFactory);
    }

    public Class<? extends SocketChannel> channelClass() {
        return NettyUtil.channelClass();
    }

    public void afterBootstrapInitialized(Bootstrap bootstrap) {
        bootstrap.option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
    }

    public void afterChannelInitialized(SocketChannel channel) throws Exception {
    }

    public void onClusterClose(EventLoopGroup eventLoopGroup) {
        eventLoopGroup.shutdownGracefully().syncUninterruptibly();
    }

    public Timer timer(ThreadFactory threadFactory) {
        return new HashedWheelTimer(threadFactory);
    }

    public void onClusterClose(Timer timer) {
        timer.stop();
    }
}

