/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core;

import shade.com.datastax.spark.connector.driver.core.AuthProvider;
import shade.com.datastax.spark.connector.driver.core.Cluster;
import shade.com.datastax.spark.connector.driver.core.FrameCompressor;
import shade.com.datastax.spark.connector.driver.core.LZ4Compressor;
import shade.com.datastax.spark.connector.driver.core.ProtocolVersion;
import shade.com.datastax.spark.connector.driver.core.SSLOptions;
import shade.com.datastax.spark.connector.driver.core.SnappyCompressor;
import shade.com.datastax.spark.connector.google.common.annotations.VisibleForTesting;

public class ProtocolOptions {
    public static final int DEFAULT_PORT = 9042;
    public static final int DEFAULT_MAX_SCHEMA_AGREEMENT_WAIT_SECONDS = 10;
    private volatile Cluster.Manager manager;
    private final int port;
    final ProtocolVersion initialProtocolVersion;
    @VisibleForTesting
    volatile int maxSchemaAgreementWaitSeconds;
    private final SSLOptions sslOptions;
    private final AuthProvider authProvider;
    private volatile Compression compression = Compression.NONE;

    public ProtocolOptions() {
        this(9042);
    }

    public ProtocolOptions(int port) {
        this(port, null, 10, null, AuthProvider.NONE);
    }

    public ProtocolOptions(int port, ProtocolVersion protocolVersion2, int maxSchemaAgreementWaitSeconds, SSLOptions sslOptions, AuthProvider authProvider) {
        this.port = port;
        this.initialProtocolVersion = protocolVersion2;
        this.maxSchemaAgreementWaitSeconds = maxSchemaAgreementWaitSeconds;
        this.sslOptions = sslOptions;
        this.authProvider = authProvider;
    }

    void register(Cluster.Manager manager) {
        this.manager = manager;
    }

    public int getPort() {
        return this.port;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.manager == null || this.manager.connectionFactory == null ? null : this.manager.connectionFactory.protocolVersion;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public ProtocolOptions setCompression(Compression compression) {
        if (compression != Compression.NONE && compression.compressor() == null) {
            throw new IllegalStateException("The requested compression is not available (some compression require a JAR to be found in the classpath)");
        }
        this.compression = compression;
        return this;
    }

    public int getMaxSchemaAgreementWaitSeconds() {
        return this.maxSchemaAgreementWaitSeconds;
    }

    public SSLOptions getSSLOptions() {
        return this.sslOptions;
    }

    public AuthProvider getAuthProvider() {
        return this.authProvider;
    }

    public static enum Compression {
        NONE(""){

            @Override
            FrameCompressor compressor() {
                return null;
            }
        }
        ,
        SNAPPY("snappy"){

            @Override
            FrameCompressor compressor() {
                return SnappyCompressor.instance;
            }
        }
        ,
        LZ4("lz4"){

            @Override
            FrameCompressor compressor() {
                return LZ4Compressor.instance;
            }
        };

        final String protocolName;

        private Compression(String protocolName) {
            this.protocolName = protocolName;
        }

        abstract FrameCompressor compressor();

        static Compression fromString(String str2) {
            for (Compression c : Compression.values()) {
                if (!c.protocolName.equalsIgnoreCase(str2)) continue;
                return c;
            }
            return null;
        }

        public String toString() {
            return this.protocolName;
        }
    }
}

