/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core;

import java.util.Map;
import shade.com.datastax.spark.connector.driver.core.Host;
import shade.com.datastax.spark.connector.driver.core.VersionNumber;
import shade.com.datastax.spark.connector.driver.core.exceptions.DriverInternalError;
import shade.com.datastax.spark.connector.google.common.collect.ImmutableMap;

public enum ProtocolVersion {
    V1("1.2.0", 1),
    V2("2.0.0", 2),
    V3("2.1.0", 3),
    V4("2.2.0", 4);

    public static final ProtocolVersion NEWEST_SUPPORTED;
    private final VersionNumber minCassandraVersion;
    private final int asInt;
    private static final Map<Integer, ProtocolVersion> INT_TO_VERSION;

    private ProtocolVersion(String minCassandraVersion, int asInt) {
        this.minCassandraVersion = VersionNumber.parse(minCassandraVersion);
        this.asInt = asInt;
    }

    boolean isSupportedBy(Host host) {
        return host.getCassandraVersion() == null || this.isSupportedBy(host.getCassandraVersion());
    }

    VersionNumber minCassandraVersion() {
        return this.minCassandraVersion;
    }

    private boolean isSupportedBy(VersionNumber cassandraVersion) {
        return this.minCassandraVersion.compareTo(cassandraVersion.nextStable()) <= 0;
    }

    DriverInternalError unsupported() {
        return new DriverInternalError("Unsupported protocol version " + (Object)((Object)this));
    }

    public int toInt() {
        return this.asInt;
    }

    public static ProtocolVersion fromInt(int i) {
        ProtocolVersion version = INT_TO_VERSION.get(i);
        if (version == null) {
            throw new IllegalArgumentException("No protocol version matching integer version " + i);
        }
        return version;
    }

    static {
        NEWEST_SUPPORTED = V4;
        ImmutableMap.Builder<Integer, ProtocolVersion> builder = ImmutableMap.builder();
        for (ProtocolVersion version : ProtocolVersion.values()) {
            builder.put(version.asInt, version);
        }
        INT_TO_VERSION = builder.build();
    }
}

