/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core;

import shade.com.datastax.spark.connector.driver.core.Cluster;
import shade.com.datastax.spark.connector.driver.core.ConsistencyLevel;
import shade.com.datastax.spark.connector.driver.core.ProtocolVersion;
import shade.com.datastax.spark.connector.driver.core.exceptions.UnsupportedFeatureException;
import shade.com.datastax.spark.connector.driver.core.utils.MoreFutures;
import shade.com.datastax.spark.connector.google.common.util.concurrent.Futures;

public class QueryOptions {
    public static final ConsistencyLevel DEFAULT_CONSISTENCY_LEVEL = ConsistencyLevel.LOCAL_ONE;
    public static final ConsistencyLevel DEFAULT_SERIAL_CONSISTENCY_LEVEL = ConsistencyLevel.SERIAL;
    public static final int DEFAULT_FETCH_SIZE = 5000;
    public static final boolean DEFAULT_IDEMPOTENCE = false;
    public static final int DEFAULT_MAX_PENDING_REFRESH_NODE_LIST_REQUESTS = 20;
    public static final int DEFAULT_MAX_PENDING_REFRESH_NODE_REQUESTS = 20;
    public static final int DEFAULT_MAX_PENDING_REFRESH_SCHEMA_REQUESTS = 20;
    public static final int DEFAULT_REFRESH_NODE_LIST_INTERVAL_MILLIS = 1000;
    public static final int DEFAULT_REFRESH_NODE_INTERVAL_MILLIS = 1000;
    public static final int DEFAULT_REFRESH_SCHEMA_INTERVAL_MILLIS = 1000;
    private volatile ConsistencyLevel consistency = DEFAULT_CONSISTENCY_LEVEL;
    private volatile ConsistencyLevel serialConsistency = DEFAULT_SERIAL_CONSISTENCY_LEVEL;
    private volatile int fetchSize = 5000;
    private volatile boolean defaultIdempotence = false;
    private volatile boolean metadataEnabled = true;
    private volatile int maxPendingRefreshNodeListRequests = 20;
    private volatile int maxPendingRefreshNodeRequests = 20;
    private volatile int maxPendingRefreshSchemaRequests = 20;
    private volatile int refreshNodeListIntervalMillis = 1000;
    private volatile int refreshNodeIntervalMillis = 1000;
    private volatile int refreshSchemaIntervalMillis = 1000;
    private volatile boolean reprepareOnUp = true;
    private volatile Cluster.Manager manager;
    private volatile boolean prepareOnAllHosts = true;

    void register(Cluster.Manager manager) {
        this.manager = manager;
    }

    public QueryOptions setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistency = consistencyLevel;
        return this;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistency;
    }

    public QueryOptions setSerialConsistencyLevel(ConsistencyLevel serialConsistencyLevel) {
        this.serialConsistency = serialConsistencyLevel;
        return this;
    }

    public ConsistencyLevel getSerialConsistencyLevel() {
        return this.serialConsistency;
    }

    public QueryOptions setFetchSize(int fetchSize) {
        ProtocolVersion version;
        if (fetchSize <= 0) {
            throw new IllegalArgumentException("Invalid fetchSize, should be > 0, got " + fetchSize);
        }
        ProtocolVersion protocolVersion2 = version = this.manager == null ? null : this.manager.protocolVersion();
        if (fetchSize != Integer.MAX_VALUE && version == ProtocolVersion.V1) {
            throw new UnsupportedFeatureException(version, "Paging is not supported");
        }
        this.fetchSize = fetchSize;
        return this;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public QueryOptions setDefaultIdempotence(boolean defaultIdempotence) {
        this.defaultIdempotence = defaultIdempotence;
        return this;
    }

    public boolean getDefaultIdempotence() {
        return this.defaultIdempotence;
    }

    public QueryOptions setPrepareOnAllHosts(boolean prepareOnAllHosts) {
        this.prepareOnAllHosts = prepareOnAllHosts;
        return this;
    }

    public boolean isPrepareOnAllHosts() {
        return this.prepareOnAllHosts;
    }

    public QueryOptions setReprepareOnUp(boolean reprepareOnUp) {
        this.reprepareOnUp = reprepareOnUp;
        return this;
    }

    public boolean isReprepareOnUp() {
        return this.reprepareOnUp;
    }

    public QueryOptions setMetadataEnabled(boolean enabled) {
        boolean wasEnabled = this.metadataEnabled;
        this.metadataEnabled = enabled;
        if (!wasEnabled && enabled && this.manager != null) {
            Futures.addCallback(this.manager.submitNodeListRefresh(), new MoreFutures.SuccessCallback<Void>(){

                @Override
                public void onSuccess(Void result) {
                    QueryOptions.this.manager.submitSchemaRefresh(null, null, null, null);
                }
            });
        }
        return this;
    }

    public boolean isMetadataEnabled() {
        return this.metadataEnabled;
    }

    public QueryOptions setRefreshSchemaIntervalMillis(int refreshSchemaIntervalMillis) {
        this.refreshSchemaIntervalMillis = refreshSchemaIntervalMillis;
        return this;
    }

    public int getRefreshSchemaIntervalMillis() {
        return this.refreshSchemaIntervalMillis;
    }

    public QueryOptions setMaxPendingRefreshSchemaRequests(int maxPendingRefreshSchemaRequests) {
        this.maxPendingRefreshSchemaRequests = maxPendingRefreshSchemaRequests;
        return this;
    }

    public int getMaxPendingRefreshSchemaRequests() {
        return this.maxPendingRefreshSchemaRequests;
    }

    public QueryOptions setRefreshNodeListIntervalMillis(int refreshNodeListIntervalMillis) {
        this.refreshNodeListIntervalMillis = refreshNodeListIntervalMillis;
        return this;
    }

    public int getRefreshNodeListIntervalMillis() {
        return this.refreshNodeListIntervalMillis;
    }

    public QueryOptions setMaxPendingRefreshNodeListRequests(int maxPendingRefreshNodeListRequests) {
        this.maxPendingRefreshNodeListRequests = maxPendingRefreshNodeListRequests;
        return this;
    }

    public int getMaxPendingRefreshNodeListRequests() {
        return this.maxPendingRefreshNodeListRequests;
    }

    public QueryOptions setRefreshNodeIntervalMillis(int refreshNodeIntervalMillis) {
        this.refreshNodeIntervalMillis = refreshNodeIntervalMillis;
        return this;
    }

    public int getRefreshNodeIntervalMillis() {
        return this.refreshNodeIntervalMillis;
    }

    public QueryOptions setMaxPendingRefreshNodeRequests(int maxPendingRefreshNodeRequests) {
        this.maxPendingRefreshNodeRequests = maxPendingRefreshNodeRequests;
        return this;
    }

    public int getMaxPendingRefreshNodeRequests() {
        return this.maxPendingRefreshNodeRequests;
    }
}

