/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class SimpleJSONParser {
    private final String input;
    private int idx;

    private SimpleJSONParser(String input) {
        this.input = input;
    }

    public static List<String> parseStringList(String input) {
        if (input == null || input.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> output = new ArrayList<String>();
        SimpleJSONParser parser = new SimpleJSONParser(input);
        if (parser.nextCharSkipSpaces() != '[') {
            throw new IllegalArgumentException("Not a JSON list: " + input);
        }
        char c = parser.nextCharSkipSpaces();
        if (c == ']') {
            return output;
        }
        while (true) {
            assert (c == '\"');
            output.add(parser.nextString());
            c = parser.nextCharSkipSpaces();
            if (c == ']') {
                return output;
            }
            assert (c == ',');
            c = parser.nextCharSkipSpaces();
        }
    }

    public static Map<String, String> parseStringMap(String input) {
        if (input == null || input.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> output = new HashMap<String, String>();
        SimpleJSONParser parser = new SimpleJSONParser(input);
        if (parser.nextCharSkipSpaces() != '{') {
            throw new IllegalArgumentException("Not a JSON map: " + input);
        }
        char c = parser.nextCharSkipSpaces();
        if (c == '}') {
            return output;
        }
        while (true) {
            assert (c == '\"');
            String key = parser.nextString();
            c = parser.nextCharSkipSpaces();
            assert (c == ':');
            c = parser.nextCharSkipSpaces();
            assert (c == '\"');
            String value2 = parser.nextString();
            output.put(key, value2);
            c = parser.nextCharSkipSpaces();
            if (c == '}') {
                return output;
            }
            assert (c == ',');
            c = parser.nextCharSkipSpaces();
        }
    }

    private char nextChar() {
        if (this.idx >= this.input.length()) {
            throw new IllegalArgumentException("Invalid json input: " + this.input);
        }
        return this.input.charAt(this.idx++);
    }

    private char nextCharSkipSpaces() {
        char c = this.nextChar();
        while (c == ' ' || c == '\t' || c == '\n') {
            c = this.nextChar();
        }
        return c;
    }

    private String nextString() {
        assert (this.input.charAt(this.idx - 1) == '\"') : "Char is '" + this.input.charAt(this.idx - 1) + '\'';
        StringBuilder sb = new StringBuilder();
        block13: while (true) {
            char c = this.nextChar();
            switch (c) {
                case '\n': 
                case '\r': {
                    throw new IllegalArgumentException("Unterminated string");
                }
                case '\\': {
                    c = this.nextChar();
                    switch (c) {
                        case 'b': {
                            sb.append('\b');
                            continue block13;
                        }
                        case 't': {
                            sb.append('\t');
                            continue block13;
                        }
                        case 'n': {
                            sb.append('\n');
                            continue block13;
                        }
                        case 'f': {
                            sb.append('\f');
                            continue block13;
                        }
                        case 'r': {
                            sb.append('\r');
                            continue block13;
                        }
                        case 'u': {
                            sb.append((char)Integer.parseInt(this.input.substring(this.idx, this.idx + 4), 16));
                            this.idx += 4;
                            continue block13;
                        }
                        case '\"': 
                        case '\'': 
                        case '/': 
                        case '\\': {
                            sb.append(c);
                            continue block13;
                        }
                    }
                    throw new IllegalArgumentException("Illegal escape");
                }
            }
            if (c == '\"') {
                return sb.toString();
            }
            sb.append(c);
        }
    }
}

