/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.Snappy;
import shade.com.datastax.spark.connector.driver.core.Frame;
import shade.com.datastax.spark.connector.driver.core.FrameCompressor;
import shade.com.datastax.spark.connector.driver.core.exceptions.DriverInternalError;

class SnappyCompressor
extends FrameCompressor {
    private static final Logger logger;
    static final SnappyCompressor instance;

    private SnappyCompressor() {
        Snappy.getNativeLibraryVersion();
    }

    @Override
    Frame compress(Frame frame) throws IOException {
        ByteBuf input = frame.body;
        ByteBuf frameBody = input.isDirect() ? this.compressDirect(input) : this.compressHeap(input);
        return frame.with(frameBody);
    }

    private ByteBuf compressDirect(ByteBuf input) throws IOException {
        int maxCompressedLength = Snappy.maxCompressedLength((int)input.readableBytes());
        ByteBuf output = input.alloc().directBuffer(maxCompressedLength);
        try {
            ByteBuffer in = SnappyCompressor.inputNioBuffer(input);
            input.readerIndex(input.writerIndex());
            ByteBuffer out = SnappyCompressor.outputNioBuffer(output);
            int written = Snappy.compress((ByteBuffer)in, (ByteBuffer)out);
            output.writerIndex(output.writerIndex() + written);
        }
        catch (IOException e) {
            output.release();
            throw e;
        }
        return output;
    }

    private ByteBuf compressHeap(ByteBuf input) throws IOException {
        int maxCompressedLength = Snappy.maxCompressedLength((int)input.readableBytes());
        int inOffset = input.arrayOffset() + input.readerIndex();
        byte[] in = input.array();
        int len = input.readableBytes();
        input.readerIndex(input.writerIndex());
        ByteBuf output = input.alloc().heapBuffer(maxCompressedLength);
        try {
            int offset = output.arrayOffset() + output.writerIndex();
            byte[] out = output.array();
            int written = Snappy.compress((byte[])in, (int)inOffset, (int)len, (byte[])out, (int)offset);
            output.writerIndex(output.writerIndex() + written);
        }
        catch (IOException e) {
            output.release();
            throw e;
        }
        return output;
    }

    @Override
    Frame decompress(Frame frame) throws IOException {
        ByteBuf input = frame.body;
        ByteBuf frameBody = input.isDirect() ? this.decompressDirect(input) : this.decompressHeap(input);
        return frame.with(frameBody);
    }

    private ByteBuf decompressDirect(ByteBuf input) throws IOException {
        ByteBuffer in = SnappyCompressor.inputNioBuffer(input);
        input.readerIndex(input.writerIndex());
        if (!Snappy.isValidCompressedBuffer((ByteBuffer)in)) {
            throw new DriverInternalError("Provided frame does not appear to be Snappy compressed");
        }
        ByteBuf output = input.alloc().directBuffer(Snappy.uncompressedLength((ByteBuffer)in));
        try {
            ByteBuffer out = SnappyCompressor.outputNioBuffer(output);
            int size = Snappy.uncompress((ByteBuffer)in, (ByteBuffer)out);
            output.writerIndex(output.writerIndex() + size);
        }
        catch (IOException e) {
            output.release();
            throw e;
        }
        return output;
    }

    private ByteBuf decompressHeap(ByteBuf input) throws IOException {
        int inOffset = input.arrayOffset() + input.readerIndex();
        byte[] in = input.array();
        int len = input.readableBytes();
        input.readerIndex(input.writerIndex());
        if (!Snappy.isValidCompressedBuffer((byte[])in, (int)inOffset, (int)len)) {
            throw new DriverInternalError("Provided frame does not appear to be Snappy compressed");
        }
        ByteBuf output = input.alloc().heapBuffer(Snappy.uncompressedLength((byte[])in, (int)inOffset, (int)len));
        try {
            int offset = output.arrayOffset() + output.writerIndex();
            byte[] out = output.array();
            int written = Snappy.uncompress((byte[])in, (int)inOffset, (int)len, (byte[])out, (int)offset);
            output.writerIndex(output.writerIndex() + written);
        }
        catch (IOException e) {
            output.release();
            throw e;
        }
        return output;
    }

    static {
        SnappyCompressor i;
        logger = LoggerFactory.getLogger(SnappyCompressor.class);
        try {
            i = new SnappyCompressor();
        }
        catch (NoClassDefFoundError e) {
            i = null;
            logger.warn("Cannot find Snappy class, you should make sure the Snappy library is in the classpath if you intend to use it. Snappy compression will not be available for the protocol.");
        }
        catch (Throwable e) {
            i = null;
            logger.warn("Error loading Snappy library ({}). Snappy compression will not be available for the protocol.", (Object)e.toString());
        }
        instance = i;
    }
}

