/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shade.com.datastax.spark.connector.driver.core.AbstractTableMetadata;
import shade.com.datastax.spark.connector.driver.core.Cluster;
import shade.com.datastax.spark.connector.driver.core.ClusteringOrder;
import shade.com.datastax.spark.connector.driver.core.CodecRegistry;
import shade.com.datastax.spark.connector.driver.core.ColumnMetadata;
import shade.com.datastax.spark.connector.driver.core.DataType;
import shade.com.datastax.spark.connector.driver.core.DataTypeClassNameParser;
import shade.com.datastax.spark.connector.driver.core.DataTypeCqlNameParser;
import shade.com.datastax.spark.connector.driver.core.IndexMetadata;
import shade.com.datastax.spark.connector.driver.core.KeyspaceMetadata;
import shade.com.datastax.spark.connector.driver.core.MaterializedViewMetadata;
import shade.com.datastax.spark.connector.driver.core.Metadata;
import shade.com.datastax.spark.connector.driver.core.ProtocolVersion;
import shade.com.datastax.spark.connector.driver.core.Row;
import shade.com.datastax.spark.connector.driver.core.SimpleJSONParser;
import shade.com.datastax.spark.connector.driver.core.TableOptionsMetadata;
import shade.com.datastax.spark.connector.driver.core.VersionNumber;
import shade.com.datastax.spark.connector.google.common.base.Objects;

public class TableMetadata
extends AbstractTableMetadata {
    private static final Logger logger = LoggerFactory.getLogger(TableMetadata.class);
    private static final String CF_ID_V2 = "cf_id";
    private static final String CF_ID_V3 = "id";
    private static final String KEY_VALIDATOR = "key_validator";
    private static final String COMPARATOR = "comparator";
    private static final String VALIDATOR = "default_validator";
    private static final String KEY_ALIASES = "key_aliases";
    private static final String COLUMN_ALIASES = "column_aliases";
    private static final String VALUE_ALIAS = "value_alias";
    private static final String DEFAULT_KEY_ALIAS = "key";
    private static final String DEFAULT_COLUMN_ALIAS = "column";
    private static final String DEFAULT_VALUE_ALIAS = "value";
    private static final String FLAGS = "flags";
    private static final String DENSE = "dense";
    private static final String SUPER = "super";
    private static final String COMPOUND = "compound";
    private static final String EMPTY_TYPE = "empty";
    private final Map<String, IndexMetadata> indexes;
    private final Map<String, MaterializedViewMetadata> views;

    private TableMetadata(KeyspaceMetadata keyspace, String name, UUID id, List<ColumnMetadata> partitionKey, List<ColumnMetadata> clusteringColumns, Map<String, ColumnMetadata> columns, Map<String, IndexMetadata> indexes, TableOptionsMetadata options, List<ClusteringOrder> clusteringOrder, VersionNumber cassandraVersion) {
        super(keyspace, name, id, partitionKey, clusteringColumns, columns, options, clusteringOrder, cassandraVersion);
        this.indexes = indexes;
        this.views = new HashMap<String, MaterializedViewMetadata>();
    }

    /*
     * WARNING - void declaration
     */
    static TableMetadata build(KeyspaceMetadata ksm, Row row, Map<String, ColumnMetadata.Raw> rawCols, List<Row> indexRows, String nameColumn, VersionNumber cassandraVersion, Cluster cluster) {
        int clusteringSize;
        boolean isCompact;
        boolean isDense;
        String name = row.getString(nameColumn);
        UUID id = null;
        if (cassandraVersion.getMajor() == 2 && cassandraVersion.getMinor() >= 1) {
            id = row.getUUID(CF_ID_V2);
        } else if (cassandraVersion.getMajor() > 2) {
            id = row.getUUID(CF_ID_V3);
        }
        DataTypeClassNameParser.ParseResult comparator = null;
        DataTypeClassNameParser.ParseResult keyValidator = null;
        List<String> columnAliases = null;
        ProtocolVersion protocolVersion2 = cluster.getConfiguration().getProtocolOptions().getProtocolVersion();
        CodecRegistry codecRegistry = cluster.getConfiguration().getCodecRegistry();
        if (cassandraVersion.getMajor() <= 2) {
            comparator = DataTypeClassNameParser.parseWithComposite(row.getString(COMPARATOR), protocolVersion2, codecRegistry);
            keyValidator = DataTypeClassNameParser.parseWithComposite(row.getString(KEY_VALIDATOR), protocolVersion2, codecRegistry);
            columnAliases = cassandraVersion.getMajor() >= 2 || row.getString(COLUMN_ALIASES) == null ? Collections.emptyList() : SimpleJSONParser.parseStringList(row.getString(COLUMN_ALIASES));
        }
        int partitionKeySize = TableMetadata.findPartitionKeySize(rawCols.values(), keyValidator);
        if (cassandraVersion.getMajor() > 2) {
            boolean isStaticCompact;
            Set<String> flags = row.getSet(FLAGS, String.class);
            isDense = flags.contains(DENSE);
            boolean isSuper = flags.contains(SUPER);
            boolean isCompound = flags.contains(COMPOUND);
            isCompact = isSuper || isDense || !isCompound;
            boolean bl = isStaticCompact = !isSuper && !isDense && !isCompound;
            if (isStaticCompact) {
                rawCols = TableMetadata.pruneStaticCompactTableColumns(rawCols);
            }
            if (isDense) {
                rawCols = TableMetadata.pruneDenseTableColumnsV3(rawCols);
            }
            clusteringSize = TableMetadata.findClusteringSize(comparator, rawCols.values(), columnAliases, cassandraVersion);
        } else {
            assert (comparator != null);
            clusteringSize = TableMetadata.findClusteringSize(comparator, rawCols.values(), columnAliases, cassandraVersion);
            boolean bl = isDense = clusteringSize != comparator.types.size() - 1;
            if (isDense) {
                rawCols = TableMetadata.pruneDenseTableColumnsV2(rawCols);
            }
            isCompact = isDense || !comparator.isComposite;
        }
        ArrayList<Object> partitionKey = new ArrayList<Object>(Collections.nCopies(partitionKeySize, null));
        ArrayList<Object> clusteringColumns = new ArrayList<Object>(Collections.nCopies(clusteringSize, null));
        ArrayList<Object> clusteringOrder = new ArrayList<Object>(Collections.nCopies(clusteringSize, null));
        LinkedHashMap<String, ColumnMetadata> columns = new LinkedHashMap<String, ColumnMetadata>();
        LinkedHashMap<String, IndexMetadata> indexes = new LinkedHashMap<String, IndexMetadata>();
        TableOptionsMetadata options = null;
        try {
            options = new TableOptionsMetadata(row, isCompact, cassandraVersion);
        }
        catch (RuntimeException e) {
            logger.error(String.format("Error parsing schema options for table %s.%s: Cluster.getMetadata().getKeyspace(\"%s\").getTable(\"%s\").getOptions() will return null", ksm.getName(), name, ksm.getName(), name), (Throwable)e);
        }
        TableMetadata tm = new TableMetadata(ksm, name, id, partitionKey, clusteringColumns, columns, indexes, options, clusteringOrder, cassandraVersion);
        TreeSet<ColumnMetadata> otherColumns = new TreeSet<ColumnMetadata>(columnMetadataComparator);
        if (cassandraVersion.getMajor() < 2) {
            void var27_34;
            String alias;
            void var27_32;
            assert (comparator != null);
            assert (keyValidator != null);
            assert (columnAliases != null);
            List keyAliases = row.getString(KEY_ALIASES) == null ? Collections.emptyList() : SimpleJSONParser.parseStringList(row.getString(KEY_ALIASES));
            boolean bl = false;
            while (var27_32 < partitionKey.size()) {
                alias = keyAliases.size() > var27_32 ? (String)keyAliases.get((int)var27_32) : (var27_32 == false ? DEFAULT_KEY_ALIAS : DEFAULT_KEY_ALIAS + (int)(var27_32 + true));
                partitionKey.set((int)var27_32, ColumnMetadata.forAlias(tm, alias, keyValidator.types.get((int)var27_32)));
                ++var27_32;
            }
            boolean bl2 = false;
            while (var27_34 < clusteringSize) {
                alias = columnAliases.size() > var27_34 ? columnAliases.get((int)var27_34) : DEFAULT_COLUMN_ALIAS + (int)(var27_34 + true);
                clusteringColumns.set((int)var27_34, ColumnMetadata.forAlias(tm, alias, comparator.types.get((int)var27_34)));
                clusteringOrder.set((int)var27_34, (comparator.reversed.get((int)var27_34) != false ? ClusteringOrder.DESC : ClusteringOrder.ASC));
                ++var27_34;
            }
            if (isDense) {
                String string;
                String string2 = string = row.isNull(VALUE_ALIAS) ? DEFAULT_VALUE_ALIAS : row.getString(VALUE_ALIAS);
                if (!string.isEmpty()) {
                    DataType type = DataTypeClassNameParser.parseOne(row.getString(VALIDATOR), protocolVersion2, codecRegistry);
                    otherColumns.add(ColumnMetadata.forAlias(tm, string, type));
                }
            }
        }
        for (ColumnMetadata.Raw raw : rawCols.values()) {
            IndexMetadata index;
            DataType dataType = cassandraVersion.getMajor() >= 3 ? DataTypeCqlNameParser.parse(raw.dataType, cluster, ksm.getName(), ksm.userTypes, null, false, false) : DataTypeClassNameParser.parseOne(raw.dataType, protocolVersion2, codecRegistry);
            ColumnMetadata col = ColumnMetadata.fromRaw(tm, raw, dataType);
            switch (raw.kind) {
                case PARTITION_KEY: {
                    partitionKey.set(raw.position, col);
                    break;
                }
                case CLUSTERING_COLUMN: {
                    clusteringColumns.set(raw.position, col);
                    clusteringOrder.set(raw.position, (raw.isReversed ? ClusteringOrder.DESC : ClusteringOrder.ASC));
                    break;
                }
                default: {
                    otherColumns.add(col);
                }
            }
            if ((index = IndexMetadata.fromLegacy(col, raw)) == null) continue;
            indexes.put(index.getName(), index);
        }
        for (ColumnMetadata columnMetadata : partitionKey) {
            columns.put(columnMetadata.getName(), columnMetadata);
        }
        for (ColumnMetadata columnMetadata : clusteringColumns) {
            columns.put(columnMetadata.getName(), columnMetadata);
        }
        for (ColumnMetadata columnMetadata : otherColumns) {
            columns.put(columnMetadata.getName(), columnMetadata);
        }
        if (indexRows != null) {
            for (Row row2 : indexRows) {
                IndexMetadata index = IndexMetadata.fromRow(tm, row2);
                indexes.put(index.getName(), index);
            }
        }
        return tm;
    }

    private static Map<String, ColumnMetadata.Raw> pruneStaticCompactTableColumns(Map<String, ColumnMetadata.Raw> rawCols) {
        Collection<ColumnMetadata.Raw> cols = rawCols.values();
        Iterator<ColumnMetadata.Raw> it = cols.iterator();
        while (it.hasNext()) {
            ColumnMetadata.Raw col = it.next();
            if (col.kind == ColumnMetadata.Raw.Kind.CLUSTERING_COLUMN) {
                it.remove();
                continue;
            }
            if (col.kind == ColumnMetadata.Raw.Kind.REGULAR) {
                it.remove();
                continue;
            }
            if (col.kind != ColumnMetadata.Raw.Kind.STATIC) continue;
            col.kind = ColumnMetadata.Raw.Kind.REGULAR;
        }
        return rawCols;
    }

    private static Map<String, ColumnMetadata.Raw> pruneDenseTableColumnsV3(Map<String, ColumnMetadata.Raw> rawCols) {
        Collection<ColumnMetadata.Raw> cols = rawCols.values();
        Iterator<ColumnMetadata.Raw> it = cols.iterator();
        while (it.hasNext()) {
            ColumnMetadata.Raw col = it.next();
            if (col.kind != ColumnMetadata.Raw.Kind.REGULAR || !col.dataType.equals(EMPTY_TYPE)) continue;
            it.remove();
        }
        return rawCols;
    }

    private static Map<String, ColumnMetadata.Raw> pruneDenseTableColumnsV2(Map<String, ColumnMetadata.Raw> rawCols) {
        Collection<ColumnMetadata.Raw> cols = rawCols.values();
        Iterator<ColumnMetadata.Raw> it = cols.iterator();
        while (it.hasNext()) {
            ColumnMetadata.Raw col = it.next();
            if (col.kind != ColumnMetadata.Raw.Kind.COMPACT_VALUE || !col.name.isEmpty()) continue;
            it.remove();
        }
        return rawCols;
    }

    private static int findPartitionKeySize(Collection<ColumnMetadata.Raw> cols, DataTypeClassNameParser.ParseResult keyValidator) {
        if (keyValidator != null) {
            return keyValidator.types.size();
        }
        int maxId = -1;
        for (ColumnMetadata.Raw col : cols) {
            if (col.kind != ColumnMetadata.Raw.Kind.PARTITION_KEY) continue;
            maxId = Math.max(maxId, col.position);
        }
        return maxId + 1;
    }

    private static int findClusteringSize(DataTypeClassNameParser.ParseResult comparator, Collection<ColumnMetadata.Raw> cols, List<String> columnAliases, VersionNumber cassandraVersion) {
        if (cassandraVersion.getMajor() >= 2) {
            int maxId = -1;
            for (ColumnMetadata.Raw col : cols) {
                if (col.kind != ColumnMetadata.Raw.Kind.CLUSTERING_COLUMN) continue;
                maxId = Math.max(maxId, col.position);
            }
            return maxId + 1;
        }
        int size = comparator.types.size();
        if (comparator.isComposite) {
            return !comparator.collections.isEmpty() || columnAliases.size() == size - 1 && comparator.types.get(size - 1).equals(DataType.text()) ? size - 1 : size;
        }
        return !columnAliases.isEmpty() || cols.isEmpty() ? size : 0;
    }

    public IndexMetadata getIndex(String name) {
        return this.indexes.get(Metadata.handleId(name));
    }

    public Collection<IndexMetadata> getIndexes() {
        return Collections.unmodifiableCollection(this.indexes.values());
    }

    public MaterializedViewMetadata getView(String name) {
        return this.views.get(Metadata.handleId(name));
    }

    public Collection<MaterializedViewMetadata> getViews() {
        return Collections.unmodifiableCollection(this.views.values());
    }

    void add(MaterializedViewMetadata view) {
        this.views.put(view.getName(), view);
    }

    @Override
    public String exportAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.exportAsString());
        for (IndexMetadata index : this.indexes.values()) {
            sb.append('\n').append(index.asCQLQuery());
        }
        for (MaterializedViewMetadata view : this.views.values()) {
            sb.append('\n').append(view.asCQLQuery());
        }
        return sb.toString();
    }

    @Override
    protected String asCQLQuery(boolean formatted) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ").append(Metadata.escapeId(this.keyspace.getName())).append('.').append(Metadata.escapeId(this.name)).append(" (");
        TableMetadata.newLine(sb, formatted);
        for (Object cm : this.columns.values()) {
            TableMetadata.newLine(sb.append(TableMetadata.spaces(4, formatted)).append(cm).append(',').append(TableMetadata.spaces(1, !formatted)), formatted);
        }
        sb.append(TableMetadata.spaces(4, formatted)).append("PRIMARY KEY (");
        if (this.partitionKey.size() == 1) {
            sb.append(Metadata.escapeId(((ColumnMetadata)this.partitionKey.get(0)).getName()));
        } else {
            sb.append('(');
            boolean first = true;
            for (ColumnMetadata cm : this.partitionKey) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(Metadata.escapeId(cm.getName()));
            }
            sb.append(')');
        }
        for (Object cm : this.clusteringColumns) {
            sb.append(", ").append(Metadata.escapeId(((ColumnMetadata)cm).getName()));
        }
        sb.append(')');
        TableMetadata.newLine(sb, formatted);
        sb.append(")");
        this.appendOptions(sb, formatted);
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TableMetadata)) {
            return false;
        }
        TableMetadata that = (TableMetadata)other;
        return Objects.equal(this.name, that.name) && Objects.equal(this.id, that.id) && Objects.equal(this.partitionKey, that.partitionKey) && Objects.equal(this.clusteringColumns, that.clusteringColumns) && Objects.equal(this.columns, that.columns) && Objects.equal(this.options, that.options) && Objects.equal(this.clusteringOrder, that.clusteringOrder) && Objects.equal(this.indexes, that.indexes) && Objects.equal(this.views, that.views);
    }

    public int hashCode() {
        return Objects.hashCode(this.name, this.id, this.partitionKey, this.clusteringColumns, this.columns, this.options, this.clusteringOrder, this.indexes, this.views);
    }
}

