/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import shade.com.datastax.spark.connector.driver.core.CodecUtils;
import shade.com.datastax.spark.connector.driver.core.DataType;
import shade.com.datastax.spark.connector.driver.core.LocalDate;
import shade.com.datastax.spark.connector.driver.core.Metadata;
import shade.com.datastax.spark.connector.driver.core.ParseUtils;
import shade.com.datastax.spark.connector.driver.core.ProtocolVersion;
import shade.com.datastax.spark.connector.driver.core.TupleType;
import shade.com.datastax.spark.connector.driver.core.TupleValue;
import shade.com.datastax.spark.connector.driver.core.TypeTokens;
import shade.com.datastax.spark.connector.driver.core.UDTValue;
import shade.com.datastax.spark.connector.driver.core.UserType;
import shade.com.datastax.spark.connector.driver.core.exceptions.InvalidTypeException;
import shade.com.datastax.spark.connector.driver.core.utils.Bytes;
import shade.com.datastax.spark.connector.google.common.base.Preconditions;
import shade.com.datastax.spark.connector.google.common.reflect.TypeToken;

public abstract class TypeCodec<T> {
    protected final TypeToken<T> javaType;
    protected final DataType cqlType;

    public static PrimitiveBooleanCodec cboolean() {
        return BooleanCodec.instance;
    }

    public static PrimitiveByteCodec tinyInt() {
        return TinyIntCodec.instance;
    }

    public static PrimitiveShortCodec smallInt() {
        return SmallIntCodec.instance;
    }

    public static PrimitiveIntCodec cint() {
        return IntCodec.instance;
    }

    public static PrimitiveLongCodec bigint() {
        return BigintCodec.instance;
    }

    public static PrimitiveLongCodec counter() {
        return CounterCodec.instance;
    }

    public static PrimitiveFloatCodec cfloat() {
        return FloatCodec.instance;
    }

    public static PrimitiveDoubleCodec cdouble() {
        return DoubleCodec.instance;
    }

    public static TypeCodec<BigInteger> varint() {
        return VarintCodec.instance;
    }

    public static TypeCodec<BigDecimal> decimal() {
        return DecimalCodec.instance;
    }

    public static TypeCodec<String> ascii() {
        return AsciiCodec.instance;
    }

    public static TypeCodec<String> varchar() {
        return VarcharCodec.instance;
    }

    public static TypeCodec<ByteBuffer> blob() {
        return BlobCodec.instance;
    }

    public static TypeCodec<LocalDate> date() {
        return DateCodec.instance;
    }

    public static PrimitiveLongCodec time() {
        return TimeCodec.instance;
    }

    public static TypeCodec<Date> timestamp() {
        return TimestampCodec.instance;
    }

    public static TypeCodec<UUID> uuid() {
        return UUIDCodec.instance;
    }

    public static TypeCodec<UUID> timeUUID() {
        return TimeUUIDCodec.instance;
    }

    public static TypeCodec<InetAddress> inet() {
        return InetCodec.instance;
    }

    public static <T> TypeCodec<List<T>> list(TypeCodec<T> elementCodec) {
        return new ListCodec(elementCodec);
    }

    public static <T> TypeCodec<Set<T>> set(TypeCodec<T> elementCodec) {
        return new SetCodec(elementCodec);
    }

    public static <K, V> TypeCodec<Map<K, V>> map(TypeCodec<K> keyCodec, TypeCodec<V> valueCodec) {
        return new MapCodec(keyCodec, valueCodec);
    }

    public static TypeCodec<UDTValue> userType(UserType type) {
        return new UDTCodec(type);
    }

    public static TypeCodec<TupleValue> tuple(TupleType type) {
        return new TupleCodec(type);
    }

    public static TypeCodec<ByteBuffer> custom(DataType.CustomType type) {
        return new CustomCodec((DataType)type);
    }

    protected TypeCodec(DataType cqlType, Class<T> javaClass) {
        this(cqlType, TypeToken.of(javaClass));
    }

    protected TypeCodec(DataType cqlType, TypeToken<T> javaType) {
        Preconditions.checkNotNull(cqlType, "cqlType cannot be null");
        Preconditions.checkNotNull(javaType, "javaType cannot be null");
        Preconditions.checkArgument(!javaType.isPrimitive(), "Cannot create a codec for a primitive Java type (%s), please use the wrapper type instead", javaType);
        this.cqlType = cqlType;
        this.javaType = javaType;
    }

    public TypeToken<T> getJavaType() {
        return this.javaType;
    }

    public DataType getCqlType() {
        return this.cqlType;
    }

    public abstract ByteBuffer serialize(T var1, ProtocolVersion var2) throws InvalidTypeException;

    public abstract T deserialize(ByteBuffer var1, ProtocolVersion var2) throws InvalidTypeException;

    public abstract T parse(String var1) throws InvalidTypeException;

    public abstract String format(T var1) throws InvalidTypeException;

    public boolean accepts(TypeToken javaType) {
        Preconditions.checkNotNull(javaType, "Parameter javaType cannot be null");
        return this.javaType.equals(javaType.wrap());
    }

    public boolean accepts(Class<?> javaType) {
        Preconditions.checkNotNull(javaType, "Parameter javaType cannot be null");
        return this.accepts(TypeToken.of(javaType));
    }

    public boolean accepts(DataType cqlType) {
        Preconditions.checkNotNull(cqlType, "Parameter cqlType cannot be null");
        return this.cqlType.equals(cqlType);
    }

    public boolean accepts(Object value2) {
        Preconditions.checkNotNull(value2, "Parameter value cannot be null");
        return this.javaType.isAssignableFrom(TypeToken.of(value2.getClass()));
    }

    public String toString() {
        return String.format("%s [%s <-> %s]", this.getClass().getSimpleName(), this.cqlType, this.javaType);
    }

    private static class TupleCodec
    extends AbstractTupleCodec<TupleValue> {
        private TupleCodec(TupleType definition) {
            super(definition, TupleValue.class);
        }

        @Override
        public boolean accepts(Object value2) {
            return super.accepts(value2) && this.definition.contains(((TupleValue)value2).getType());
        }

        @Override
        protected TupleValue newInstance() {
            return this.definition.newValue();
        }

        @Override
        protected ByteBuffer serializeField(TupleValue source, int index, ProtocolVersion protocolVersion2) {
            if (index >= source.values.length) {
                return null;
            }
            return source.getBytesUnsafe(index);
        }

        @Override
        protected TupleValue deserializeAndSetField(ByteBuffer input, TupleValue target, int index, ProtocolVersion protocolVersion2) {
            if (index >= target.values.length) {
                return target;
            }
            return (TupleValue)target.setBytesUnsafe(index, input);
        }

        @Override
        protected String formatField(TupleValue value2, int index) {
            DataType elementType = this.definition.getComponentTypes().get(index);
            TypeCodec<Object> codec = this.definition.getCodecRegistry().codecFor(elementType);
            return codec.format(value2.get(index, codec.getJavaType()));
        }

        @Override
        protected TupleValue parseAndSetField(String input, TupleValue target, int index) {
            DataType elementType = this.definition.getComponentTypes().get(index);
            TypeCodec codec = this.definition.getCodecRegistry().codecFor(elementType);
            target.set(index, codec.parse(input), codec.getJavaType());
            return target;
        }
    }

    public static abstract class AbstractTupleCodec<T>
    extends TypeCodec<T> {
        protected final TupleType definition;

        protected AbstractTupleCodec(TupleType definition, Class<T> javaClass) {
            this(definition, TypeToken.of(javaClass));
        }

        protected AbstractTupleCodec(TupleType definition, TypeToken<T> javaType) {
            super((DataType)definition, javaType);
            this.definition = definition;
        }

        @Override
        public boolean accepts(DataType cqlType) {
            return super.accepts(cqlType) && this.definition.contains((TupleType)cqlType);
        }

        @Override
        public ByteBuffer serialize(T value2, ProtocolVersion protocolVersion2) {
            if (value2 == null) {
                return null;
            }
            int size = 0;
            int length = this.definition.getComponentTypes().size();
            ByteBuffer[] elements = new ByteBuffer[length];
            for (int i = 0; i < length; ++i) {
                elements[i] = this.serializeField(value2, i, protocolVersion2);
                size += 4 + (elements[i] == null ? 0 : elements[i].remaining());
            }
            ByteBuffer result = ByteBuffer.allocate(size);
            for (ByteBuffer bb : elements) {
                if (bb == null) {
                    result.putInt(-1);
                    continue;
                }
                result.putInt(bb.remaining());
                result.put(bb.duplicate());
            }
            return (ByteBuffer)result.flip();
        }

        @Override
        public T deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion2) {
            if (bytes == null) {
                return null;
            }
            try {
                ByteBuffer input = bytes.duplicate();
                T value2 = this.newInstance();
                int i = 0;
                while (input.hasRemaining() && i < this.definition.getComponentTypes().size()) {
                    int n = input.getInt();
                    ByteBuffer element = n < 0 ? null : CodecUtils.readBytes(input, n);
                    value2 = this.deserializeAndSetField(element, value2, i++, protocolVersion2);
                }
                return value2;
            }
            catch (BufferUnderflowException e) {
                throw new InvalidTypeException("Not enough bytes to deserialize a tuple", e);
            }
        }

        @Override
        public String format(T value2) {
            if (value2 == null) {
                return "NULL";
            }
            StringBuilder sb = new StringBuilder("(");
            int length = this.definition.getComponentTypes().size();
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(this.formatField(value2, i));
            }
            sb.append(")");
            return sb.toString();
        }

        @Override
        public T parse(String value2) {
            if (value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL")) {
                return null;
            }
            T v = this.newInstance();
            int idx = ParseUtils.skipSpaces(value2, 0);
            if (value2.charAt(idx++) != '(') {
                throw new InvalidTypeException(String.format("Cannot parse tuple value from \"%s\", at character %d expecting '(' but got '%c'", value2, idx, Character.valueOf(value2.charAt(idx))));
            }
            if (value2.charAt(idx = ParseUtils.skipSpaces(value2, idx)) == ')') {
                return v;
            }
            int i = 0;
            while (idx < value2.length()) {
                int n;
                try {
                    n = ParseUtils.skipCQLValue(value2, idx);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidTypeException(String.format("Cannot parse tuple value from \"%s\", invalid CQL value at character %d", value2, idx), e);
                }
                String input = value2.substring(idx, n);
                v = this.parseAndSetField(input, v, i);
                idx = n;
                ++i;
                idx = ParseUtils.skipSpaces(value2, idx);
                if (value2.charAt(idx) == ')') {
                    return v;
                }
                if (value2.charAt(idx) != ',') {
                    throw new InvalidTypeException(String.format("Cannot parse tuple value from \"%s\", at character %d expecting ',' but got '%c'", value2, idx, Character.valueOf(value2.charAt(idx))));
                }
                ++idx;
                idx = ParseUtils.skipSpaces(value2, idx);
            }
            throw new InvalidTypeException(String.format("Malformed tuple value \"%s\", missing closing ')'", value2));
        }

        protected abstract T newInstance();

        protected abstract ByteBuffer serializeField(T var1, int var2, ProtocolVersion var3);

        protected abstract T deserializeAndSetField(ByteBuffer var1, T var2, int var3, ProtocolVersion var4);

        protected abstract String formatField(T var1, int var2);

        protected abstract T parseAndSetField(String var1, T var2, int var3);
    }

    private static class UDTCodec
    extends AbstractUDTCodec<UDTValue> {
        private UDTCodec(UserType definition) {
            super(definition, UDTValue.class);
        }

        @Override
        public boolean accepts(Object value2) {
            return super.accepts(value2) && ((UDTValue)value2).getType().equals(this.definition);
        }

        @Override
        protected UDTValue newInstance() {
            return this.definition.newValue();
        }

        @Override
        protected ByteBuffer serializeField(UDTValue source, String fieldName, ProtocolVersion protocolVersion2) {
            return source.getBytesUnsafe(fieldName);
        }

        @Override
        protected UDTValue deserializeAndSetField(ByteBuffer input, UDTValue target, String fieldName, ProtocolVersion protocolVersion2) {
            return (UDTValue)target.setBytesUnsafe(fieldName, input);
        }

        @Override
        protected String formatField(UDTValue source, String fieldName) {
            DataType elementType = this.definition.getFieldType(fieldName);
            TypeCodec codec = this.definition.getCodecRegistry().codecFor(elementType);
            return codec.format(source.get(fieldName, codec.getJavaType()));
        }

        @Override
        protected UDTValue parseAndSetField(String input, UDTValue target, String fieldName) {
            DataType elementType = this.definition.getFieldType(fieldName);
            TypeCodec codec = this.definition.getCodecRegistry().codecFor(elementType);
            target.set(fieldName, codec.parse(input), codec.getJavaType());
            return target;
        }
    }

    public static abstract class AbstractUDTCodec<T>
    extends TypeCodec<T> {
        protected final UserType definition;

        protected AbstractUDTCodec(UserType definition, Class<T> javaClass) {
            this(definition, TypeToken.of(javaClass));
        }

        protected AbstractUDTCodec(UserType definition, TypeToken<T> javaType) {
            super((DataType)definition, javaType);
            this.definition = definition;
        }

        @Override
        public ByteBuffer serialize(T value2, ProtocolVersion protocolVersion2) {
            if (value2 == null) {
                return null;
            }
            int size = 0;
            int length = this.definition.size();
            ByteBuffer[] elements = new ByteBuffer[length];
            int i = 0;
            for (UserType.Field field : this.definition) {
                elements[i] = this.serializeField(value2, Metadata.escapeId(field.getName()), protocolVersion2);
                size += 4 + (elements[i] == null ? 0 : elements[i].remaining());
                ++i;
            }
            ByteBuffer result = ByteBuffer.allocate(size);
            for (ByteBuffer bb : elements) {
                if (bb == null) {
                    result.putInt(-1);
                    continue;
                }
                result.putInt(bb.remaining());
                result.put(bb.duplicate());
            }
            return (ByteBuffer)result.flip();
        }

        @Override
        public T deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion2) {
            if (bytes == null) {
                return null;
            }
            try {
                ByteBuffer input = bytes.duplicate();
                T value2 = this.newInstance();
                for (UserType.Field field : this.definition) {
                    if (!input.hasRemaining()) break;
                    int n = input.getInt();
                    ByteBuffer element = n < 0 ? null : CodecUtils.readBytes(input, n);
                    value2 = this.deserializeAndSetField(element, value2, Metadata.escapeId(field.getName()), protocolVersion2);
                }
                return value2;
            }
            catch (BufferUnderflowException e) {
                throw new InvalidTypeException("Not enough bytes to deserialize a UDT", e);
            }
        }

        @Override
        public String format(T value2) {
            if (value2 == null) {
                return "NULL";
            }
            StringBuilder sb = new StringBuilder("{");
            int i = 0;
            for (UserType.Field field : this.definition) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(Metadata.escapeId(field.getName()));
                sb.append(":");
                sb.append(this.formatField(value2, Metadata.escapeId(field.getName())));
                ++i;
            }
            sb.append("}");
            return sb.toString();
        }

        @Override
        public T parse(String value2) {
            if (value2 == null || value2.isEmpty() || value2.equals("NULL")) {
                return null;
            }
            T v = this.newInstance();
            int idx = ParseUtils.skipSpaces(value2, 0);
            if (value2.charAt(idx++) != '{') {
                throw new InvalidTypeException(String.format("Cannot parse UDT value from \"%s\", at character %d expecting '{' but got '%c'", value2, idx, Character.valueOf(value2.charAt(idx))));
            }
            if (value2.charAt(idx = ParseUtils.skipSpaces(value2, idx)) == '}') {
                return v;
            }
            while (idx < value2.length()) {
                int n;
                try {
                    n = ParseUtils.skipCQLId(value2, idx);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidTypeException(String.format("Cannot parse UDT value from \"%s\", cannot parse a CQL identifier at character %d", value2, idx), e);
                }
                String name = value2.substring(idx, n);
                idx = n;
                if (!this.definition.contains(name)) {
                    throw new InvalidTypeException(String.format("Unknown field %s in value \"%s\"", name, value2));
                }
                idx = ParseUtils.skipSpaces(value2, idx);
                if (value2.charAt(idx++) != ':') {
                    throw new InvalidTypeException(String.format("Cannot parse UDT value from \"%s\", at character %d expecting ':' but got '%c'", value2, idx, Character.valueOf(value2.charAt(idx))));
                }
                idx = ParseUtils.skipSpaces(value2, idx);
                try {
                    n = ParseUtils.skipCQLValue(value2, idx);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidTypeException(String.format("Cannot parse UDT value from \"%s\", invalid CQL value at character %d", value2, idx), e);
                }
                String input = value2.substring(idx, n);
                v = this.parseAndSetField(input, v, name);
                idx = n;
                idx = ParseUtils.skipSpaces(value2, idx);
                if (value2.charAt(idx) == '}') {
                    return v;
                }
                if (value2.charAt(idx) != ',') {
                    throw new InvalidTypeException(String.format("Cannot parse UDT value from \"%s\", at character %d expecting ',' but got '%c'", value2, idx, Character.valueOf(value2.charAt(idx))));
                }
                ++idx;
                idx = ParseUtils.skipSpaces(value2, idx);
            }
            throw new InvalidTypeException(String.format("Malformed UDT value \"%s\", missing closing '}'", value2));
        }

        protected abstract T newInstance();

        protected abstract ByteBuffer serializeField(T var1, String var2, ProtocolVersion var3);

        protected abstract T deserializeAndSetField(ByteBuffer var1, T var2, String var3, ProtocolVersion var4);

        protected abstract String formatField(T var1, String var2);

        protected abstract T parseAndSetField(String var1, T var2, String var3);
    }

    private static class MapCodec<K, V>
    extends AbstractMapCodec<K, V> {
        private MapCodec(TypeCodec<K> keyCodec, TypeCodec<V> valueCodec) {
            super(keyCodec, valueCodec);
        }

        @Override
        protected Map<K, V> newInstance(int size) {
            return new LinkedHashMap(size);
        }
    }

    public static abstract class AbstractMapCodec<K, V>
    extends TypeCodec<Map<K, V>> {
        protected final TypeCodec<K> keyCodec;
        protected final TypeCodec<V> valueCodec;

        protected AbstractMapCodec(TypeCodec<K> keyCodec, TypeCodec<V> valueCodec) {
            super((DataType)DataType.map(keyCodec.getCqlType(), valueCodec.getCqlType()), TypeTokens.mapOf(keyCodec.getJavaType(), valueCodec.getJavaType()));
            this.keyCodec = keyCodec;
            this.valueCodec = valueCodec;
        }

        @Override
        public boolean accepts(Object value2) {
            if (value2 instanceof Map) {
                Map map = (Map)value2;
                if (map.isEmpty()) {
                    return true;
                }
                Map.Entry entry = map.entrySet().iterator().next();
                return this.keyCodec.accepts(entry.getKey()) && this.valueCodec.accepts(entry.getValue());
            }
            return false;
        }

        @Override
        public Map<K, V> parse(String value2) {
            if (value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL")) {
                return null;
            }
            int idx = ParseUtils.skipSpaces(value2, 0);
            if (value2.charAt(idx++) != '{') {
                throw new InvalidTypeException(String.format("cannot parse map value from \"%s\", at character %d expecting '{' but got '%c'", value2, idx, Character.valueOf(value2.charAt(idx))));
            }
            if (value2.charAt(idx = ParseUtils.skipSpaces(value2, idx)) == '}') {
                return this.newInstance(0);
            }
            HashMap<K, V> m = new HashMap<K, V>();
            while (idx < value2.length()) {
                int n;
                try {
                    n = ParseUtils.skipCQLValue(value2, idx);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidTypeException(String.format("Cannot parse map value from \"%s\", invalid CQL value at character %d", value2, idx), e);
                }
                K k = this.keyCodec.parse(value2.substring(idx, n));
                idx = n;
                idx = ParseUtils.skipSpaces(value2, idx);
                if (value2.charAt(idx++) != ':') {
                    throw new InvalidTypeException(String.format("Cannot parse map value from \"%s\", at character %d expecting ':' but got '%c'", value2, idx, Character.valueOf(value2.charAt(idx))));
                }
                idx = ParseUtils.skipSpaces(value2, idx);
                try {
                    n = ParseUtils.skipCQLValue(value2, idx);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidTypeException(String.format("Cannot parse map value from \"%s\", invalid CQL value at character %d", value2, idx), e);
                }
                V v = this.valueCodec.parse(value2.substring(idx, n));
                idx = n;
                m.put(k, v);
                idx = ParseUtils.skipSpaces(value2, idx);
                if (value2.charAt(idx) == '}') {
                    return m;
                }
                if (value2.charAt(idx++) != ',') {
                    throw new InvalidTypeException(String.format("Cannot parse map value from \"%s\", at character %d expecting ',' but got '%c'", value2, idx, Character.valueOf(value2.charAt(idx))));
                }
                idx = ParseUtils.skipSpaces(value2, idx);
            }
            throw new InvalidTypeException(String.format("Malformed map value \"%s\", missing closing '}'", value2));
        }

        @Override
        public String format(Map<K, V> value2) {
            if (value2 == null) {
                return "NULL";
            }
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            int i = 0;
            for (Map.Entry<K, V> e : value2.entrySet()) {
                if (i++ != 0) {
                    sb.append(",");
                }
                sb.append(this.keyCodec.format(e.getKey()));
                sb.append(":");
                sb.append(this.valueCodec.format(e.getValue()));
            }
            sb.append("}");
            return sb.toString();
        }

        @Override
        public ByteBuffer serialize(Map<K, V> value2, ProtocolVersion protocolVersion2) {
            if (value2 == null) {
                return null;
            }
            int i = 0;
            ByteBuffer[] bbs = new ByteBuffer[2 * value2.size()];
            for (Map.Entry<K, V> entry : value2.entrySet()) {
                ByteBuffer bbv;
                ByteBuffer bbk;
                K key = entry.getKey();
                if (key == null) {
                    throw new NullPointerException("Map keys cannot be null");
                }
                try {
                    bbk = this.keyCodec.serialize(key, protocolVersion2);
                }
                catch (ClassCastException e) {
                    throw new InvalidTypeException(String.format("Invalid type for map key, expecting %s but got %s", this.keyCodec.getJavaType(), key.getClass()), e);
                }
                V v = entry.getValue();
                if (v == null) {
                    throw new NullPointerException("Map values cannot be null");
                }
                try {
                    bbv = this.valueCodec.serialize(v, protocolVersion2);
                }
                catch (ClassCastException e) {
                    throw new InvalidTypeException(String.format("Invalid type for map value, expecting %s but got %s", this.valueCodec.getJavaType(), v.getClass()), e);
                }
                bbs[i++] = bbk;
                bbs[i++] = bbv;
            }
            return CodecUtils.pack(bbs, value2.size(), protocolVersion2);
        }

        @Override
        public Map<K, V> deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion2) {
            if (bytes == null || bytes.remaining() == 0) {
                return this.newInstance(0);
            }
            try {
                ByteBuffer input = bytes.duplicate();
                int n = CodecUtils.readSize(input, protocolVersion2);
                Map<K, V> m = this.newInstance(n);
                for (int i = 0; i < n; ++i) {
                    ByteBuffer kbb = CodecUtils.readValue(input, protocolVersion2);
                    ByteBuffer vbb = CodecUtils.readValue(input, protocolVersion2);
                    m.put(this.keyCodec.deserialize(kbb, protocolVersion2), this.valueCodec.deserialize(vbb, protocolVersion2));
                }
                return m;
            }
            catch (BufferUnderflowException e) {
                throw new InvalidTypeException("Not enough bytes to deserialize a map", e);
            }
        }

        protected abstract Map<K, V> newInstance(int var1);
    }

    private static class SetCodec<T>
    extends AbstractCollectionCodec<T, Set<T>> {
        private SetCodec(TypeCodec<T> eltCodec) {
            super(DataType.set(eltCodec.cqlType), TypeTokens.setOf(eltCodec.getJavaType()), eltCodec);
        }

        @Override
        protected Set<T> newInstance(int size) {
            return new LinkedHashSet(size);
        }
    }

    private static class ListCodec<T>
    extends AbstractCollectionCodec<T, List<T>> {
        private ListCodec(TypeCodec<T> eltCodec) {
            super(DataType.list(eltCodec.getCqlType()), TypeTokens.listOf(eltCodec.getJavaType()), eltCodec);
        }

        @Override
        protected List<T> newInstance(int size) {
            return new ArrayList(size);
        }
    }

    public static abstract class AbstractCollectionCodec<E, C extends Collection<E>>
    extends TypeCodec<C> {
        protected final TypeCodec<E> eltCodec;

        protected AbstractCollectionCodec(DataType.CollectionType cqlType, TypeToken<C> javaType, TypeCodec<E> eltCodec) {
            super((DataType)cqlType, javaType);
            Preconditions.checkArgument(cqlType.getName() == DataType.Name.LIST || cqlType.getName() == DataType.Name.SET, "Expecting list or set type, got %s", cqlType);
            this.eltCodec = eltCodec;
        }

        @Override
        public ByteBuffer serialize(C value2, ProtocolVersion protocolVersion2) {
            if (value2 == null) {
                return null;
            }
            int i = 0;
            ByteBuffer[] bbs = new ByteBuffer[value2.size()];
            for (Object elt : value2) {
                ByteBuffer bb;
                if (elt == null) {
                    throw new NullPointerException("Collection elements cannot be null");
                }
                try {
                    bb = this.eltCodec.serialize(elt, protocolVersion2);
                }
                catch (ClassCastException e) {
                    throw new InvalidTypeException(String.format("Invalid type for %s element, expecting %s but got %s", this.cqlType, this.eltCodec.getJavaType(), elt.getClass()), e);
                }
                bbs[i++] = bb;
            }
            return CodecUtils.pack(bbs, value2.size(), protocolVersion2);
        }

        @Override
        public C deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion2) {
            if (bytes == null || bytes.remaining() == 0) {
                return this.newInstance(0);
            }
            try {
                ByteBuffer input = bytes.duplicate();
                int size = CodecUtils.readSize(input, protocolVersion2);
                C coll = this.newInstance(size);
                for (int i = 0; i < size; ++i) {
                    ByteBuffer databb = CodecUtils.readValue(input, protocolVersion2);
                    coll.add(this.eltCodec.deserialize(databb, protocolVersion2));
                }
                return coll;
            }
            catch (BufferUnderflowException e) {
                throw new InvalidTypeException("Not enough bytes to deserialize collection", e);
            }
        }

        @Override
        public String format(C value2) {
            if (value2 == null) {
                return "NULL";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.getOpeningChar());
            int i = 0;
            for (Object v : value2) {
                if (i++ != 0) {
                    sb.append(",");
                }
                sb.append(this.eltCodec.format(v));
            }
            sb.append(this.getClosingChar());
            return sb.toString();
        }

        @Override
        public C parse(String value2) {
            if (value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL")) {
                return null;
            }
            int idx = ParseUtils.skipSpaces(value2, 0);
            if (value2.charAt(idx++) != this.getOpeningChar()) {
                throw new InvalidTypeException(String.format("Cannot parse collection value from \"%s\", at character %d expecting '%s' but got '%c'", value2, idx, Character.valueOf(this.getOpeningChar()), Character.valueOf(value2.charAt(idx))));
            }
            if (value2.charAt(idx = ParseUtils.skipSpaces(value2, idx)) == this.getClosingChar()) {
                return this.newInstance(0);
            }
            C l = this.newInstance(10);
            while (idx < value2.length()) {
                int n;
                try {
                    n = ParseUtils.skipCQLValue(value2, idx);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidTypeException(String.format("Cannot parse collection value from \"%s\", invalid CQL value at character %d", value2, idx), e);
                }
                l.add(this.eltCodec.parse(value2.substring(idx, n)));
                idx = n;
                idx = ParseUtils.skipSpaces(value2, idx);
                if (value2.charAt(idx) == this.getClosingChar()) {
                    return l;
                }
                if (value2.charAt(idx++) != ',') {
                    throw new InvalidTypeException(String.format("Cannot parse collection value from \"%s\", at character %d expecting ',' but got '%c'", value2, idx, Character.valueOf(value2.charAt(idx))));
                }
                idx = ParseUtils.skipSpaces(value2, idx);
            }
            throw new InvalidTypeException(String.format("Malformed collection value \"%s\", missing closing '%s'", value2, Character.valueOf(this.getClosingChar())));
        }

        @Override
        public boolean accepts(Object value2) {
            if (this.getJavaType().getRawType().isAssignableFrom(value2.getClass())) {
                Collection coll = (Collection)value2;
                if (coll.isEmpty()) {
                    return true;
                }
                Object elt = coll.iterator().next();
                return this.eltCodec.accepts(elt);
            }
            return false;
        }

        protected abstract C newInstance(int var1);

        private char getOpeningChar() {
            return this.cqlType.getName() == DataType.Name.LIST ? (char)'[' : '{';
        }

        private char getClosingChar() {
            return this.cqlType.getName() == DataType.Name.LIST ? (char)']' : '}';
        }
    }

    private static class VarintCodec
    extends TypeCodec<BigInteger> {
        private static final VarintCodec instance = new VarintCodec();

        private VarintCodec() {
            super(DataType.varint(), BigInteger.class);
        }

        @Override
        public BigInteger parse(String value2) {
            try {
                return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : new BigInteger(value2);
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse varint value from \"%s\"", value2), e);
            }
        }

        @Override
        public String format(BigInteger value2) {
            if (value2 == null) {
                return "NULL";
            }
            return value2.toString();
        }

        @Override
        public ByteBuffer serialize(BigInteger value2, ProtocolVersion protocolVersion2) {
            return value2 == null ? null : ByteBuffer.wrap(value2.toByteArray());
        }

        @Override
        public BigInteger deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion2) {
            return bytes == null || bytes.remaining() == 0 ? null : new BigInteger(Bytes.getArray(bytes));
        }
    }

    private static class TimeUUIDCodec
    extends AbstractUUIDCodec {
        private static final TimeUUIDCodec instance = new TimeUUIDCodec();

        private TimeUUIDCodec() {
            super(DataType.timeuuid());
        }

        @Override
        public String format(UUID value2) {
            if (value2 == null) {
                return "NULL";
            }
            if (value2.version() != 1) {
                throw new InvalidTypeException(String.format("%s is not a Type 1 (time-based) UUID", value2));
            }
            return super.format(value2);
        }

        @Override
        public ByteBuffer serialize(UUID value2, ProtocolVersion protocolVersion2) {
            if (value2 == null) {
                return null;
            }
            if (value2.version() != 1) {
                throw new InvalidTypeException(String.format("%s is not a Type 1 (time-based) UUID", value2));
            }
            return super.serialize(value2, protocolVersion2);
        }
    }

    private static class UUIDCodec
    extends AbstractUUIDCodec {
        private static final UUIDCodec instance = new UUIDCodec();

        private UUIDCodec() {
            super(DataType.uuid());
        }
    }

    private static abstract class AbstractUUIDCodec
    extends TypeCodec<UUID> {
        private AbstractUUIDCodec(DataType cqlType) {
            super(cqlType, UUID.class);
        }

        @Override
        public UUID parse(String value2) {
            try {
                return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : UUID.fromString(value2);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidTypeException(String.format("Cannot parse UUID value from \"%s\"", value2), e);
            }
        }

        @Override
        public String format(UUID value2) {
            if (value2 == null) {
                return "NULL";
            }
            return value2.toString();
        }

        @Override
        public ByteBuffer serialize(UUID value2, ProtocolVersion protocolVersion2) {
            if (value2 == null) {
                return null;
            }
            ByteBuffer bb = ByteBuffer.allocate(16);
            bb.putLong(0, value2.getMostSignificantBits());
            bb.putLong(8, value2.getLeastSignificantBits());
            return bb;
        }

        @Override
        public UUID deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion2) {
            return bytes == null || bytes.remaining() == 0 ? null : new UUID(bytes.getLong(bytes.position()), bytes.getLong(bytes.position() + 8));
        }
    }

    private static class TimeCodec
    extends LongCodec {
        private static final TimeCodec instance = new TimeCodec();

        private TimeCodec() {
            super(DataType.time());
        }

        @Override
        public Long parse(String value2) {
            if (value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL")) {
                return null;
            }
            if (!ParseUtils.isQuoted(value2)) {
                throw new InvalidTypeException("time values must be enclosed by single quotes");
            }
            if (ParseUtils.isLongLiteral(value2 = value2.substring(1, value2.length() - 1))) {
                try {
                    return Long.parseLong(value2);
                }
                catch (NumberFormatException e) {
                    throw new InvalidTypeException(String.format("Cannot parse time value from \"%s\"", value2), e);
                }
            }
            try {
                return ParseUtils.parseTime(value2);
            }
            catch (ParseException e) {
                throw new InvalidTypeException(String.format("Cannot parse time value from \"%s\"", value2), e);
            }
        }

        @Override
        public String format(Long value2) {
            if (value2 == null) {
                return "NULL";
            }
            return ParseUtils.quote(ParseUtils.formatTime(value2));
        }
    }

    private static class DateCodec
    extends TypeCodec<LocalDate> {
        private static final DateCodec instance = new DateCodec();
        private static final String pattern = "yyyy-MM-dd";

        private DateCodec() {
            super(DataType.date(), LocalDate.class);
        }

        @Override
        public LocalDate parse(String value2) {
            if (value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL")) {
                return null;
            }
            if (ParseUtils.isQuoted(value2)) {
                value2 = ParseUtils.unquote(value2);
            }
            if (ParseUtils.isLongLiteral(value2)) {
                long unsigned;
                try {
                    unsigned = Long.parseLong(value2);
                }
                catch (NumberFormatException e) {
                    throw new InvalidTypeException(String.format("Cannot parse date value from \"%s\"", value2), e);
                }
                try {
                    int days = CodecUtils.fromCqlDateToDaysSinceEpoch(unsigned);
                    return LocalDate.fromDaysSinceEpoch(days);
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidTypeException(String.format("Cannot parse date value from \"%s\"", value2), e);
                }
            }
            try {
                Date date = ParseUtils.parseDate(value2, pattern);
                return LocalDate.fromMillisSinceEpoch(date.getTime());
            }
            catch (ParseException e) {
                throw new InvalidTypeException(String.format("Cannot parse date value from \"%s\"", value2), e);
            }
        }

        @Override
        public String format(LocalDate value2) {
            if (value2 == null) {
                return "NULL";
            }
            return ParseUtils.quote(value2.toString());
        }

        @Override
        public ByteBuffer serialize(LocalDate value2, ProtocolVersion protocolVersion2) {
            if (value2 == null) {
                return null;
            }
            int unsigned = CodecUtils.fromSignedToUnsignedInt(value2.getDaysSinceEpoch());
            return IntCodec.instance.serializeNoBoxing(unsigned, protocolVersion2);
        }

        @Override
        public LocalDate deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion2) {
            if (bytes == null || bytes.remaining() == 0) {
                return null;
            }
            int unsigned = IntCodec.instance.deserializeNoBoxing(bytes, protocolVersion2);
            int signed = CodecUtils.fromUnsignedToSignedInt(unsigned);
            return LocalDate.fromDaysSinceEpoch(signed);
        }
    }

    private static class TimestampCodec
    extends TypeCodec<Date> {
        private static final TimestampCodec instance = new TimestampCodec();

        private TimestampCodec() {
            super(DataType.timestamp(), Date.class);
        }

        @Override
        public Date parse(String value2) {
            if (value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL")) {
                return null;
            }
            if (ParseUtils.isQuoted(value2)) {
                value2 = ParseUtils.unquote(value2);
            }
            if (ParseUtils.isLongLiteral(value2)) {
                try {
                    return new Date(Long.parseLong(value2));
                }
                catch (NumberFormatException e) {
                    throw new InvalidTypeException(String.format("Cannot parse timestamp value from \"%s\"", value2));
                }
            }
            try {
                return ParseUtils.parseDate(value2);
            }
            catch (ParseException e) {
                throw new InvalidTypeException(String.format("Cannot parse timestamp value from \"%s\"", value2));
            }
        }

        @Override
        public String format(Date value2) {
            if (value2 == null) {
                return "NULL";
            }
            return Long.toString(value2.getTime());
        }

        @Override
        public ByteBuffer serialize(Date value2, ProtocolVersion protocolVersion2) {
            return value2 == null ? null : BigintCodec.instance.serializeNoBoxing(value2.getTime(), protocolVersion2);
        }

        @Override
        public Date deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion2) {
            return bytes == null || bytes.remaining() == 0 ? null : new Date(BigintCodec.instance.deserializeNoBoxing(bytes, protocolVersion2));
        }
    }

    private static class IntCodec
    extends PrimitiveIntCodec {
        private static final IntCodec instance = new IntCodec();

        private IntCodec() {
            super(DataType.cint());
        }

        @Override
        public Integer parse(String value2) {
            try {
                return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : Integer.valueOf(Integer.parseInt(value2));
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse 32-bits int value from \"%s\"", value2));
            }
        }

        @Override
        public String format(Integer value2) {
            if (value2 == null) {
                return "NULL";
            }
            return Integer.toString(value2);
        }

        @Override
        public ByteBuffer serializeNoBoxing(int value2, ProtocolVersion protocolVersion2) {
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.putInt(0, value2);
            return bb;
        }

        @Override
        public int deserializeNoBoxing(ByteBuffer bytes, ProtocolVersion protocolVersion2) {
            if (bytes == null || bytes.remaining() == 0) {
                return 0;
            }
            if (bytes.remaining() != 4) {
                throw new InvalidTypeException("Invalid 32-bits integer value, expecting 4 bytes but got " + bytes.remaining());
            }
            return bytes.getInt(bytes.position());
        }
    }

    private static class SmallIntCodec
    extends PrimitiveShortCodec {
        private static final SmallIntCodec instance = new SmallIntCodec();

        private SmallIntCodec() {
            super(DataType.smallint());
        }

        @Override
        public Short parse(String value2) {
            try {
                return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : Short.valueOf(Short.parseShort(value2));
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse 16-bits int value from \"%s\"", value2));
            }
        }

        @Override
        public String format(Short value2) {
            if (value2 == null) {
                return "NULL";
            }
            return Short.toString(value2);
        }

        @Override
        public ByteBuffer serializeNoBoxing(short value2, ProtocolVersion protocolVersion2) {
            ByteBuffer bb = ByteBuffer.allocate(2);
            bb.putShort(0, value2);
            return bb;
        }

        @Override
        public short deserializeNoBoxing(ByteBuffer bytes, ProtocolVersion protocolVersion2) {
            if (bytes == null || bytes.remaining() == 0) {
                return 0;
            }
            if (bytes.remaining() != 2) {
                throw new InvalidTypeException("Invalid 16-bits integer value, expecting 2 bytes but got " + bytes.remaining());
            }
            return bytes.getShort(bytes.position());
        }
    }

    private static class TinyIntCodec
    extends PrimitiveByteCodec {
        private static final TinyIntCodec instance = new TinyIntCodec();

        private TinyIntCodec() {
            super(DataType.tinyint());
        }

        @Override
        public Byte parse(String value2) {
            try {
                return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : Byte.valueOf(Byte.parseByte(value2));
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse 8-bits int value from \"%s\"", value2));
            }
        }

        @Override
        public String format(Byte value2) {
            if (value2 == null) {
                return "NULL";
            }
            return Byte.toString(value2);
        }

        @Override
        public ByteBuffer serializeNoBoxing(byte value2, ProtocolVersion protocolVersion2) {
            ByteBuffer bb = ByteBuffer.allocate(1);
            bb.put(0, value2);
            return bb;
        }

        @Override
        public byte deserializeNoBoxing(ByteBuffer bytes, ProtocolVersion protocolVersion2) {
            if (bytes == null || bytes.remaining() == 0) {
                return 0;
            }
            if (bytes.remaining() != 1) {
                throw new InvalidTypeException("Invalid 8-bits integer value, expecting 1 byte but got " + bytes.remaining());
            }
            return bytes.get(bytes.position());
        }
    }

    private static class InetCodec
    extends TypeCodec<InetAddress> {
        private static final InetCodec instance = new InetCodec();

        private InetCodec() {
            super(DataType.inet(), InetAddress.class);
        }

        @Override
        public InetAddress parse(String value2) {
            if (value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL")) {
                return null;
            }
            if (!ParseUtils.isQuoted(value2 = value2.trim())) {
                throw new InvalidTypeException(String.format("inet values must be enclosed in single quotes (\"%s\")", value2));
            }
            try {
                return InetAddress.getByName(value2.substring(1, value2.length() - 1));
            }
            catch (Exception e) {
                throw new InvalidTypeException(String.format("Cannot parse inet value from \"%s\"", value2));
            }
        }

        @Override
        public String format(InetAddress value2) {
            if (value2 == null) {
                return "NULL";
            }
            return "'" + value2.getHostAddress() + "'";
        }

        @Override
        public ByteBuffer serialize(InetAddress value2, ProtocolVersion protocolVersion2) {
            return value2 == null ? null : ByteBuffer.wrap(value2.getAddress());
        }

        @Override
        public InetAddress deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion2) {
            if (bytes == null || bytes.remaining() == 0) {
                return null;
            }
            try {
                return InetAddress.getByAddress(Bytes.getArray(bytes));
            }
            catch (UnknownHostException e) {
                throw new InvalidTypeException("Invalid bytes for inet value, got " + bytes.remaining() + " bytes");
            }
        }
    }

    private static class FloatCodec
    extends PrimitiveFloatCodec {
        private static final FloatCodec instance = new FloatCodec();

        private FloatCodec() {
            super(DataType.cfloat());
        }

        @Override
        public Float parse(String value2) {
            try {
                return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : Float.valueOf(Float.parseFloat(value2));
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse 32-bits float value from \"%s\"", value2));
            }
        }

        @Override
        public String format(Float value2) {
            if (value2 == null) {
                return "NULL";
            }
            return Float.toString(value2.floatValue());
        }

        @Override
        public ByteBuffer serializeNoBoxing(float value2, ProtocolVersion protocolVersion2) {
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.putFloat(0, value2);
            return bb;
        }

        @Override
        public float deserializeNoBoxing(ByteBuffer bytes, ProtocolVersion protocolVersion2) {
            if (bytes == null || bytes.remaining() == 0) {
                return 0.0f;
            }
            if (bytes.remaining() != 4) {
                throw new InvalidTypeException("Invalid 32-bits float value, expecting 4 bytes but got " + bytes.remaining());
            }
            return bytes.getFloat(bytes.position());
        }
    }

    private static class DoubleCodec
    extends PrimitiveDoubleCodec {
        private static final DoubleCodec instance = new DoubleCodec();

        private DoubleCodec() {
            super(DataType.cdouble());
        }

        @Override
        public Double parse(String value2) {
            try {
                return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : Double.valueOf(Double.parseDouble(value2));
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse 64-bits double value from \"%s\"", value2));
            }
        }

        @Override
        public String format(Double value2) {
            if (value2 == null) {
                return "NULL";
            }
            return Double.toString(value2);
        }

        @Override
        public ByteBuffer serializeNoBoxing(double value2, ProtocolVersion protocolVersion2) {
            ByteBuffer bb = ByteBuffer.allocate(8);
            bb.putDouble(0, value2);
            return bb;
        }

        @Override
        public double deserializeNoBoxing(ByteBuffer bytes, ProtocolVersion protocolVersion2) {
            if (bytes == null || bytes.remaining() == 0) {
                return 0.0;
            }
            if (bytes.remaining() != 8) {
                throw new InvalidTypeException("Invalid 64-bits double value, expecting 8 bytes but got " + bytes.remaining());
            }
            return bytes.getDouble(bytes.position());
        }
    }

    private static class DecimalCodec
    extends TypeCodec<BigDecimal> {
        private static final DecimalCodec instance = new DecimalCodec();

        private DecimalCodec() {
            super(DataType.decimal(), BigDecimal.class);
        }

        @Override
        public BigDecimal parse(String value2) {
            try {
                return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : new BigDecimal(value2);
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse decimal value from \"%s\"", value2));
            }
        }

        @Override
        public String format(BigDecimal value2) {
            if (value2 == null) {
                return "NULL";
            }
            return value2.toString();
        }

        @Override
        public ByteBuffer serialize(BigDecimal value2, ProtocolVersion protocolVersion2) {
            if (value2 == null) {
                return null;
            }
            BigInteger bi = value2.unscaledValue();
            int scale = value2.scale();
            byte[] bibytes = bi.toByteArray();
            ByteBuffer bytes = ByteBuffer.allocate(4 + bibytes.length);
            bytes.putInt(scale);
            bytes.put(bibytes);
            bytes.rewind();
            return bytes;
        }

        @Override
        public BigDecimal deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion2) {
            if (bytes == null || bytes.remaining() == 0) {
                return null;
            }
            if (bytes.remaining() < 4) {
                throw new InvalidTypeException("Invalid decimal value, expecting at least 4 bytes but got " + bytes.remaining());
            }
            bytes = bytes.duplicate();
            int scale = bytes.getInt();
            byte[] bibytes = new byte[bytes.remaining()];
            bytes.get(bibytes);
            BigInteger bi = new BigInteger(bibytes);
            return new BigDecimal(bi, scale);
        }
    }

    private static class BooleanCodec
    extends PrimitiveBooleanCodec {
        private static final ByteBuffer TRUE = ByteBuffer.wrap(new byte[]{1});
        private static final ByteBuffer FALSE = ByteBuffer.wrap(new byte[]{0});
        private static final BooleanCodec instance = new BooleanCodec();

        private BooleanCodec() {
            super(DataType.cboolean());
        }

        @Override
        public Boolean parse(String value2) {
            if (value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL")) {
                return null;
            }
            if (value2.equalsIgnoreCase(Boolean.FALSE.toString())) {
                return false;
            }
            if (value2.equalsIgnoreCase(Boolean.TRUE.toString())) {
                return true;
            }
            throw new InvalidTypeException(String.format("Cannot parse boolean value from \"%s\"", value2));
        }

        @Override
        public String format(Boolean value2) {
            if (value2 == null) {
                return "NULL";
            }
            return value2 != false ? "true" : "false";
        }

        @Override
        public ByteBuffer serializeNoBoxing(boolean value2, ProtocolVersion protocolVersion2) {
            return value2 ? TRUE.duplicate() : FALSE.duplicate();
        }

        @Override
        public boolean deserializeNoBoxing(ByteBuffer bytes, ProtocolVersion protocolVersion2) {
            if (bytes == null || bytes.remaining() == 0) {
                return false;
            }
            if (bytes.remaining() != 1) {
                throw new InvalidTypeException("Invalid boolean value, expecting 1 byte but got " + bytes.remaining());
            }
            return bytes.get(bytes.position()) != 0;
        }
    }

    private static class CustomCodec
    extends TypeCodec<ByteBuffer> {
        private CustomCodec(DataType custom) {
            super(custom, ByteBuffer.class);
            assert (custom.getName() == DataType.Name.CUSTOM);
        }

        @Override
        public ByteBuffer parse(String value2) {
            return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : Bytes.fromHexString(value2);
        }

        @Override
        public String format(ByteBuffer value2) {
            if (value2 == null) {
                return "NULL";
            }
            return Bytes.toHexString(value2);
        }

        @Override
        public ByteBuffer serialize(ByteBuffer value2, ProtocolVersion protocolVersion2) {
            return value2 == null ? null : value2.duplicate();
        }

        @Override
        public ByteBuffer deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion2) {
            return bytes == null ? null : bytes.duplicate();
        }
    }

    private static class BlobCodec
    extends TypeCodec<ByteBuffer> {
        private static final BlobCodec instance = new BlobCodec();

        private BlobCodec() {
            super(DataType.blob(), ByteBuffer.class);
        }

        @Override
        public ByteBuffer parse(String value2) {
            return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : Bytes.fromHexString(value2);
        }

        @Override
        public String format(ByteBuffer value2) {
            if (value2 == null) {
                return "NULL";
            }
            return Bytes.toHexString(value2);
        }

        @Override
        public ByteBuffer serialize(ByteBuffer value2, ProtocolVersion protocolVersion2) {
            return value2 == null ? null : value2.duplicate();
        }

        @Override
        public ByteBuffer deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion2) {
            return bytes == null ? null : bytes.duplicate();
        }
    }

    private static class CounterCodec
    extends LongCodec {
        private static final CounterCodec instance = new CounterCodec();

        private CounterCodec() {
            super(DataType.counter());
        }
    }

    private static class BigintCodec
    extends LongCodec {
        private static final BigintCodec instance = new BigintCodec();

        private BigintCodec() {
            super(DataType.bigint());
        }
    }

    private static abstract class LongCodec
    extends PrimitiveLongCodec {
        private LongCodec(DataType cqlType) {
            super(cqlType);
        }

        @Override
        public Long parse(String value2) {
            try {
                return value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL") ? null : Long.valueOf(Long.parseLong(value2));
            }
            catch (NumberFormatException e) {
                throw new InvalidTypeException(String.format("Cannot parse 64-bits long value from \"%s\"", value2));
            }
        }

        @Override
        public String format(Long value2) {
            if (value2 == null) {
                return "NULL";
            }
            return Long.toString(value2);
        }

        @Override
        public ByteBuffer serializeNoBoxing(long value2, ProtocolVersion protocolVersion2) {
            ByteBuffer bb = ByteBuffer.allocate(8);
            bb.putLong(0, value2);
            return bb;
        }

        @Override
        public long deserializeNoBoxing(ByteBuffer bytes, ProtocolVersion protocolVersion2) {
            if (bytes == null || bytes.remaining() == 0) {
                return 0L;
            }
            if (bytes.remaining() != 8) {
                throw new InvalidTypeException("Invalid 64-bits long value, expecting 8 bytes but got " + bytes.remaining());
            }
            return bytes.getLong(bytes.position());
        }
    }

    private static class AsciiCodec
    extends StringCodec {
        private static final AsciiCodec instance = new AsciiCodec();
        private static final Pattern ASCII_PATTERN = Pattern.compile("^\\p{ASCII}*$");

        private AsciiCodec() {
            super(DataType.ascii(), Charset.forName("US-ASCII"));
        }

        @Override
        public ByteBuffer serialize(String value2, ProtocolVersion protocolVersion2) {
            if (value2 != null && !ASCII_PATTERN.matcher(value2).matches()) {
                throw new InvalidTypeException(String.format("%s is not a valid ASCII String", value2));
            }
            return super.serialize(value2, protocolVersion2);
        }

        @Override
        public String format(String value2) {
            if (value2 != null && !ASCII_PATTERN.matcher(value2).matches()) {
                throw new InvalidTypeException(String.format("%s is not a valid ASCII String", value2));
            }
            return super.format(value2);
        }
    }

    private static class VarcharCodec
    extends StringCodec {
        private static final VarcharCodec instance = new VarcharCodec();

        private VarcharCodec() {
            super(DataType.varchar(), Charset.forName("UTF-8"));
        }
    }

    private static abstract class StringCodec
    extends TypeCodec<String> {
        private final Charset charset;

        private StringCodec(DataType cqlType, Charset charset) {
            super(cqlType, String.class);
            this.charset = charset;
        }

        @Override
        public String parse(String value2) {
            if (value2 == null || value2.isEmpty() || value2.equalsIgnoreCase("NULL")) {
                return null;
            }
            if (!ParseUtils.isQuoted(value2)) {
                throw new InvalidTypeException("text or varchar values must be enclosed by single quotes");
            }
            return ParseUtils.unquote(value2);
        }

        @Override
        public String format(String value2) {
            if (value2 == null) {
                return "NULL";
            }
            return ParseUtils.quote(value2);
        }

        @Override
        public ByteBuffer serialize(String value2, ProtocolVersion protocolVersion2) {
            return value2 == null ? null : ByteBuffer.wrap(value2.getBytes(this.charset));
        }

        @Override
        public String deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion2) {
            if (bytes == null) {
                return null;
            }
            if (bytes.remaining() == 0) {
                return "";
            }
            return new String(Bytes.getArray(bytes), this.charset);
        }
    }

    public static abstract class PrimitiveDoubleCodec
    extends TypeCodec<Double> {
        protected PrimitiveDoubleCodec(DataType cqlType) {
            super(cqlType, Double.class);
        }

        public abstract ByteBuffer serializeNoBoxing(double var1, ProtocolVersion var3);

        public abstract double deserializeNoBoxing(ByteBuffer var1, ProtocolVersion var2);

        @Override
        public ByteBuffer serialize(Double value2, ProtocolVersion protocolVersion2) {
            return value2 == null ? null : this.serializeNoBoxing(value2, protocolVersion2);
        }

        @Override
        public Double deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion2) {
            return bytes == null || bytes.remaining() == 0 ? null : Double.valueOf(this.deserializeNoBoxing(bytes, protocolVersion2));
        }
    }

    public static abstract class PrimitiveFloatCodec
    extends TypeCodec<Float> {
        protected PrimitiveFloatCodec(DataType cqlType) {
            super(cqlType, Float.class);
        }

        public abstract ByteBuffer serializeNoBoxing(float var1, ProtocolVersion var2);

        public abstract float deserializeNoBoxing(ByteBuffer var1, ProtocolVersion var2);

        @Override
        public ByteBuffer serialize(Float value2, ProtocolVersion protocolVersion2) {
            return value2 == null ? null : this.serializeNoBoxing(value2.floatValue(), protocolVersion2);
        }

        @Override
        public Float deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion2) {
            return bytes == null || bytes.remaining() == 0 ? null : Float.valueOf(this.deserializeNoBoxing(bytes, protocolVersion2));
        }
    }

    public static abstract class PrimitiveLongCodec
    extends TypeCodec<Long> {
        protected PrimitiveLongCodec(DataType cqlType) {
            super(cqlType, Long.class);
        }

        public abstract ByteBuffer serializeNoBoxing(long var1, ProtocolVersion var3);

        public abstract long deserializeNoBoxing(ByteBuffer var1, ProtocolVersion var2);

        @Override
        public ByteBuffer serialize(Long value2, ProtocolVersion protocolVersion2) {
            return value2 == null ? null : this.serializeNoBoxing(value2, protocolVersion2);
        }

        @Override
        public Long deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion2) {
            return bytes == null || bytes.remaining() == 0 ? null : Long.valueOf(this.deserializeNoBoxing(bytes, protocolVersion2));
        }
    }

    public static abstract class PrimitiveIntCodec
    extends TypeCodec<Integer> {
        protected PrimitiveIntCodec(DataType cqlType) {
            super(cqlType, Integer.class);
        }

        public abstract ByteBuffer serializeNoBoxing(int var1, ProtocolVersion var2);

        public abstract int deserializeNoBoxing(ByteBuffer var1, ProtocolVersion var2);

        @Override
        public ByteBuffer serialize(Integer value2, ProtocolVersion protocolVersion2) {
            return value2 == null ? null : this.serializeNoBoxing(value2, protocolVersion2);
        }

        @Override
        public Integer deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion2) {
            return bytes == null || bytes.remaining() == 0 ? null : Integer.valueOf(this.deserializeNoBoxing(bytes, protocolVersion2));
        }
    }

    public static abstract class PrimitiveShortCodec
    extends TypeCodec<Short> {
        protected PrimitiveShortCodec(DataType cqlType) {
            super(cqlType, Short.class);
        }

        public abstract ByteBuffer serializeNoBoxing(short var1, ProtocolVersion var2);

        public abstract short deserializeNoBoxing(ByteBuffer var1, ProtocolVersion var2);

        @Override
        public ByteBuffer serialize(Short value2, ProtocolVersion protocolVersion2) {
            return value2 == null ? null : this.serializeNoBoxing(value2, protocolVersion2);
        }

        @Override
        public Short deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion2) {
            return bytes == null || bytes.remaining() == 0 ? null : Short.valueOf(this.deserializeNoBoxing(bytes, protocolVersion2));
        }
    }

    public static abstract class PrimitiveByteCodec
    extends TypeCodec<Byte> {
        protected PrimitiveByteCodec(DataType cqlType) {
            super(cqlType, Byte.class);
        }

        public abstract ByteBuffer serializeNoBoxing(byte var1, ProtocolVersion var2);

        public abstract byte deserializeNoBoxing(ByteBuffer var1, ProtocolVersion var2);

        @Override
        public ByteBuffer serialize(Byte value2, ProtocolVersion protocolVersion2) {
            return value2 == null ? null : this.serializeNoBoxing(value2, protocolVersion2);
        }

        @Override
        public Byte deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion2) {
            return bytes == null || bytes.remaining() == 0 ? null : Byte.valueOf(this.deserializeNoBoxing(bytes, protocolVersion2));
        }
    }

    public static abstract class PrimitiveBooleanCodec
    extends TypeCodec<Boolean> {
        protected PrimitiveBooleanCodec(DataType cqlType) {
            super(cqlType, Boolean.class);
        }

        public abstract ByteBuffer serializeNoBoxing(boolean var1, ProtocolVersion var2);

        public abstract boolean deserializeNoBoxing(ByteBuffer var1, ProtocolVersion var2);

        @Override
        public ByteBuffer serialize(Boolean value2, ProtocolVersion protocolVersion2) {
            return value2 == null ? null : this.serializeNoBoxing(value2, protocolVersion2);
        }

        @Override
        public Boolean deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion2) {
            return bytes == null || bytes.remaining() == 0 ? null : Boolean.valueOf(this.deserializeNoBoxing(bytes, protocolVersion2));
        }
    }
}

