/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core.exceptions;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import shade.com.datastax.spark.connector.driver.core.exceptions.CoordinatorException;
import shade.com.datastax.spark.connector.driver.core.exceptions.DriverException;

public class BusyConnectionException
extends DriverException
implements CoordinatorException {
    private static final long serialVersionUID = 0L;
    private final InetSocketAddress address;

    public BusyConnectionException(InetSocketAddress address) {
        super(String.format("[%s] Connection has run out of stream IDs", address.getAddress()));
        this.address = address;
    }

    public BusyConnectionException(InetSocketAddress address, Throwable cause) {
        super(String.format("[%s] Connection has run out of stream IDs", address.getAddress()), cause);
        this.address = address;
    }

    @Override
    public InetAddress getHost() {
        return this.address.getAddress();
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public BusyConnectionException copy() {
        return new BusyConnectionException(this.address, (Throwable)this);
    }
}

