/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core.exceptions;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import shade.com.datastax.spark.connector.driver.core.exceptions.DriverException;

public class NoHostAvailableException
extends DriverException {
    private static final long serialVersionUID = 0L;
    private static final int MAX_ERRORS_IN_DEFAULT_MESSAGE = 3;
    private final Map<InetSocketAddress, Throwable> errors;

    public NoHostAvailableException(Map<InetSocketAddress, Throwable> errors) {
        super(NoHostAvailableException.makeMessage(errors, 3, false, false));
        this.errors = errors;
    }

    private NoHostAvailableException(String message, Throwable cause, Map<InetSocketAddress, Throwable> errors) {
        super(message, cause);
        this.errors = errors;
    }

    public Map<InetSocketAddress, Throwable> getErrors() {
        return new HashMap<InetSocketAddress, Throwable>(this.errors);
    }

    public String getCustomMessage(int maxErrors, boolean formatted, boolean includeStackTraces) {
        if (includeStackTraces) {
            formatted = true;
        }
        return NoHostAvailableException.makeMessage(this.errors, maxErrors, formatted, includeStackTraces);
    }

    @Override
    public NoHostAvailableException copy() {
        return new NoHostAvailableException(this.getMessage(), this, this.errors);
    }

    private static String makeMessage(Map<InetSocketAddress, Throwable> errors, int maxErrorsInMessage, boolean formatted, boolean includeStackTraces) {
        if (errors.size() == 0) {
            return "All host(s) tried for query failed (no host was tried)";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter out = new PrintWriter(stringWriter);
        out.print("All host(s) tried for query failed (tried:");
        out.print(formatted ? "\n" : " ");
        int n = 0;
        boolean truncated = false;
        for (Map.Entry<InetSocketAddress, Throwable> entry : errors.entrySet()) {
            if (n > 0) {
                out.print(formatted ? "\n" : ", ");
            }
            out.print(entry.getKey());
            if (n < maxErrorsInMessage) {
                if (includeStackTraces) {
                    out.print("\n");
                    entry.getValue().printStackTrace(out);
                    out.print("\n");
                } else {
                    out.printf(" (%s)", entry.getValue());
                }
            } else {
                truncated = true;
            }
            ++n;
        }
        if (truncated) {
            out.print(formatted ? "\n" : " ");
            out.printf("[only showing errors of first %d hosts, use getErrors() for more details]", maxErrorsInMessage);
        }
        if (formatted && !includeStackTraces) {
            out.print("\n");
        }
        out.print(")");
        out.close();
        return stringWriter.toString();
    }
}

