/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core.exceptions;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import shade.com.datastax.spark.connector.driver.core.exceptions.CoordinatorException;
import shade.com.datastax.spark.connector.driver.core.exceptions.QueryExecutionException;

public class OverloadedException
extends QueryExecutionException
implements CoordinatorException {
    private static final long serialVersionUID = 0L;
    private final InetSocketAddress address;

    public OverloadedException(InetSocketAddress address, String message) {
        super(String.format("Queried host (%s) was overloaded: %s", address, message));
        this.address = address;
    }

    private OverloadedException(InetSocketAddress address, String message, OverloadedException cause) {
        super(message, cause);
        this.address = address;
    }

    @Override
    public InetAddress getHost() {
        return this.address.getAddress();
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public OverloadedException copy() {
        return new OverloadedException(this.address, this.getMessage(), this);
    }
}

