/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core.exceptions;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import shade.com.datastax.spark.connector.driver.core.exceptions.CoordinatorException;
import shade.com.datastax.spark.connector.driver.core.exceptions.DriverInternalError;

public class ProtocolError
extends DriverInternalError
implements CoordinatorException {
    private static final long serialVersionUID = 0L;
    private final InetSocketAddress address;

    public ProtocolError(InetSocketAddress address, String message) {
        super(String.format("An unexpected protocol error occurred on host %s. This is a bug in this library, please report: %s", address, message));
        this.address = address;
    }

    private ProtocolError(InetSocketAddress address, String message, ProtocolError cause) {
        super(message, cause);
        this.address = address;
    }

    @Override
    public InetAddress getHost() {
        return this.address.getAddress();
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public ProtocolError copy() {
        return new ProtocolError(this.address, this.getMessage(), this);
    }
}

