/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core.exceptions;

import java.net.InetSocketAddress;
import shade.com.datastax.spark.connector.driver.core.ConsistencyLevel;
import shade.com.datastax.spark.connector.driver.core.exceptions.QueryConsistencyException;

public class ReadFailureException
extends QueryConsistencyException {
    private final int failed;
    private final boolean dataPresent;

    public ReadFailureException(ConsistencyLevel consistency, int received, int required, int failed, boolean dataPresent) {
        this(null, consistency, received, required, failed, dataPresent);
    }

    public ReadFailureException(InetSocketAddress address, ConsistencyLevel consistency, int received, int required, int failed, boolean dataPresent) {
        super(address, String.format("Cassandra failure during read query at consistency %s (%d responses were required but only %d replica responded, %d failed)", new Object[]{consistency, required, received, failed}), consistency, received, required);
        this.failed = failed;
        this.dataPresent = dataPresent;
    }

    private ReadFailureException(InetSocketAddress address, String msg, Throwable cause, ConsistencyLevel consistency, int received, int required, int failed, boolean dataPresent) {
        super(address, msg, cause, consistency, received, required);
        this.failed = failed;
        this.dataPresent = dataPresent;
    }

    public int getFailures() {
        return this.failed;
    }

    public boolean wasDataRetrieved() {
        return this.dataPresent;
    }

    @Override
    public ReadFailureException copy() {
        return new ReadFailureException(this.getAddress(), this.getMessage(), this, this.getConsistencyLevel(), this.getReceivedAcknowledgements(), this.getRequiredAcknowledgements(), this.getFailures(), this.wasDataRetrieved());
    }

    public ReadFailureException copy(InetSocketAddress address) {
        return new ReadFailureException(address, this.getMessage(), this, this.getConsistencyLevel(), this.getReceivedAcknowledgements(), this.getRequiredAcknowledgements(), this.failed, this.dataPresent);
    }
}

