/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core.exceptions;

import java.net.InetSocketAddress;
import shade.com.datastax.spark.connector.driver.core.ConsistencyLevel;
import shade.com.datastax.spark.connector.driver.core.WriteType;
import shade.com.datastax.spark.connector.driver.core.exceptions.QueryConsistencyException;

public class WriteFailureException
extends QueryConsistencyException {
    private final WriteType writeType;
    private final int failed;

    public WriteFailureException(ConsistencyLevel consistency, WriteType writeType, int received, int required, int failed) {
        this(null, consistency, writeType, received, required, failed);
    }

    public WriteFailureException(InetSocketAddress address, ConsistencyLevel consistency, WriteType writeType, int received, int required, int failed) {
        super(address, String.format("Cassandra failure during write query at consistency %s (%d responses were required but only %d replica responded, %d failed)", new Object[]{consistency, required, received, failed}), consistency, received, required);
        this.writeType = writeType;
        this.failed = failed;
    }

    private WriteFailureException(InetSocketAddress address, String msg, Throwable cause, ConsistencyLevel consistency, WriteType writeType, int received, int required, int failed) {
        super(address, msg, cause, consistency, received, required);
        this.writeType = writeType;
        this.failed = failed;
    }

    public WriteType getWriteType() {
        return this.writeType;
    }

    public int getFailures() {
        return this.failed;
    }

    @Override
    public WriteFailureException copy() {
        return new WriteFailureException(this.getAddress(), this.getMessage(), this, this.getConsistencyLevel(), this.getWriteType(), this.getReceivedAcknowledgements(), this.getRequiredAcknowledgements(), this.getFailures());
    }

    public WriteFailureException copy(InetSocketAddress address) {
        return new WriteFailureException(address, this.getMessage(), this, this.getConsistencyLevel(), this.getWriteType(), this.getReceivedAcknowledgements(), this.getRequiredAcknowledgements(), this.failed);
    }
}

