/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core.policies;

import java.util.concurrent.atomic.AtomicInteger;
import shade.com.datastax.spark.connector.driver.core.Cluster;
import shade.com.datastax.spark.connector.driver.core.Host;
import shade.com.datastax.spark.connector.driver.core.Statement;
import shade.com.datastax.spark.connector.driver.core.policies.SpeculativeExecutionPolicy;
import shade.com.datastax.spark.connector.google.common.base.Preconditions;

public class ConstantSpeculativeExecutionPolicy
implements SpeculativeExecutionPolicy {
    private final int maxSpeculativeExecutions;
    private final long constantDelayMillis;

    public ConstantSpeculativeExecutionPolicy(long constantDelayMillis, int maxSpeculativeExecutions) {
        Preconditions.checkArgument(constantDelayMillis > 0L, "delay must be strictly positive (was %d)", constantDelayMillis);
        Preconditions.checkArgument(maxSpeculativeExecutions > 0, "number of speculative executions must be strictly positive (was %d)", maxSpeculativeExecutions);
        this.constantDelayMillis = constantDelayMillis;
        this.maxSpeculativeExecutions = maxSpeculativeExecutions;
    }

    @Override
    public SpeculativeExecutionPolicy.SpeculativeExecutionPlan newPlan(String loggedKeyspace, Statement statement) {
        return new SpeculativeExecutionPolicy.SpeculativeExecutionPlan(){
            private final AtomicInteger remaining;
            {
                this.remaining = new AtomicInteger(ConstantSpeculativeExecutionPolicy.this.maxSpeculativeExecutions);
            }

            @Override
            public long nextExecution(Host lastQueried) {
                return this.remaining.getAndDecrement() > 0 ? ConstantSpeculativeExecutionPolicy.this.constantDelayMillis : -1L;
            }
        };
    }

    @Override
    public void init(Cluster cluster) {
    }

    @Override
    public void close() {
    }
}

