/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shade.com.datastax.spark.connector.driver.core.Cluster;
import shade.com.datastax.spark.connector.driver.core.Configuration;
import shade.com.datastax.spark.connector.driver.core.ConsistencyLevel;
import shade.com.datastax.spark.connector.driver.core.Host;
import shade.com.datastax.spark.connector.driver.core.HostDistance;
import shade.com.datastax.spark.connector.driver.core.Statement;
import shade.com.datastax.spark.connector.driver.core.policies.LoadBalancingPolicy;
import shade.com.datastax.spark.connector.google.common.annotations.VisibleForTesting;
import shade.com.datastax.spark.connector.google.common.base.Joiner;
import shade.com.datastax.spark.connector.google.common.base.Preconditions;
import shade.com.datastax.spark.connector.google.common.base.Strings;
import shade.com.datastax.spark.connector.google.common.collect.AbstractIterator;

public class DCAwareRoundRobinPolicy
implements LoadBalancingPolicy {
    private static final Logger logger = LoggerFactory.getLogger(DCAwareRoundRobinPolicy.class);
    private static final String UNSET = "";
    private final ConcurrentMap<String, CopyOnWriteArrayList<Host>> perDcLiveHosts = new ConcurrentHashMap<String, CopyOnWriteArrayList<Host>>();
    private final AtomicInteger index = new AtomicInteger();
    @VisibleForTesting
    volatile String localDc;
    private final int usedHostsPerRemoteDc;
    private final boolean dontHopForLocalCL;
    private volatile Configuration configuration;

    public static Builder builder() {
        return new Builder();
    }

    private DCAwareRoundRobinPolicy(String localDc, int usedHostsPerRemoteDc, boolean allowRemoteDCsForLocalConsistencyLevel, boolean allowEmptyLocalDc) {
        if (!allowEmptyLocalDc && Strings.isNullOrEmpty(localDc)) {
            throw new IllegalArgumentException("Null or empty data center specified for DC-aware policy");
        }
        this.localDc = localDc == null ? UNSET : localDc;
        this.usedHostsPerRemoteDc = usedHostsPerRemoteDc;
        this.dontHopForLocalCL = !allowRemoteDCsForLocalConsistencyLevel;
    }

    @Override
    public void init(Cluster cluster, Collection<Host> hosts2) {
        if (this.localDc != UNSET) {
            logger.info("Using provided data-center name '{}' for DCAwareRoundRobinPolicy", (Object)this.localDc);
        }
        this.configuration = cluster.getConfiguration();
        ArrayList<String> notInLocalDC = new ArrayList<String>();
        for (Host host : hosts2) {
            String dc = this.dc(host);
            if (this.localDc == UNSET && dc != UNSET) {
                logger.info("Using data-center name '{}' for DCAwareRoundRobinPolicy (if this is incorrect, please provide the correct datacenter name with DCAwareRoundRobinPolicy constructor)", (Object)dc);
                this.localDc = dc;
            } else if (!dc.equals(this.localDc)) {
                notInLocalDC.add(String.format("%s (%s)", host.toString(), dc));
            }
            CopyOnWriteArrayList prev = (CopyOnWriteArrayList)this.perDcLiveHosts.get(dc);
            if (prev == null) {
                this.perDcLiveHosts.put(dc, new CopyOnWriteArrayList<Host>(Collections.singletonList(host)));
                continue;
            }
            prev.addIfAbsent(host);
        }
        if (notInLocalDC.size() > 0) {
            String nonLocalHosts = Joiner.on(",").join(notInLocalDC);
            logger.warn("Some contact points don't match local data center. Local DC = {}. Non-conforming contact points: {}", (Object)this.localDc, (Object)nonLocalHosts);
        }
        this.index.set(new Random().nextInt(Math.max(hosts2.size(), 1)));
    }

    private String dc(Host host) {
        String dc = host.getDatacenter();
        return dc == null ? this.localDc : dc;
    }

    private static CopyOnWriteArrayList<Host> cloneList(CopyOnWriteArrayList<Host> list) {
        return (CopyOnWriteArrayList)list.clone();
    }

    @Override
    public HostDistance distance(Host host) {
        String dc = this.dc(host);
        if (dc == UNSET || dc.equals(this.localDc)) {
            return HostDistance.LOCAL;
        }
        CopyOnWriteArrayList<Host> dcHosts = (CopyOnWriteArrayList<Host>)this.perDcLiveHosts.get(dc);
        if (dcHosts == null || this.usedHostsPerRemoteDc == 0) {
            return HostDistance.IGNORED;
        }
        return (dcHosts = DCAwareRoundRobinPolicy.cloneList(dcHosts)).subList(0, Math.min(dcHosts.size(), this.usedHostsPerRemoteDc)).contains(host) ? HostDistance.REMOTE : HostDistance.IGNORED;
    }

    @Override
    public Iterator<Host> newQueryPlan(String loggedKeyspace, final Statement statement) {
        CopyOnWriteArrayList localLiveHosts = (CopyOnWriteArrayList)this.perDcLiveHosts.get(this.localDc);
        final List hosts2 = localLiveHosts == null ? Collections.emptyList() : DCAwareRoundRobinPolicy.cloneList(localLiveHosts);
        final int startIdx = this.index.getAndIncrement();
        return new AbstractIterator<Host>(){
            private int idx;
            private int remainingLocal;
            private Iterator<String> remoteDcs;
            private List<Host> currentDcHosts;
            private int currentDcRemaining;
            {
                this.idx = startIdx;
                this.remainingLocal = hosts2.size();
            }

            @Override
            protected Host computeNext() {
                while (true) {
                    ConsistencyLevel cl;
                    if (this.remainingLocal > 0) {
                        int c;
                        --this.remainingLocal;
                        if ((c = this.idx++ % hosts2.size()) < 0) {
                            c += hosts2.size();
                        }
                        return (Host)hosts2.get(c);
                    }
                    if (this.currentDcHosts != null && this.currentDcRemaining > 0) {
                        int c;
                        --this.currentDcRemaining;
                        if ((c = this.idx++ % this.currentDcHosts.size()) < 0) {
                            c += this.currentDcHosts.size();
                        }
                        return this.currentDcHosts.get(c);
                    }
                    ConsistencyLevel consistencyLevel = cl = statement.getConsistencyLevel() == null ? DCAwareRoundRobinPolicy.this.configuration.getQueryOptions().getConsistencyLevel() : statement.getConsistencyLevel();
                    if (DCAwareRoundRobinPolicy.this.dontHopForLocalCL && cl.isDCLocal()) {
                        return (Host)this.endOfData();
                    }
                    if (this.remoteDcs == null) {
                        HashSet copy2 = new HashSet(DCAwareRoundRobinPolicy.this.perDcLiveHosts.keySet());
                        copy2.remove(DCAwareRoundRobinPolicy.this.localDc);
                        this.remoteDcs = copy2.iterator();
                    }
                    if (!this.remoteDcs.hasNext()) break;
                    String nextRemoteDc = this.remoteDcs.next();
                    CopyOnWriteArrayList nextDcHosts = (CopyOnWriteArrayList)DCAwareRoundRobinPolicy.this.perDcLiveHosts.get(nextRemoteDc);
                    if (nextDcHosts == null) continue;
                    CopyOnWriteArrayList dcHosts = DCAwareRoundRobinPolicy.cloneList(nextDcHosts);
                    this.currentDcHosts = dcHosts.subList(0, Math.min(dcHosts.size(), DCAwareRoundRobinPolicy.this.usedHostsPerRemoteDc));
                    this.currentDcRemaining = this.currentDcHosts.size();
                }
                return (Host)this.endOfData();
            }
        };
    }

    @Override
    public void onUp(Host host) {
        CopyOnWriteArrayList<Host> newMap;
        CopyOnWriteArrayList<Host> dcHosts;
        String dc = this.dc(host);
        if (this.localDc == UNSET && dc != UNSET) {
            logger.info("Using data-center name '{}' for DCAwareRoundRobinPolicy (if this is incorrect, please provide the correct datacenter name with DCAwareRoundRobinPolicy constructor)", (Object)dc);
            this.localDc = dc;
        }
        if ((dcHosts = (CopyOnWriteArrayList<Host>)this.perDcLiveHosts.get(dc)) == null && (dcHosts = this.perDcLiveHosts.putIfAbsent(dc, newMap = new CopyOnWriteArrayList<Host>(Collections.singletonList(host)))) == null) {
            return;
        }
        dcHosts.addIfAbsent(host);
    }

    @Override
    public void onDown(Host host) {
        CopyOnWriteArrayList dcHosts = (CopyOnWriteArrayList)this.perDcLiveHosts.get(this.dc(host));
        if (dcHosts != null) {
            dcHosts.remove(host);
        }
    }

    @Override
    public void onAdd(Host host) {
        this.onUp(host);
    }

    @Override
    public void onRemove(Host host) {
        this.onDown(host);
    }

    @Override
    public void close() {
    }

    public static class Builder {
        private String localDc;
        private int usedHostsPerRemoteDc;
        private boolean allowRemoteDCsForLocalConsistencyLevel;

        public Builder withLocalDc(String localDc) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(localDc), "localDc name can't be null or empty. If you want to let the policy autodetect the datacenter, don't call Builder.withLocalDC");
            this.localDc = localDc;
            return this;
        }

        public Builder withUsedHostsPerRemoteDc(int usedHostsPerRemoteDc) {
            Preconditions.checkArgument(usedHostsPerRemoteDc >= 0, "usedHostsPerRemoteDc must be equal or greater than 0");
            this.usedHostsPerRemoteDc = usedHostsPerRemoteDc;
            return this;
        }

        public Builder allowRemoteDCsForLocalConsistencyLevel() {
            this.allowRemoteDCsForLocalConsistencyLevel = true;
            return this;
        }

        public DCAwareRoundRobinPolicy build() {
            if (this.usedHostsPerRemoteDc == 0 && this.allowRemoteDCsForLocalConsistencyLevel) {
                logger.warn("Setting allowRemoteDCsForLocalConsistencyLevel has no effect if usedHostsPerRemoteDc = 0. This setting will be ignored");
            }
            return new DCAwareRoundRobinPolicy(this.localDc, this.usedHostsPerRemoteDc, this.allowRemoteDCsForLocalConsistencyLevel, true);
        }
    }
}

