/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core.policies;

import shade.com.datastax.spark.connector.driver.core.Cluster;
import shade.com.datastax.spark.connector.driver.core.ConsistencyLevel;
import shade.com.datastax.spark.connector.driver.core.Statement;
import shade.com.datastax.spark.connector.driver.core.WriteType;
import shade.com.datastax.spark.connector.driver.core.exceptions.DriverException;

public interface RetryPolicy {
    public RetryDecision onReadTimeout(Statement var1, ConsistencyLevel var2, int var3, int var4, boolean var5, int var6);

    public RetryDecision onWriteTimeout(Statement var1, ConsistencyLevel var2, WriteType var3, int var4, int var5, int var6);

    public RetryDecision onUnavailable(Statement var1, ConsistencyLevel var2, int var3, int var4, int var5);

    public RetryDecision onRequestError(Statement var1, ConsistencyLevel var2, DriverException var3, int var4);

    public void init(Cluster var1);

    public void close();

    public static class RetryDecision {
        private static final RetryDecision RETHROW_DECISION = new RetryDecision(Type.RETHROW, null, true);
        private static final RetryDecision IGNORE_DECISION = new RetryDecision(Type.IGNORE, null, true);
        private final Type type;
        private final ConsistencyLevel retryCL;
        private final boolean retryCurrent;

        private RetryDecision(Type type, ConsistencyLevel retryCL, boolean retryCurrent) {
            this.type = type;
            this.retryCL = retryCL;
            this.retryCurrent = retryCurrent;
        }

        public Type getType() {
            return this.type;
        }

        public ConsistencyLevel getRetryConsistencyLevel() {
            return this.retryCL;
        }

        public boolean isRetryCurrent() {
            return this.retryCurrent;
        }

        public static RetryDecision rethrow() {
            return RETHROW_DECISION;
        }

        public static RetryDecision retry(ConsistencyLevel consistency) {
            return new RetryDecision(Type.RETRY, consistency, true);
        }

        public static RetryDecision ignore() {
            return IGNORE_DECISION;
        }

        public static RetryDecision tryNextHost(ConsistencyLevel consistency) {
            return new RetryDecision(Type.RETRY, consistency, false);
        }

        public String toString() {
            switch (this.type) {
                case RETRY: {
                    String retryClDesc = this.retryCL == null ? "same CL" : this.retryCL.toString();
                    String hostDesc = this.retryCurrent ? "same" : "next";
                    return "Retry at " + retryClDesc + " on " + hostDesc + " host.";
                }
                case RETHROW: {
                    return "Rethrow";
                }
                case IGNORE: {
                    return "Ignore";
                }
            }
            throw new AssertionError();
        }

        public static enum Type {
            RETRY,
            RETHROW,
            IGNORE;

        }
    }
}

