/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core.querybuilder;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import shade.com.datastax.spark.connector.driver.core.DataType;
import shade.com.datastax.spark.connector.driver.core.Metadata;
import shade.com.datastax.spark.connector.driver.core.RegularStatement;
import shade.com.datastax.spark.connector.driver.core.TableMetadata;
import shade.com.datastax.spark.connector.driver.core.exceptions.InvalidQueryException;
import shade.com.datastax.spark.connector.driver.core.querybuilder.Assignment;
import shade.com.datastax.spark.connector.driver.core.querybuilder.Batch;
import shade.com.datastax.spark.connector.driver.core.querybuilder.BindMarker;
import shade.com.datastax.spark.connector.driver.core.querybuilder.Clause;
import shade.com.datastax.spark.connector.driver.core.querybuilder.Delete;
import shade.com.datastax.spark.connector.driver.core.querybuilder.Insert;
import shade.com.datastax.spark.connector.driver.core.querybuilder.Ordering;
import shade.com.datastax.spark.connector.driver.core.querybuilder.Select;
import shade.com.datastax.spark.connector.driver.core.querybuilder.Truncate;
import shade.com.datastax.spark.connector.driver.core.querybuilder.Update;
import shade.com.datastax.spark.connector.driver.core.querybuilder.Using;
import shade.com.datastax.spark.connector.driver.core.querybuilder.Utils;

public final class QueryBuilder {
    private QueryBuilder() {
    }

    public static Select.Builder select(String ... columns) {
        return new Select.Builder(Arrays.asList((Object[])columns));
    }

    public static Select.Selection select() {
        return new Select.SelectionOrAlias();
    }

    public static Insert insertInto(String table) {
        return new Insert(null, table);
    }

    public static Insert insertInto(String keyspace, String table) {
        return new Insert(keyspace, table);
    }

    public static Insert insertInto(TableMetadata table) {
        return new Insert(table);
    }

    public static Update update(String table) {
        return new Update(null, table);
    }

    public static Update update(String keyspace, String table) {
        return new Update(keyspace, table);
    }

    public static Update update(TableMetadata table) {
        return new Update(table);
    }

    public static Delete.Builder delete(String ... columns) {
        return new Delete.Builder(columns);
    }

    public static Delete.Selection delete() {
        return new Delete.Selection();
    }

    public static Batch batch(RegularStatement ... statements) {
        return new Batch(statements, true);
    }

    public static Batch unloggedBatch(RegularStatement ... statements) {
        return new Batch(statements, false);
    }

    public static Truncate truncate(String table) {
        return new Truncate(null, table);
    }

    public static Truncate truncate(String keyspace, String table) {
        return new Truncate(keyspace, table);
    }

    public static Truncate truncate(TableMetadata table) {
        return new Truncate(table);
    }

    public static String quote(String columnName2) {
        return Metadata.quote(columnName2);
    }

    public static String token(String columnName2) {
        StringBuilder sb = new StringBuilder();
        sb.append("token(");
        Utils.appendName(columnName2, sb);
        sb.append(')');
        return sb.toString();
    }

    public static String token(String ... columnNames2) {
        StringBuilder sb = new StringBuilder();
        sb.append("token(");
        Utils.joinAndAppendNames(sb, null, ",", Arrays.asList((Object[])columnNames2));
        sb.append(')');
        return sb.toString();
    }

    public static Clause eq(String name, Object value2) {
        return new Clause.SimpleClause(name, "=", value2);
    }

    public static Clause eq(List<String> names, List<?> values) {
        if (names.size() != values.size()) {
            throw new IllegalArgumentException(String.format("The number of names (%d) and values (%d) don't match", names.size(), values.size()));
        }
        return new Clause.CompoundClause(names, "=", values);
    }

    public static Clause like(String name, Object value2) {
        return new Clause.SimpleClause(name, " LIKE ", value2);
    }

    public static Clause in(String name, Object ... values) {
        return new Clause.InClause(name, Arrays.asList(values));
    }

    public static Clause in(String name, List<?> values) {
        return new Clause.InClause(name, values);
    }

    public static Clause in(List<String> names, List<?> values) {
        return new Clause.CompoundInClause(names, values);
    }

    public static Clause contains(String name, Object value2) {
        return new Clause.ContainsClause(name, value2);
    }

    public static Clause containsKey(String name, Object key) {
        return new Clause.ContainsKeyClause(name, key);
    }

    public static Clause lt(String name, Object value2) {
        return new Clause.SimpleClause(name, "<", value2);
    }

    public static Clause lt(List<String> names, List<?> values) {
        if (names.size() != values.size()) {
            throw new IllegalArgumentException(String.format("The number of names (%d) and values (%d) don't match", names.size(), values.size()));
        }
        return new Clause.CompoundClause(names, "<", values);
    }

    public static Clause lte(String name, Object value2) {
        return new Clause.SimpleClause(name, "<=", value2);
    }

    public static Clause lte(List<String> names, List<?> values) {
        if (names.size() != values.size()) {
            throw new IllegalArgumentException(String.format("The number of names (%d) and values (%d) don't match", names.size(), values.size()));
        }
        return new Clause.CompoundClause(names, "<=", values);
    }

    public static Clause gt(String name, Object value2) {
        return new Clause.SimpleClause(name, ">", value2);
    }

    public static Clause gt(List<String> names, List<?> values) {
        if (names.size() != values.size()) {
            throw new IllegalArgumentException(String.format("The number of names (%d) and values (%d) don't match", names.size(), values.size()));
        }
        return new Clause.CompoundClause(names, ">", values);
    }

    public static Clause gte(String name, Object value2) {
        return new Clause.SimpleClause(name, ">=", value2);
    }

    public static Clause gte(List<String> names, List<?> values) {
        if (names.size() != values.size()) {
            throw new IllegalArgumentException(String.format("The number of names (%d) and values (%d) don't match", names.size(), values.size()));
        }
        return new Clause.CompoundClause(names, ">=", values);
    }

    public static Ordering asc(String columnName2) {
        return new Ordering(columnName2, false);
    }

    public static Ordering desc(String columnName2) {
        return new Ordering(columnName2, true);
    }

    public static Using timestamp(long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Invalid timestamp, must be positive");
        }
        return new Using.WithValue("TIMESTAMP", timestamp);
    }

    public static Using timestamp(BindMarker marker) {
        return new Using.WithMarker("TIMESTAMP", marker);
    }

    public static Using ttl(int ttl) {
        if (ttl < 0) {
            throw new IllegalArgumentException("Invalid ttl, must be positive");
        }
        return new Using.WithValue("TTL", ttl);
    }

    public static Using ttl(BindMarker marker) {
        return new Using.WithMarker("TTL", marker);
    }

    public static Assignment set(String name, Object value2) {
        return new Assignment.SetAssignment(name, value2);
    }

    public static Assignment incr(String name) {
        return QueryBuilder.incr(name, 1L);
    }

    public static Assignment incr(String name, long value2) {
        return new Assignment.CounterAssignment(name, value2, true);
    }

    public static Assignment incr(String name, BindMarker value2) {
        return new Assignment.CounterAssignment(name, value2, true);
    }

    public static Assignment decr(String name) {
        return QueryBuilder.decr(name, 1L);
    }

    public static Assignment decr(String name, long value2) {
        return new Assignment.CounterAssignment(name, value2, false);
    }

    public static Assignment decr(String name, BindMarker value2) {
        return new Assignment.CounterAssignment(name, value2, false);
    }

    public static Assignment prepend(String name, Object value2) {
        if (value2 instanceof BindMarker) {
            throw new InvalidQueryException("binding a value in prepend() is not supported, use prependAll() and bind a singleton list");
        }
        return QueryBuilder.prependAll(name, Collections.singletonList(value2));
    }

    public static Assignment prependAll(String name, List<?> list) {
        return new Assignment.ListPrependAssignment(name, list);
    }

    public static Assignment prependAll(String name, BindMarker list) {
        return new Assignment.ListPrependAssignment(name, list);
    }

    public static Assignment append(String name, Object value2) {
        if (value2 instanceof BindMarker) {
            throw new InvalidQueryException("Binding a value in append() is not supported, use appendAll() and bind a singleton list");
        }
        return QueryBuilder.appendAll(name, Collections.singletonList(value2));
    }

    public static Assignment appendAll(String name, List<?> list) {
        return new Assignment.CollectionAssignment(name, list, true, false);
    }

    public static Assignment appendAll(String name, BindMarker list) {
        return new Assignment.CollectionAssignment(name, list, true, false);
    }

    public static Assignment discard(String name, Object value2) {
        if (value2 instanceof BindMarker) {
            throw new InvalidQueryException("Binding a value in discard() is not supported, use discardAll() and bind a singleton list");
        }
        return QueryBuilder.discardAll(name, Collections.singletonList(value2));
    }

    public static Assignment discardAll(String name, List<?> list) {
        return new Assignment.CollectionAssignment(name, list, false);
    }

    public static Assignment discardAll(String name, BindMarker list) {
        return new Assignment.CollectionAssignment(name, list, false);
    }

    public static Assignment setIdx(String name, int idx, Object value2) {
        return new Assignment.ListSetIdxAssignment(name, idx, value2);
    }

    public static Assignment add(String name, Object value2) {
        if (value2 instanceof BindMarker) {
            throw new InvalidQueryException("Binding a value in add() is not supported, use addAll() and bind a singleton list");
        }
        return QueryBuilder.addAll(name, Collections.singleton(value2));
    }

    public static Assignment addAll(String name, Set<?> set) {
        return new Assignment.CollectionAssignment(name, set, true);
    }

    public static Assignment addAll(String name, BindMarker set) {
        return new Assignment.CollectionAssignment(name, set, true);
    }

    public static Assignment remove(String name, Object value2) {
        if (value2 instanceof BindMarker) {
            throw new InvalidQueryException("Binding a value in remove() is not supported, use removeAll() and bind a singleton set");
        }
        return QueryBuilder.removeAll(name, Collections.singleton(value2));
    }

    public static Assignment removeAll(String name, Set<?> set) {
        return new Assignment.CollectionAssignment(name, set, false);
    }

    public static Assignment removeAll(String name, BindMarker set) {
        return new Assignment.CollectionAssignment(name, set, false);
    }

    public static Assignment put(String name, Object key, Object value2) {
        return new Assignment.MapPutAssignment(name, key, value2);
    }

    public static Assignment putAll(String name, Map<?, ?> map) {
        return new Assignment.CollectionAssignment(name, map, true);
    }

    public static Assignment putAll(String name, BindMarker map) {
        return new Assignment.CollectionAssignment(name, map, true);
    }

    public static BindMarker bindMarker() {
        return BindMarker.ANONYMOUS;
    }

    public static BindMarker bindMarker(String name) {
        return new BindMarker(name);
    }

    public static Object raw(String str2) {
        return new Utils.RawString(str2);
    }

    public static Object fcall(String name, Object ... parameters) {
        return new Utils.FCall(name, parameters);
    }

    public static Object cast(Object column, DataType dataType) {
        return new Utils.Cast(column, dataType);
    }

    public static Object now() {
        return new Utils.FCall("now", new Object[0]);
    }

    public static Object uuid() {
        return new Utils.FCall("uuid", new Object[0]);
    }

    public static Object column(String name) {
        return new Utils.CName(name);
    }

    public static Object fromJson(Object json) {
        return QueryBuilder.fcall("fromJson", json);
    }
}

