/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core.querybuilder;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import shade.com.datastax.spark.connector.driver.core.CodecRegistry;
import shade.com.datastax.spark.connector.driver.core.DataType;
import shade.com.datastax.spark.connector.driver.core.ProtocolVersion;
import shade.com.datastax.spark.connector.driver.core.Token;
import shade.com.datastax.spark.connector.driver.core.TypeCodec;
import shade.com.datastax.spark.connector.driver.core.exceptions.InvalidTypeException;
import shade.com.datastax.spark.connector.driver.core.querybuilder.Assignment;
import shade.com.datastax.spark.connector.driver.core.querybuilder.BindMarker;
import shade.com.datastax.spark.connector.driver.core.querybuilder.Clause;
import shade.com.datastax.spark.connector.google.common.base.Preconditions;

abstract class Utils {
    private static final Pattern alphanumeric = Pattern.compile("\\w+");
    private static final Pattern cnamePattern = Pattern.compile("\\w+(?:\\[.+\\])?");

    Utils() {
    }

    static String handleId(String id) {
        if (id == null) {
            return null;
        }
        if (alphanumeric.matcher(id).matches()) {
            return id.toLowerCase();
        }
        if (!id.isEmpty() && id.charAt(0) == '\"' && id.charAt(id.length() - 1) == '\"') {
            return id.substring(1, id.length() - 1).replaceAll("\"\"", "\"");
        }
        return id;
    }

    static StringBuilder joinAndAppend(StringBuilder sb, CodecRegistry codecRegistry, String separator, List<? extends Appendeable> values, List<Object> variables) {
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            values.get(i).appendTo(sb, variables, codecRegistry);
        }
        return sb;
    }

    static StringBuilder joinAndAppendNames(StringBuilder sb, CodecRegistry codecRegistry, String separator, List<?> values) {
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            Utils.appendName(values.get(i), codecRegistry, sb);
        }
        return sb;
    }

    static StringBuilder joinAndAppendValues(StringBuilder sb, CodecRegistry codecRegistry, String separator, List<?> values, List<Object> variables) {
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            Utils.appendValue(values.get(i), codecRegistry, sb, variables);
        }
        return sb;
    }

    static StringBuilder appendValue(Object value2, CodecRegistry codecRegistry, StringBuilder sb, List<Object> variables) {
        if (value2 == null) {
            sb.append("null");
        } else if (value2 instanceof BindMarker) {
            sb.append(value2);
        } else if (value2 instanceof FCall) {
            FCall fcall = (FCall)value2;
            sb.append(fcall.name).append('(');
            for (int i = 0; i < fcall.parameters.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                Utils.appendValue(fcall.parameters[i], codecRegistry, sb, variables);
            }
            sb.append(')');
        } else if (value2 instanceof Cast) {
            Cast cast = (Cast)value2;
            sb.append("CAST(");
            Utils.appendName(cast.column, codecRegistry, sb);
            sb.append(" AS ").append(cast.targetType).append(")");
        } else if (value2 instanceof CName) {
            Utils.appendName(((CName)value2).name, codecRegistry, sb);
        } else if (value2 instanceof RawString) {
            sb.append(value2.toString());
        } else if (value2 instanceof List && !Utils.isSerializable(value2)) {
            Utils.appendList((List)value2, codecRegistry, sb, null);
        } else if (value2 instanceof Set && !Utils.isSerializable(value2)) {
            Utils.appendSet((Set)value2, codecRegistry, sb, null);
        } else if (value2 instanceof Map && !Utils.isSerializable(value2)) {
            Utils.appendMap((Map)value2, codecRegistry, sb, null);
        } else if (variables == null || !Utils.isSerializable(value2)) {
            TypeCodec<Object> codec = codecRegistry.codecFor(value2);
            sb.append(codec.format(value2));
        } else {
            sb.append('?');
            variables.add(value2);
            return sb;
        }
        return sb;
    }

    private static StringBuilder appendList(List<?> l, CodecRegistry codecRegistry, StringBuilder sb, List<Object> variables) {
        sb.append('[');
        for (int i = 0; i < l.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            Utils.appendValue(l.get(i), codecRegistry, sb, variables);
        }
        sb.append(']');
        return sb;
    }

    private static StringBuilder appendSet(Set<?> s, CodecRegistry codecRegistry, StringBuilder sb, List<Object> variables) {
        sb.append('{');
        boolean first = true;
        for (Object elt : s) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            Utils.appendValue(elt, codecRegistry, sb, variables);
        }
        sb.append('}');
        return sb;
    }

    private static StringBuilder appendMap(Map<?, ?> m, CodecRegistry codecRegistry, StringBuilder sb, List<Object> variables) {
        sb.append('{');
        boolean first = true;
        for (Map.Entry<?, ?> entry : m.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            Utils.appendValue(entry.getKey(), codecRegistry, sb, variables);
            sb.append(':');
            Utils.appendValue(entry.getValue(), codecRegistry, sb, variables);
        }
        sb.append('}');
        return sb;
    }

    static boolean containsBindMarker(Object value2) {
        if (value2 instanceof BindMarker) {
            return true;
        }
        if (value2 instanceof FCall) {
            for (Object param : ((FCall)value2).parameters) {
                if (!Utils.containsBindMarker(param)) continue;
                return true;
            }
        }
        if (value2 instanceof Collection) {
            for (Object e : (Collection)value2) {
                if (!Utils.containsBindMarker(e)) continue;
                return true;
            }
        }
        if (value2 instanceof Map) {
            for (Map.Entry entry : ((Map)value2).entrySet()) {
                if (!Utils.containsBindMarker(entry.getKey()) && !Utils.containsBindMarker(entry.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    static boolean containsSpecialValue(Object value2) {
        if (value2 instanceof BindMarker || value2 instanceof FCall || value2 instanceof CName || value2 instanceof RawString) {
            return true;
        }
        if (value2 instanceof Collection) {
            for (Object e : (Collection)value2) {
                if (!Utils.containsSpecialValue(e)) continue;
                return true;
            }
        }
        if (value2 instanceof Map) {
            for (Map.Entry entry : ((Map)value2).entrySet()) {
                if (!Utils.containsSpecialValue(entry.getKey()) && !Utils.containsSpecialValue(entry.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    static boolean isSerializable(Object value2) {
        if (Utils.containsSpecialValue(value2)) {
            return false;
        }
        if (value2 instanceof Number && !(value2 instanceof BigInteger) && !(value2 instanceof BigDecimal)) {
            return false;
        }
        if (value2 instanceof Collection) {
            for (Object e : (Collection)value2) {
                if (Utils.isSerializable(e)) continue;
                return false;
            }
        }
        if (value2 instanceof Map) {
            for (Map.Entry entry : ((Map)value2).entrySet()) {
                if (Utils.isSerializable(entry.getKey()) && Utils.isSerializable(entry.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    static boolean isIdempotent(Object value2) {
        if (value2 == null) {
            return true;
        }
        if (value2 instanceof Assignment) {
            Assignment assignment = (Assignment)value2;
            return assignment.isIdempotent();
        }
        if (value2 instanceof FCall) {
            return false;
        }
        if (value2 instanceof RawString) {
            return false;
        }
        if (value2 instanceof Collection) {
            for (Object elt : (Collection)value2) {
                if (Utils.isIdempotent(elt)) continue;
                return false;
            }
            return true;
        }
        if (value2 instanceof Map) {
            for (Map.Entry entry : ((Map)value2).entrySet()) {
                if (Utils.isIdempotent(entry.getKey()) && Utils.isIdempotent(entry.getValue())) continue;
                return false;
            }
        } else if (value2 instanceof Clause) {
            Object clauseValue = ((Clause)value2).firstValue();
            return Utils.isIdempotent(clauseValue);
        }
        return true;
    }

    static StringBuilder appendName(String name, StringBuilder sb) {
        if (cnamePattern.matcher(name = name.trim()).matches() || name.startsWith("\"") || name.startsWith("token(")) {
            sb.append(name);
        } else {
            sb.append('\"').append(name).append('\"');
        }
        return sb;
    }

    static StringBuilder appendName(Object name, CodecRegistry codecRegistry, StringBuilder sb) {
        if (name instanceof String) {
            Utils.appendName((String)name, sb);
        } else if (name instanceof CName) {
            Utils.appendName(((CName)name).name, codecRegistry, sb);
        } else if (name instanceof FCall) {
            FCall fcall = (FCall)name;
            sb.append(fcall.name).append('(');
            for (int i = 0; i < fcall.parameters.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                Utils.appendValue(fcall.parameters[i], codecRegistry, sb, null);
            }
            sb.append(')');
        } else if (name instanceof Alias) {
            Alias alias = (Alias)name;
            Utils.appendName(alias.column, codecRegistry, sb);
            sb.append(" AS ").append(alias.alias);
        } else if (name instanceof Cast) {
            Cast cast = (Cast)name;
            sb.append("CAST(");
            Utils.appendName(cast.column, codecRegistry, sb);
            sb.append(" AS ").append(cast.targetType).append(")");
        } else if (name instanceof RawString) {
            sb.append(((RawString)name).str);
        } else {
            throw new IllegalArgumentException(String.format("Invalid column %s of type unknown of the query builder", name));
        }
        return sb;
    }

    static ByteBuffer[] convert(Object[] values, ProtocolVersion protocolVersion2, CodecRegistry codecRegistry) {
        ByteBuffer[] serializedValues = new ByteBuffer[values.length];
        for (int i = 0; i < values.length; ++i) {
            Object value2 = values[i];
            if (value2 == null) {
                serializedValues[i] = null;
                continue;
            }
            if (value2 instanceof Token) {
                serializedValues[i] = ((Token)value2).serialize(protocolVersion2);
                continue;
            }
            try {
                TypeCodec<Object> codec = codecRegistry.codecFor(value2);
                serializedValues[i] = codec.serialize(value2, protocolVersion2);
                continue;
            }
            catch (Exception e) {
                throw new InvalidTypeException(String.format("Value %d of type %s does not correspond to any CQL3 type", i, value2.getClass()), e);
            }
        }
        return serializedValues;
    }

    static ByteBuffer compose(ByteBuffer ... buffers) {
        if (buffers.length == 1) {
            return buffers[0];
        }
        int totalLength = 0;
        for (ByteBuffer bb : buffers) {
            totalLength += 2 + bb.remaining() + 1;
        }
        ByteBuffer out = ByteBuffer.allocate(totalLength);
        for (ByteBuffer buffer : buffers) {
            ByteBuffer bb = buffer.duplicate();
            Utils.putShortLength(out, bb.remaining());
            out.put(bb);
            out.put((byte)0);
        }
        out.flip();
        return out;
    }

    static void putShortLength(ByteBuffer bb, int length) {
        bb.put((byte)(length >> 8 & 0xFF));
        bb.put((byte)(length & 0xFF));
    }

    static class Cast {
        private final Object column;
        private final DataType targetType;

        Cast(Object column, DataType targetType) {
            this.column = column;
            this.targetType = targetType;
        }

        public String toString() {
            return String.format("CAST(%s AS %s)", this.column, this.targetType);
        }
    }

    static class Alias {
        private final Object column;
        private final String alias;

        Alias(Object column, String alias) {
            this.column = column;
            this.alias = alias;
        }

        public String toString() {
            return String.format("%s AS %s", this.column, this.alias);
        }
    }

    static class CName {
        private final String name;

        CName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    static class FCall {
        private final String name;
        private final Object[] parameters;

        FCall(String name, Object ... parameters) {
            Preconditions.checkNotNull(name);
            this.name = name;
            this.parameters = parameters;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name).append('(');
            for (int i = 0; i < this.parameters.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.parameters[i]);
            }
            sb.append(')');
            return sb.toString();
        }
    }

    static class RawString {
        private final String str;

        RawString(String str2) {
            this.str = str2;
        }

        public String toString() {
            return this.str;
        }
    }

    static abstract class Appendeable {
        Appendeable() {
        }

        abstract void appendTo(StringBuilder var1, List<Object> var2, CodecRegistry var3);

        abstract boolean containsBindMarker();
    }
}

