/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.core.schemabuilder;

import java.util.LinkedHashMap;
import java.util.Map;
import shade.com.datastax.spark.connector.driver.core.DataType;
import shade.com.datastax.spark.connector.driver.core.schemabuilder.ColumnType;
import shade.com.datastax.spark.connector.driver.core.schemabuilder.NativeColumnType;
import shade.com.datastax.spark.connector.driver.core.schemabuilder.SchemaStatement;
import shade.com.datastax.spark.connector.driver.core.schemabuilder.UDTType;
import shade.com.datastax.spark.connector.google.common.base.Optional;

public abstract class AbstractCreateStatement<T extends AbstractCreateStatement<T>>
extends SchemaStatement {
    protected Optional<String> keyspaceName = Optional.absent();
    protected boolean ifNotExists;
    protected Map<String, ColumnType> simpleColumns = new LinkedHashMap<String, ColumnType>();
    private T self = this;

    public T ifNotExists() {
        this.ifNotExists = true;
        return this.self;
    }

    public T addColumn(String columnName2, DataType dataType) {
        AbstractCreateStatement.validateNotEmpty(columnName2, "Column name");
        AbstractCreateStatement.validateNotNull(dataType, "Column type");
        AbstractCreateStatement.validateNotKeyWord(columnName2, String.format("The column name '%s' is not allowed because it is a reserved keyword", columnName2));
        this.simpleColumns.put(columnName2, new NativeColumnType(dataType));
        return this.self;
    }

    public T addUDTColumn(String columnName2, UDTType udtType) {
        AbstractCreateStatement.validateNotEmpty(columnName2, "Column name");
        AbstractCreateStatement.validateNotNull(udtType, "Column type");
        AbstractCreateStatement.validateNotKeyWord(columnName2, String.format("The column name '%s' is not allowed because it is a reserved keyword", columnName2));
        this.simpleColumns.put(columnName2, udtType);
        return this.self;
    }

    public T addUDTListColumn(String columnName2, UDTType udtType) {
        AbstractCreateStatement.validateNotEmpty(columnName2, "Column name");
        AbstractCreateStatement.validateNotNull(udtType, "Column element type");
        AbstractCreateStatement.validateNotKeyWord(columnName2, String.format("The column name '%s' is not allowed because it is a reserved keyword", columnName2));
        this.simpleColumns.put(columnName2, UDTType.list(udtType));
        return this.self;
    }

    public T addUDTSetColumn(String columnName2, UDTType udtType) {
        AbstractCreateStatement.validateNotEmpty(columnName2, "Column name");
        AbstractCreateStatement.validateNotNull(udtType, "Column element type");
        AbstractCreateStatement.validateNotKeyWord(columnName2, String.format("The column name '%s' is not allowed because it is a reserved keyword", columnName2));
        this.simpleColumns.put(columnName2, UDTType.set(udtType));
        return this.self;
    }

    public T addUDTMapColumn(String columnName2, DataType keyType, UDTType valueUdtType) {
        AbstractCreateStatement.validateNotEmpty(columnName2, "Column name");
        AbstractCreateStatement.validateNotNull(keyType, "Map key type");
        AbstractCreateStatement.validateNotNull(valueUdtType, "Map value UDT type");
        AbstractCreateStatement.validateNotKeyWord(columnName2, String.format("The column name '%s' is not allowed because it is a reserved keyword", columnName2));
        this.simpleColumns.put(columnName2, UDTType.mapWithUDTValue(keyType, valueUdtType));
        return this.self;
    }

    public T addUDTMapColumn(String columnName2, UDTType udtKeyType, DataType valueType) {
        AbstractCreateStatement.validateNotEmpty(columnName2, "Column name");
        AbstractCreateStatement.validateNotNull(udtKeyType, "Map key UDT type");
        AbstractCreateStatement.validateNotNull(valueType, "Map value type");
        AbstractCreateStatement.validateNotKeyWord(columnName2, String.format("The column name '%s' is not allowed because it is a reserved keyword", columnName2));
        this.simpleColumns.put(columnName2, UDTType.mapWithUDTKey(udtKeyType, valueType));
        return this.self;
    }

    public T addUDTMapColumn(String columnName2, UDTType udtKeyType, UDTType udtValueType) {
        AbstractCreateStatement.validateNotEmpty(columnName2, "Column name");
        AbstractCreateStatement.validateNotNull(udtKeyType, "Map key UDT type");
        AbstractCreateStatement.validateNotNull(udtValueType, "Map value UDT type");
        AbstractCreateStatement.validateNotKeyWord(columnName2, String.format("The column name '%s' is not allowed because it is a reserved keyword", columnName2));
        this.simpleColumns.put(columnName2, UDTType.mapWithUDTKeyAndValue(udtKeyType, udtValueType));
        return this.self;
    }

    protected String buildColumnType(Map.Entry<String, ColumnType> entry) {
        ColumnType columnType = entry.getValue();
        return entry.getKey() + " " + columnType.asCQLString();
    }
}

