/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.mapping;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import shade.com.datastax.spark.connector.driver.mapping.AccessorMapper;
import shade.com.datastax.spark.connector.driver.mapping.MethodMapper;

class AccessorInvocationHandler<T>
implements InvocationHandler {
    private static final Object[] NO_ARGS = new Object[0];
    private static final Method TO_STRING;
    private static final Method EQUALS;
    private static final Method HASH_CODE;
    private final AccessorMapper<T> mapper;
    private final Map<Method, MethodMapper> methodMap = new HashMap<Method, MethodMapper>();

    AccessorInvocationHandler(AccessorMapper<T> mapper) {
        this.mapper = mapper;
        for (MethodMapper method2 : mapper.methods) {
            this.methodMap.put(method2.method, method2);
        }
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        if (m.equals(TO_STRING)) {
            return this.mapper.daoClass.getSimpleName() + " implementation generated by the Cassandra driver mapper";
        }
        if (m.equals(EQUALS)) {
            return proxy == args[0];
        }
        if (m.equals(HASH_CODE)) {
            return System.identityHashCode(proxy);
        }
        MethodMapper method2 = this.methodMap.get(m);
        if (method2 == null) {
            throw new UnsupportedOperationException();
        }
        return method2.invoke(args == null ? NO_ARGS : args);
    }

    static {
        try {
            TO_STRING = Object.class.getMethod("toString", new Class[0]);
            EQUALS = Object.class.getMethod("equals", Object.class);
            HASH_CODE = Object.class.getMethod("hashCode", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }
}

