/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.mapping;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import shade.com.datastax.spark.connector.driver.core.AbstractTableMetadata;
import shade.com.datastax.spark.connector.driver.core.ConsistencyLevel;
import shade.com.datastax.spark.connector.driver.core.KeyspaceMetadata;
import shade.com.datastax.spark.connector.driver.core.Metadata;
import shade.com.datastax.spark.connector.driver.core.TypeCodec;
import shade.com.datastax.spark.connector.driver.core.UserType;
import shade.com.datastax.spark.connector.driver.mapping.AccessorMapper;
import shade.com.datastax.spark.connector.driver.mapping.AnnotationChecks;
import shade.com.datastax.spark.connector.driver.mapping.EntityMapper;
import shade.com.datastax.spark.connector.driver.mapping.MappedUDTCodec;
import shade.com.datastax.spark.connector.driver.mapping.MappingManager;
import shade.com.datastax.spark.connector.driver.mapping.MethodMapper;
import shade.com.datastax.spark.connector.driver.mapping.PropertyMapper;
import shade.com.datastax.spark.connector.driver.mapping.ReflectionUtils;
import shade.com.datastax.spark.connector.driver.mapping.TypeMappings;
import shade.com.datastax.spark.connector.driver.mapping.annotations.Accessor;
import shade.com.datastax.spark.connector.driver.mapping.annotations.ClusteringColumn;
import shade.com.datastax.spark.connector.driver.mapping.annotations.Column;
import shade.com.datastax.spark.connector.driver.mapping.annotations.Computed;
import shade.com.datastax.spark.connector.driver.mapping.annotations.Defaults;
import shade.com.datastax.spark.connector.driver.mapping.annotations.Field;
import shade.com.datastax.spark.connector.driver.mapping.annotations.Frozen;
import shade.com.datastax.spark.connector.driver.mapping.annotations.FrozenKey;
import shade.com.datastax.spark.connector.driver.mapping.annotations.FrozenValue;
import shade.com.datastax.spark.connector.driver.mapping.annotations.Param;
import shade.com.datastax.spark.connector.driver.mapping.annotations.PartitionKey;
import shade.com.datastax.spark.connector.driver.mapping.annotations.Query;
import shade.com.datastax.spark.connector.driver.mapping.annotations.QueryParameters;
import shade.com.datastax.spark.connector.driver.mapping.annotations.Table;
import shade.com.datastax.spark.connector.driver.mapping.annotations.Transient;
import shade.com.datastax.spark.connector.driver.mapping.annotations.UDT;
import shade.com.datastax.spark.connector.google.common.base.Strings;
import shade.com.datastax.spark.connector.google.common.collect.ImmutableSet;
import shade.com.datastax.spark.connector.google.common.reflect.TypeToken;

class AnnotationParser {
    private static final Set<Class<? extends Annotation>> VALID_COLUMN_ANNOTATIONS = ImmutableSet.of(Column.class, Computed.class, ClusteringColumn.class, Frozen.class, FrozenKey.class, FrozenValue.class, new Class[]{PartitionKey.class, Transient.class});
    private static final Set<Class<? extends Annotation>> VALID_FIELD_ANNOTATIONS = ImmutableSet.of(Field.class, Frozen.class, FrozenKey.class, FrozenValue.class, Transient.class);
    private static final Comparator<PropertyMapper> POSITION_COMPARATOR = new Comparator<PropertyMapper>(){

        @Override
        public int compare(PropertyMapper o1, PropertyMapper o2) {
            return o1.position - o2.position;
        }
    };

    private AnnotationParser() {
    }

    static <T> EntityMapper<T> parseEntity(Class<T> entityClass, MappingManager mappingManager) {
        KeyspaceMetadata keyspaceMetadata;
        ConsistencyLevel readConsistency;
        Table table = AnnotationChecks.getTypeAnnotation(Table.class, entityClass);
        String ksName = table.caseSensitiveKeyspace() ? Metadata.quote(table.keyspace()) : table.keyspace().toLowerCase();
        String tableName = table.caseSensitiveTable() ? Metadata.quote(table.name()) : table.name().toLowerCase();
        ConsistencyLevel writeConsistency = table.writeConsistency().isEmpty() ? null : ConsistencyLevel.valueOf(table.writeConsistency().toUpperCase());
        ConsistencyLevel consistencyLevel = readConsistency = table.readConsistency().isEmpty() ? null : ConsistencyLevel.valueOf(table.readConsistency().toUpperCase());
        if (Strings.isNullOrEmpty(table.keyspace())) {
            String loggedKeyspace = mappingManager.getSession().getLoggedKeyspace();
            if (Strings.isNullOrEmpty(loggedKeyspace)) {
                throw new IllegalArgumentException(String.format("Error creating mapper for %s, the @Table annotation declares no default keyspace, and the session is not currently logged to any keyspace", entityClass));
            }
            ksName = Metadata.quote(loggedKeyspace);
        }
        if ((keyspaceMetadata = mappingManager.getSession().getCluster().getMetadata().getKeyspace(ksName)) == null) {
            throw new IllegalArgumentException(String.format("Keyspace %s does not exist", ksName));
        }
        AbstractTableMetadata tableMetadata = keyspaceMetadata.getTable(tableName);
        if (tableMetadata == null && (tableMetadata = keyspaceMetadata.getMaterializedView(tableName)) == null) {
            throw new IllegalArgumentException(String.format("Table or materialized view %s does not exist in keyspace %s", tableName, ksName));
        }
        EntityMapper<T> mapper = new EntityMapper<T>(entityClass, ksName, tableName, writeConsistency, readConsistency);
        ArrayList<PropertyMapper> pks = new ArrayList<PropertyMapper>();
        ArrayList<PropertyMapper> ccs = new ArrayList<PropertyMapper>();
        ArrayList<PropertyMapper> rgs = new ArrayList<PropertyMapper>();
        Map<String, Object[]> fieldsAndProperties = ReflectionUtils.scanFieldsAndProperties(entityClass);
        AtomicInteger columnCounter = mappingManager.isCassandraV1 ? null : new AtomicInteger(0);
        for (Map.Entry<String, Object[]> entry : fieldsAndProperties.entrySet()) {
            String propertyName2 = entry.getKey();
            java.lang.reflect.Field field = (java.lang.reflect.Field)entry.getValue()[0];
            PropertyDescriptor property = (PropertyDescriptor)entry.getValue()[1];
            String alias = columnCounter != null ? "col" + columnCounter.incrementAndGet() : null;
            PropertyMapper propertyMapper = new PropertyMapper(entityClass, propertyName2, alias, field, property);
            if (mappingManager.isCassandraV1 && propertyMapper.isComputed()) {
                throw new UnsupportedOperationException("Computed properties are not supported with native protocol v1");
            }
            AnnotationChecks.validateAnnotations(propertyMapper, VALID_COLUMN_ANNOTATIONS);
            if (propertyMapper.isTransient()) continue;
            if (!propertyMapper.isComputed() && tableMetadata.getColumn(propertyMapper.columnName) == null) {
                throw new IllegalArgumentException(String.format("Column %s does not exist in table %s.%s", propertyMapper.columnName, ksName, tableName));
            }
            if (propertyMapper.isPartitionKey()) {
                pks.add(propertyMapper);
            } else if (propertyMapper.isClusteringColumn()) {
                ccs.add(propertyMapper);
            } else {
                rgs.add(propertyMapper);
            }
            for (Class<?> udt : TypeMappings.findUDTs(propertyMapper.javaType.getType())) {
                mappingManager.getUDTCodec(udt);
            }
        }
        Collections.sort(pks, POSITION_COMPARATOR);
        Collections.sort(ccs, POSITION_COMPARATOR);
        AnnotationChecks.validateOrder(pks, "@PartitionKey");
        AnnotationChecks.validateOrder(ccs, "@ClusteringColumn");
        mapper.addColumns(pks, ccs, rgs);
        return mapper;
    }

    static <T> MappedUDTCodec<T> parseUDT(Class<T> udtClass, MappingManager mappingManager) {
        KeyspaceMetadata keyspaceMetadata;
        String udtName;
        UDT udt = AnnotationChecks.getTypeAnnotation(UDT.class, udtClass);
        String ksName = udt.caseSensitiveKeyspace() ? Metadata.quote(udt.keyspace()) : udt.keyspace().toLowerCase();
        String string = udtName = udt.caseSensitiveType() ? Metadata.quote(udt.name()) : udt.name().toLowerCase();
        if (Strings.isNullOrEmpty(udt.keyspace())) {
            String loggedKeyspace = mappingManager.getSession().getLoggedKeyspace();
            if (Strings.isNullOrEmpty(loggedKeyspace)) {
                throw new IllegalArgumentException(String.format("Error creating UDT codec for %s, the @UDT annotation declares no default keyspace, and the session is not currently logged to any keyspace", udtClass));
            }
            ksName = Metadata.quote(loggedKeyspace);
        }
        if ((keyspaceMetadata = mappingManager.getSession().getCluster().getMetadata().getKeyspace(ksName)) == null) {
            throw new IllegalArgumentException(String.format("Keyspace %s does not exist", ksName));
        }
        UserType userType = keyspaceMetadata.getUserType(udtName);
        if (userType == null) {
            throw new IllegalArgumentException(String.format("User type %s does not exist in keyspace %s", udtName, ksName));
        }
        HashMap<String, PropertyMapper> propertyMappers = new HashMap<String, PropertyMapper>();
        Map<String, Object[]> fieldsAndProperties = ReflectionUtils.scanFieldsAndProperties(udtClass);
        for (Map.Entry<String, Object[]> entry : fieldsAndProperties.entrySet()) {
            String propertyName2 = entry.getKey();
            java.lang.reflect.Field field = (java.lang.reflect.Field)entry.getValue()[0];
            PropertyDescriptor property = (PropertyDescriptor)entry.getValue()[1];
            PropertyMapper propertyMapper = new PropertyMapper(udtClass, propertyName2, null, field, property);
            AnnotationChecks.validateAnnotations(propertyMapper, VALID_FIELD_ANNOTATIONS);
            if (propertyMapper.isTransient()) continue;
            if (!userType.contains(propertyMapper.columnName)) {
                throw new IllegalArgumentException(String.format("Field %s does not exist in type %s.%s", propertyMapper.columnName, ksName, userType.getTypeName()));
            }
            for (Class<?> fieldUdt : TypeMappings.findUDTs(propertyMapper.javaType.getType())) {
                mappingManager.getUDTCodec(fieldUdt);
            }
            propertyMappers.put(propertyMapper.columnName, propertyMapper);
        }
        return new MappedUDTCodec<T>(userType, udtClass, propertyMappers, mappingManager);
    }

    static <T> AccessorMapper<T> parseAccessor(Class<T> accClass, MappingManager mappingManager) {
        if (!accClass.isInterface()) {
            throw new IllegalArgumentException("@Accessor annotation is only allowed on interfaces, got " + accClass);
        }
        AnnotationChecks.getTypeAnnotation(Accessor.class, accClass);
        ArrayList<MethodMapper> methods2 = new ArrayList<MethodMapper>();
        for (Method m : accClass.getDeclaredMethods()) {
            Query query = m.getAnnotation(Query.class);
            if (query == null) continue;
            String queryString = query.value();
            Annotation[][] paramAnnotations = m.getParameterAnnotations();
            Type[] paramTypes = m.getGenericParameterTypes();
            MethodMapper.ParamMapper[] paramMappers = new MethodMapper.ParamMapper[paramAnnotations.length];
            Boolean allParamsNamed = null;
            for (int i = 0; i < paramMappers.length; ++i) {
                boolean thisParamNamed;
                String paramName = null;
                Class<? extends TypeCodec<?>> codecClass = null;
                for (Annotation a : paramAnnotations[i]) {
                    if (!a.annotationType().equals(Param.class)) continue;
                    Param param = (Param)a;
                    paramName = param.value();
                    if (paramName.isEmpty()) {
                        paramName = null;
                    }
                    if (!Defaults.NoCodec.class.equals(codecClass = param.codec())) break;
                    codecClass = null;
                    break;
                }
                boolean bl = thisParamNamed = paramName != null;
                if (allParamsNamed == null) {
                    allParamsNamed = thisParamNamed;
                } else if (allParamsNamed != thisParamNamed) {
                    throw new IllegalArgumentException(String.format("For method '%s', either all or none of the parameters must be named", m.getName()));
                }
                paramMappers[i] = AnnotationParser.newParamMapper(accClass.getName(), m.getName(), i, paramName, codecClass, paramTypes[i], mappingManager);
            }
            ConsistencyLevel cl = null;
            int fetchSize = -1;
            boolean tracing = false;
            Boolean idempotent = null;
            QueryParameters options = m.getAnnotation(QueryParameters.class);
            if (options != null) {
                cl = options.consistency().isEmpty() ? null : ConsistencyLevel.valueOf(options.consistency().toUpperCase());
                fetchSize = options.fetchSize();
                tracing = options.tracing();
                if (options.idempotent().length > 1) {
                    throw new IllegalArgumentException("idemtpotence() attribute can only accept one value");
                }
                idempotent = options.idempotent().length == 0 ? null : Boolean.valueOf(options.idempotent()[0]);
            }
            methods2.add(new MethodMapper(m, queryString, paramMappers, cl, fetchSize, tracing, idempotent));
        }
        return new AccessorMapper<T>(accClass, methods2);
    }

    private static MethodMapper.ParamMapper newParamMapper(String className, String methodName, int idx, String paramName, Class<? extends TypeCodec<?>> codecClass, Type paramType, MappingManager mappingManager) {
        if (paramType instanceof Class) {
            Class paramClass = (Class)paramType;
            if (TypeMappings.isMappedUDT(paramClass)) {
                mappingManager.getUDTCodec(paramClass);
            }
            return new MethodMapper.ParamMapper(paramName, idx, TypeToken.of(paramType), codecClass);
        }
        if (paramType instanceof ParameterizedType) {
            for (Class<?> udt : TypeMappings.findUDTs(paramType)) {
                mappingManager.getUDTCodec(udt);
            }
            return new MethodMapper.ParamMapper(paramName, idx, TypeToken.of(paramType), codecClass);
        }
        throw new IllegalArgumentException(String.format("Cannot map class %s for parameter %s of %s.%s", paramType, paramName, className, methodName));
    }
}

