/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.mapping;

import java.nio.ByteBuffer;
import java.util.Map;
import shade.com.datastax.spark.connector.driver.core.CodecRegistry;
import shade.com.datastax.spark.connector.driver.core.ProtocolVersion;
import shade.com.datastax.spark.connector.driver.core.TypeCodec;
import shade.com.datastax.spark.connector.driver.core.UserType;
import shade.com.datastax.spark.connector.driver.mapping.MappingManager;
import shade.com.datastax.spark.connector.driver.mapping.PropertyMapper;
import shade.com.datastax.spark.connector.driver.mapping.ReflectionUtils;

class MappedUDTCodec<T>
extends TypeCodec.AbstractUDTCodec<T> {
    private final UserType cqlUserType;
    private final Class<T> udtClass;
    private final Map<String, PropertyMapper> columnMappers;
    private final CodecRegistry codecRegistry;

    MappedUDTCodec(UserType cqlUserType, Class<T> udtClass, Map<String, PropertyMapper> columnMappers, MappingManager mappingManager) {
        super(cqlUserType, udtClass);
        this.cqlUserType = cqlUserType;
        this.udtClass = udtClass;
        this.columnMappers = columnMappers;
        this.codecRegistry = mappingManager.getSession().getCluster().getConfiguration().getCodecRegistry();
    }

    @Override
    protected T newInstance() {
        return ReflectionUtils.newInstance(this.udtClass);
    }

    Class<T> getUdtClass() {
        return this.udtClass;
    }

    @Override
    protected ByteBuffer serializeField(T source, String fieldName, ProtocolVersion protocolVersion2) {
        PropertyMapper propertyMapper = this.columnMappers.get(fieldName);
        if (propertyMapper == null) {
            return null;
        }
        Object value2 = propertyMapper.getValue(source);
        TypeCodec<Object> codec = propertyMapper.customCodec;
        if (codec == null) {
            codec = this.codecRegistry.codecFor(this.cqlUserType.getFieldType(propertyMapper.columnName), propertyMapper.javaType);
        }
        return codec.serialize(value2, protocolVersion2);
    }

    @Override
    protected T deserializeAndSetField(ByteBuffer input, T target, String fieldName, ProtocolVersion protocolVersion2) {
        PropertyMapper propertyMapper = this.columnMappers.get(fieldName);
        if (propertyMapper != null) {
            TypeCodec<Object> codec = propertyMapper.customCodec;
            if (codec == null) {
                codec = this.codecRegistry.codecFor(this.cqlUserType.getFieldType(propertyMapper.columnName), propertyMapper.javaType);
            }
            propertyMapper.setValue(target, codec.deserialize(input, protocolVersion2));
        }
        return target;
    }

    @Override
    protected String formatField(T source, String fieldName) {
        PropertyMapper propertyMapper = this.columnMappers.get(fieldName);
        if (propertyMapper == null) {
            return null;
        }
        Object value2 = propertyMapper.getValue(source);
        TypeCodec<Object> codec = propertyMapper.customCodec;
        if (codec == null) {
            codec = this.codecRegistry.codecFor(this.cqlUserType.getFieldType(propertyMapper.columnName), propertyMapper.javaType);
        }
        return codec.format(value2);
    }

    @Override
    protected T parseAndSetField(String input, T target, String fieldName) {
        PropertyMapper propertyMapper = this.columnMappers.get(fieldName);
        if (propertyMapper != null) {
            TypeCodec<Object> codec = propertyMapper.customCodec;
            if (codec == null) {
                codec = this.codecRegistry.codecFor(this.cqlUserType.getFieldType(propertyMapper.columnName), propertyMapper.javaType);
            }
            propertyMapper.setValue(target, codec.parse(input));
        }
        return target;
    }
}

