/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shade.com.datastax.spark.connector.driver.core.BoundStatement;
import shade.com.datastax.spark.connector.driver.core.ConsistencyLevel;
import shade.com.datastax.spark.connector.driver.core.KeyspaceMetadata;
import shade.com.datastax.spark.connector.driver.core.PreparedStatement;
import shade.com.datastax.spark.connector.driver.core.ResultSet;
import shade.com.datastax.spark.connector.driver.core.ResultSetFuture;
import shade.com.datastax.spark.connector.driver.core.Session;
import shade.com.datastax.spark.connector.driver.core.SimpleStatement;
import shade.com.datastax.spark.connector.driver.core.Statement;
import shade.com.datastax.spark.connector.driver.core.TableMetadata;
import shade.com.datastax.spark.connector.driver.core.TypeCodec;
import shade.com.datastax.spark.connector.driver.core.querybuilder.Delete;
import shade.com.datastax.spark.connector.driver.core.querybuilder.Insert;
import shade.com.datastax.spark.connector.driver.core.querybuilder.QueryBuilder;
import shade.com.datastax.spark.connector.driver.mapping.DriverThrowables;
import shade.com.datastax.spark.connector.driver.mapping.EntityMapper;
import shade.com.datastax.spark.connector.driver.mapping.MapperBoundStatement;
import shade.com.datastax.spark.connector.driver.mapping.MappingManager;
import shade.com.datastax.spark.connector.driver.mapping.PropertyMapper;
import shade.com.datastax.spark.connector.driver.mapping.QueryType;
import shade.com.datastax.spark.connector.driver.mapping.Result;
import shade.com.datastax.spark.connector.google.common.base.Function;
import shade.com.datastax.spark.connector.google.common.base.Functions;
import shade.com.datastax.spark.connector.google.common.base.Objects;
import shade.com.datastax.spark.connector.google.common.base.Preconditions;
import shade.com.datastax.spark.connector.google.common.reflect.TypeToken;
import shade.com.datastax.spark.connector.google.common.util.concurrent.AsyncFunction;
import shade.com.datastax.spark.connector.google.common.util.concurrent.FutureCallback;
import shade.com.datastax.spark.connector.google.common.util.concurrent.Futures;
import shade.com.datastax.spark.connector.google.common.util.concurrent.ListenableFuture;
import shade.com.datastax.spark.connector.google.common.util.concurrent.SettableFuture;
import shade.com.datastax.spark.connector.google.common.util.concurrent.Uninterruptibles;

public class Mapper<T> {
    private static final Logger logger = LoggerFactory.getLogger(Mapper.class);
    private static final Function<Object, Void> TO_NULL = Functions.constant(null);
    private final MappingManager manager;
    private final Class<T> klass;
    private final EntityMapper<T> mapper;
    private final TableMetadata tableMetadata;
    private final ConcurrentMap<MapperQueryKey, ListenableFuture<PreparedStatement>> preparedQueries = new ConcurrentHashMap<MapperQueryKey, ListenableFuture<PreparedStatement>>();
    private volatile EnumMap<Option.Type, Option> defaultSaveOptions;
    private volatile EnumMap<Option.Type, Option> defaultGetOptions;
    private volatile EnumMap<Option.Type, Option> defaultDeleteOptions;
    private static final EnumMap<Option.Type, Option> NO_OPTIONS = new EnumMap(Option.Type.class);
    private final Function<ResultSet, T> mapOneFunction;
    final Function<ResultSet, T> mapOneFunctionWithoutAliases;
    final Function<ResultSet, Result<T>> mapAllFunctionWithoutAliases;

    Mapper(MappingManager manager, Class<T> klass, EntityMapper<T> mapper) {
        this.manager = manager;
        this.klass = klass;
        this.mapper = mapper;
        KeyspaceMetadata keyspace = this.session().getCluster().getMetadata().getKeyspace(mapper.keyspace);
        this.tableMetadata = keyspace == null ? null : keyspace.getTable(mapper.table);
        this.mapOneFunction = new Function<ResultSet, T>(){

            @Override
            public T apply(ResultSet rs) {
                return Mapper.this.map(rs).one();
            }
        };
        this.mapOneFunctionWithoutAliases = new Function<ResultSet, T>(){

            @Override
            public T apply(ResultSet rs) {
                return Mapper.this.map(rs).one();
            }
        };
        this.mapAllFunctionWithoutAliases = new Function<ResultSet, Result<T>>(){

            @Override
            public Result<T> apply(ResultSet rs) {
                return Mapper.this.map(rs);
            }
        };
        this.defaultSaveOptions = NO_OPTIONS;
        this.defaultGetOptions = NO_OPTIONS;
        this.defaultDeleteOptions = NO_OPTIONS;
    }

    Session session() {
        return this.manager.getSession();
    }

    ListenableFuture<PreparedStatement> getPreparedQueryAsync(QueryType type, Set<PropertyMapper> columns, EnumMap<Option.Type, Option> options) {
        final MapperQueryKey pqk = new MapperQueryKey(type, columns, options);
        ListenableFuture existingFuture = (ListenableFuture)this.preparedQueries.get(pqk);
        if (existingFuture == null) {
            final SettableFuture<PreparedStatement> future = SettableFuture.create();
            ListenableFuture old = this.preparedQueries.putIfAbsent(pqk, future);
            if (old != null) {
                return old;
            }
            final String queryString = type.makePreparedQueryString(this.tableMetadata, this.mapper, this.manager, columns, options.values());
            logger.debug("Preparing query {}", (Object)queryString);
            SimpleStatement s = new SimpleStatement(queryString);
            s.setIdempotent(true);
            Futures.addCallback(this.session().prepareAsync(s), new FutureCallback<PreparedStatement>(){

                @Override
                public void onSuccess(PreparedStatement stmt) {
                    future.set(stmt);
                }

                @Override
                public void onFailure(Throwable t) {
                    future.setException(t);
                    Mapper.this.preparedQueries.remove(pqk, future);
                    logger.error("Query preparation failed: " + queryString, t);
                }
            });
            return future;
        }
        return existingFuture;
    }

    ListenableFuture<PreparedStatement> getPreparedQueryAsync(QueryType type, EnumMap<Option.Type, Option> options) {
        return this.getPreparedQueryAsync(type, Collections.<PropertyMapper>emptySet(), options);
    }

    Class<T> getMappedClass() {
        return this.klass;
    }

    public TableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public MappingManager getManager() {
        return this.manager;
    }

    public Statement saveQuery(T entity) {
        try {
            return Uninterruptibles.getUninterruptibly(this.saveQueryAsync(entity, this.defaultSaveOptions));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    public Statement saveQuery(T entity, Option ... options) {
        try {
            return Uninterruptibles.getUninterruptibly(this.saveQueryAsync(entity, Mapper.toMapWithDefaults(options, this.defaultSaveOptions)));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    private ListenableFuture<BoundStatement> saveQueryAsync(T entity, final EnumMap<Option.Type, Option> options) {
        final HashMap<PropertyMapper, Object> values = new HashMap<PropertyMapper, Object>();
        boolean saveNullFields = Mapper.shouldSaveNullFields(options);
        for (PropertyMapper col : this.mapper.allColumns) {
            Object value2 = col.getValue(entity);
            if (col.isComputed() || !saveNullFields && value2 == null) continue;
            values.put(col, value2);
        }
        return Futures.transform(this.getPreparedQueryAsync(QueryType.SAVE, values.keySet(), options), new Function<PreparedStatement, BoundStatement>(){

            @Override
            public BoundStatement apply(PreparedStatement input) {
                BoundStatement bs = input.bind();
                int i = 0;
                for (Map.Entry entry : values.entrySet()) {
                    PropertyMapper mapper = (PropertyMapper)entry.getKey();
                    Object value2 = entry.getValue();
                    Mapper.setObject(bs, i++, value2, mapper);
                }
                if (((Mapper)Mapper.this).mapper.writeConsistency != null) {
                    bs.setConsistencyLevel(((Mapper)Mapper.this).mapper.writeConsistency);
                }
                for (Option opt : options.values()) {
                    opt.checkValidFor(QueryType.SAVE, Mapper.this.manager);
                    opt.addToPreparedStatement(bs, i++);
                }
                return bs;
            }
        });
    }

    private static boolean shouldSaveNullFields(EnumMap<Option.Type, Option> options) {
        Option.SaveNullFields option = (Option.SaveNullFields)options.get((Object)Option.Type.SAVE_NULL_FIELDS);
        return option == null || option.saveNullFields;
    }

    private static void setObject(BoundStatement bs, int i, Object value2, PropertyMapper mapper) {
        TypeCodec<Object> customCodec = mapper.customCodec;
        if (customCodec != null) {
            bs.set(i, value2, (TypeCodec)customCodec);
        } else {
            bs.set(i, value2, (TypeToken)mapper.javaType);
        }
    }

    public void save(T entity) {
        try {
            Uninterruptibles.getUninterruptibly(this.saveAsync(entity));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    public void save(T entity, Option ... options) {
        try {
            Uninterruptibles.getUninterruptibly(this.saveAsync(entity, options));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    public ListenableFuture<Void> saveAsync(T entity) {
        return this.submitVoidQueryAsync(this.saveQueryAsync(entity, this.defaultSaveOptions));
    }

    public ListenableFuture<Void> saveAsync(T entity, Option ... options) {
        return this.submitVoidQueryAsync(this.saveQueryAsync(entity, Mapper.toMapWithDefaults(options, this.defaultSaveOptions)));
    }

    private ListenableFuture<Void> submitVoidQueryAsync(ListenableFuture<BoundStatement> bsFuture) {
        ListenableFuture<ResultSet> rsFuture = Futures.transform(bsFuture, new AsyncFunction<BoundStatement, ResultSet>(){

            @Override
            public ListenableFuture<ResultSet> apply(BoundStatement bs) throws Exception {
                return Mapper.this.session().executeAsync(bs);
            }
        });
        return Futures.transform(rsFuture, TO_NULL);
    }

    public Statement getQuery(Object ... objects) {
        try {
            return Uninterruptibles.getUninterruptibly(this.getQueryAsync(objects));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    private ListenableFuture<BoundStatement> getQueryAsync(Object ... objects) {
        ArrayList<Object> pks = new ArrayList<Object>();
        EnumMap<Option.Type, Option> options = new EnumMap<Option.Type, Option>(this.defaultGetOptions);
        for (Object o : objects) {
            if (o instanceof Option) {
                Option option = (Option)o;
                options.put(option.type, option);
                continue;
            }
            pks.add(o);
        }
        return this.getQueryAsync(pks, options);
    }

    private ListenableFuture<BoundStatement> getQueryAsync(final List<Object> primaryKeys, final EnumMap<Option.Type, Option> options) {
        if (primaryKeys.size() != this.mapper.primaryKeySize()) {
            throw new IllegalArgumentException(String.format("Invalid number of PRIMARY KEY columns provided, %d expected but got %d", this.mapper.primaryKeySize(), primaryKeys.size()));
        }
        return Futures.transform(this.getPreparedQueryAsync(QueryType.GET, options), new Function<PreparedStatement, BoundStatement>(){

            @Override
            public BoundStatement apply(PreparedStatement input) {
                MapperBoundStatement bs = new MapperBoundStatement(input);
                int i = 0;
                for (Object value2 : primaryKeys) {
                    PropertyMapper column = Mapper.this.mapper.getPrimaryKeyColumn(i);
                    if (value2 == null) {
                        throw new IllegalArgumentException(String.format("Invalid null value for PRIMARY KEY column %s (argument %d)", column.columnName, i));
                    }
                    Mapper.setObject(bs, i++, value2, column);
                }
                if (((Mapper)Mapper.this).mapper.readConsistency != null) {
                    bs.setConsistencyLevel(((Mapper)Mapper.this).mapper.readConsistency);
                }
                for (Option opt : options.values()) {
                    opt.checkValidFor(QueryType.GET, Mapper.this.manager);
                    opt.addToPreparedStatement(bs, i);
                    if (!opt.isIncludedInQuery()) continue;
                    ++i;
                }
                return bs;
            }
        });
    }

    public T get(Object ... objects) {
        try {
            return Uninterruptibles.getUninterruptibly(this.getAsync(objects));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    public ListenableFuture<T> getAsync(Object ... objects) {
        ListenableFuture<BoundStatement> bsFuture = this.getQueryAsync(objects);
        ListenableFuture<ResultSet> rsFuture = Futures.transform(bsFuture, new AsyncFunction<BoundStatement, ResultSet>(){

            @Override
            public ListenableFuture<ResultSet> apply(BoundStatement bs) throws Exception {
                return Mapper.this.session().executeAsync(bs);
            }
        });
        return Futures.transform(rsFuture, this.mapOneFunction);
    }

    public Statement deleteQuery(T entity, Option ... options) {
        try {
            return Uninterruptibles.getUninterruptibly(this.deleteQueryAsync(entity, Mapper.toMapWithDefaults(options, this.defaultDeleteOptions)));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    public Statement deleteQuery(T entity) {
        try {
            return Uninterruptibles.getUninterruptibly(this.deleteQueryAsync(entity, this.defaultDeleteOptions));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    public Statement deleteQuery(Object ... objects) {
        try {
            return Uninterruptibles.getUninterruptibly(this.deleteQueryAsync(objects));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    private ListenableFuture<BoundStatement> deleteQueryAsync(T entity, EnumMap<Option.Type, Option> options) {
        ArrayList<Object> pks = new ArrayList<Object>();
        for (int i = 0; i < this.mapper.primaryKeySize(); ++i) {
            pks.add(this.mapper.getPrimaryKeyColumn(i).getValue(entity));
        }
        return this.deleteQueryAsync((List<Object>)pks, options);
    }

    private ListenableFuture<BoundStatement> deleteQueryAsync(Object ... objects) {
        ArrayList<Object> pks = new ArrayList<Object>();
        EnumMap<Option.Type, Option> options = new EnumMap<Option.Type, Option>(this.defaultDeleteOptions);
        for (Object o : objects) {
            if (o instanceof Option) {
                Option option = (Option)o;
                options.put(option.type, option);
                continue;
            }
            pks.add(o);
        }
        return this.deleteQueryAsync((List<Object>)pks, options);
    }

    private ListenableFuture<BoundStatement> deleteQueryAsync(final List<Object> primaryKey, final EnumMap<Option.Type, Option> options) {
        if (primaryKey.size() != this.mapper.primaryKeySize()) {
            throw new IllegalArgumentException(String.format("Invalid number of PRIMARY KEY columns provided, %d expected but got %d", this.mapper.primaryKeySize(), primaryKey.size()));
        }
        return Futures.transform(this.getPreparedQueryAsync(QueryType.DEL, options), new Function<PreparedStatement, BoundStatement>(){

            @Override
            public BoundStatement apply(PreparedStatement input) {
                BoundStatement bs = input.bind();
                if (((Mapper)Mapper.this).mapper.writeConsistency != null) {
                    bs.setConsistencyLevel(((Mapper)Mapper.this).mapper.writeConsistency);
                }
                int i = 0;
                for (Option opt : options.values()) {
                    opt.checkValidFor(QueryType.DEL, Mapper.this.manager);
                    opt.addToPreparedStatement(bs, i);
                    if (!opt.isIncludedInQuery()) continue;
                    ++i;
                }
                int columnNumber = 0;
                for (Object value2 : primaryKey) {
                    PropertyMapper column = Mapper.this.mapper.getPrimaryKeyColumn(columnNumber);
                    if (value2 == null) {
                        throw new IllegalArgumentException(String.format("Invalid null value for PRIMARY KEY column %s (argument %d)", column.columnName, i));
                    }
                    Mapper.setObject(bs, i++, value2, column);
                    ++columnNumber;
                }
                return bs;
            }
        });
    }

    public void delete(T entity) {
        try {
            Uninterruptibles.getUninterruptibly(this.deleteAsync(entity));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    public void delete(T entity, Option ... options) {
        try {
            Uninterruptibles.getUninterruptibly(this.deleteAsync(entity, options));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    public ListenableFuture<Void> deleteAsync(T entity) {
        return this.submitVoidQueryAsync(this.deleteQueryAsync(entity, this.defaultDeleteOptions));
    }

    public ListenableFuture<Void> deleteAsync(T entity, Option ... options) {
        return this.submitVoidQueryAsync(this.deleteQueryAsync(entity, Mapper.toMapWithDefaults(options, this.defaultDeleteOptions)));
    }

    public void delete(Object ... objects) {
        try {
            Uninterruptibles.getUninterruptibly(this.deleteAsync(objects));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    public ListenableFuture<Void> deleteAsync(Object ... objects) {
        return this.submitVoidQueryAsync(this.deleteQueryAsync(objects));
    }

    public Result<T> map(ResultSet resultSet) {
        boolean useAlias = !this.manager.isCassandraV1 && this.isFromMapperQuery(resultSet);
        return new Result<T>(resultSet, this.mapper, useAlias);
    }

    public ListenableFuture<Result<T>> mapAsync(ResultSetFuture resultSetFuture) {
        return Futures.transform(resultSetFuture, new Function<ResultSet, Result<T>>(){

            @Override
            public Result<T> apply(ResultSet rs) {
                return Mapper.this.map(rs);
            }
        });
    }

    private boolean isFromMapperQuery(ResultSet resultSet) {
        return resultSet.getExecutionInfo().getStatement() instanceof MapperBoundStatement;
    }

    @Deprecated
    public Result<T> mapAliased(ResultSet resultSet) {
        return this.manager.isCassandraV1 ? this.map(resultSet) : new Result<T>(resultSet, this.mapper, true);
    }

    public void setDefaultSaveOptions(Option ... options) {
        this.defaultSaveOptions = Mapper.toMap(options);
    }

    public void resetDefaultSaveOptions() {
        this.defaultSaveOptions = NO_OPTIONS;
    }

    public void setDefaultGetOptions(Option ... options) {
        this.defaultGetOptions = Mapper.toMap(options);
    }

    public void resetDefaultGetOptions() {
        this.defaultGetOptions = NO_OPTIONS;
    }

    public void setDefaultDeleteOptions(Option ... options) {
        this.defaultDeleteOptions = Mapper.toMap(options);
    }

    public void resetDefaultDeleteOptions() {
        this.defaultDeleteOptions = NO_OPTIONS;
    }

    private static EnumMap<Option.Type, Option> toMap(Option[] options) {
        EnumMap<Option.Type, Option> result = new EnumMap<Option.Type, Option>(Option.Type.class);
        for (Option option : options) {
            result.put(option.type, option);
        }
        return result;
    }

    private static EnumMap<Option.Type, Option> toMapWithDefaults(Option[] options, EnumMap<Option.Type, Option> defaults) {
        EnumMap<Option.Type, Option> result = new EnumMap<Option.Type, Option>(defaults);
        for (Option option : options) {
            result.put(option.type, option);
        }
        return result;
    }

    private static class MapperQueryKey {
        private final QueryType queryType;
        private final EnumSet<Option.Type> optionTypes;
        private final Set<PropertyMapper> columns;

        MapperQueryKey(QueryType queryType, Set<PropertyMapper> propertyMappers, EnumMap<Option.Type, Option> options) {
            Preconditions.checkNotNull(queryType);
            Preconditions.checkNotNull(options);
            Preconditions.checkNotNull(propertyMappers);
            this.queryType = queryType;
            this.columns = propertyMappers;
            this.optionTypes = EnumSet.noneOf(Option.Type.class);
            for (Option opt : options.values()) {
                if (!opt.isIncludedInQuery()) continue;
                this.optionTypes.add(opt.type);
            }
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof MapperQueryKey) {
                MapperQueryKey that = (MapperQueryKey)other;
                return this.queryType.equals((Object)that.queryType) && this.optionTypes.equals(that.optionTypes) && this.columns.equals(that.columns);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(new Object[]{this.queryType, this.optionTypes, this.columns});
        }
    }

    public static abstract class Option {
        final Type type;

        protected Option(Type type) {
            this.type = type;
        }

        public static Option ttl(int ttl) {
            return new Ttl(ttl);
        }

        public static Option timestamp(long timestamp) {
            return new Timestamp(timestamp);
        }

        public static Option consistencyLevel(ConsistencyLevel cl) {
            return new ConsistencyLevelOption(cl);
        }

        public static Option tracing(boolean enabled) {
            return new Tracing(enabled);
        }

        public static Option saveNullFields(boolean enabled) {
            return new SaveNullFields(enabled);
        }

        public Type getType() {
            return this.type;
        }

        abstract void appendTo(Insert.Options var1);

        abstract void appendTo(Delete.Options var1);

        abstract void addToPreparedStatement(BoundStatement var1, int var2);

        abstract void checkValidFor(QueryType var1, MappingManager var2) throws IllegalArgumentException;

        abstract boolean isIncludedInQuery();

        static class SaveNullFields
        extends Option {
            private final boolean saveNullFields;

            SaveNullFields(boolean saveNullFields) {
                super(Type.SAVE_NULL_FIELDS);
                this.saveNullFields = saveNullFields;
            }

            @Override
            void appendTo(Insert.Options usings) {
                throw new UnsupportedOperationException("shouldn't be called");
            }

            @Override
            void appendTo(Delete.Options usings) {
                throw new UnsupportedOperationException("shouldn't be called");
            }

            @Override
            void addToPreparedStatement(BoundStatement bs, int i) {
            }

            @Override
            void checkValidFor(QueryType qt, MappingManager manager) {
                Preconditions.checkArgument(qt == QueryType.SAVE, "SaveNullFields option is only allowed in save queries");
            }

            @Override
            boolean isIncludedInQuery() {
                return false;
            }
        }

        static class Tracing
        extends Option {
            private final boolean tracing;

            Tracing(boolean tracing) {
                super(Type.TRACING);
                this.tracing = tracing;
            }

            @Override
            void appendTo(Insert.Options usings) {
                throw new UnsupportedOperationException("shouldn't be called");
            }

            @Override
            void appendTo(Delete.Options usings) {
                throw new UnsupportedOperationException("shouldn't be called");
            }

            @Override
            void addToPreparedStatement(BoundStatement bs, int i) {
                if (this.tracing) {
                    bs.enableTracing();
                }
            }

            @Override
            void checkValidFor(QueryType qt, MappingManager manager) {
                Preconditions.checkArgument(qt == QueryType.SAVE || qt == QueryType.DEL || qt == QueryType.GET, "Tracing option is only allowed in save, delete and get queries");
            }

            @Override
            boolean isIncludedInQuery() {
                return false;
            }
        }

        static class ConsistencyLevelOption
        extends Option {
            private final ConsistencyLevel cl;

            ConsistencyLevelOption(ConsistencyLevel cl) {
                super(Type.CL);
                this.cl = cl;
            }

            @Override
            void appendTo(Insert.Options usings) {
                throw new UnsupportedOperationException("shouldn't be called");
            }

            @Override
            void appendTo(Delete.Options usings) {
                throw new UnsupportedOperationException("shouldn't be called");
            }

            @Override
            void addToPreparedStatement(BoundStatement bs, int i) {
                bs.setConsistencyLevel(this.cl);
            }

            @Override
            void checkValidFor(QueryType qt, MappingManager manager) {
                Preconditions.checkArgument(qt == QueryType.SAVE || qt == QueryType.DEL || qt == QueryType.GET, "Consistency level option is only allowed in save, delete and get queries");
            }

            @Override
            boolean isIncludedInQuery() {
                return false;
            }
        }

        static class Timestamp
        extends Option {
            private final long tsValue;

            Timestamp(long value2) {
                super(Type.TIMESTAMP);
                this.tsValue = value2;
            }

            @Override
            void appendTo(Insert.Options usings) {
                usings.and(QueryBuilder.timestamp(QueryBuilder.bindMarker()));
            }

            @Override
            void appendTo(Delete.Options usings) {
                usings.and(QueryBuilder.timestamp(QueryBuilder.bindMarker()));
            }

            @Override
            void checkValidFor(QueryType qt, MappingManager manager) {
                Preconditions.checkArgument(!manager.isCassandraV1, "Timestamp option requires native protocol v2 or above");
                Preconditions.checkArgument(qt == QueryType.SAVE || qt == QueryType.DEL, "Timestamp option is only allowed in save and delete queries");
            }

            @Override
            void addToPreparedStatement(BoundStatement bs, int i) {
                bs.setLong(i, this.tsValue);
            }

            @Override
            boolean isIncludedInQuery() {
                return true;
            }
        }

        static class Ttl
        extends Option {
            private final int ttlValue;

            Ttl(int value2) {
                super(Type.TTL);
                this.ttlValue = value2;
            }

            @Override
            void appendTo(Insert.Options usings) {
                usings.and(QueryBuilder.ttl(QueryBuilder.bindMarker()));
            }

            @Override
            void appendTo(Delete.Options usings) {
                throw new UnsupportedOperationException("shouldn't be called");
            }

            @Override
            void addToPreparedStatement(BoundStatement bs, int i) {
                bs.setInt(i, this.ttlValue);
            }

            @Override
            void checkValidFor(QueryType qt, MappingManager manager) {
                Preconditions.checkArgument(!manager.isCassandraV1, "TTL option requires native protocol v2 or above");
                Preconditions.checkArgument(qt == QueryType.SAVE, "TTL option is only allowed in save queries");
            }

            @Override
            boolean isIncludedInQuery() {
                return true;
            }
        }

        static enum Type {
            TTL,
            TIMESTAMP,
            CL,
            TRACING,
            SAVE_NULL_FIELDS;

        }
    }
}

