/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.mapping;

import java.util.Collection;
import java.util.Set;
import shade.com.datastax.spark.connector.driver.core.TableMetadata;
import shade.com.datastax.spark.connector.driver.core.querybuilder.Delete;
import shade.com.datastax.spark.connector.driver.core.querybuilder.Insert;
import shade.com.datastax.spark.connector.driver.core.querybuilder.QueryBuilder;
import shade.com.datastax.spark.connector.driver.core.querybuilder.Select;
import shade.com.datastax.spark.connector.driver.mapping.EntityMapper;
import shade.com.datastax.spark.connector.driver.mapping.Mapper;
import shade.com.datastax.spark.connector.driver.mapping.MappingManager;
import shade.com.datastax.spark.connector.driver.mapping.PropertyMapper;

enum QueryType {
    SAVE{

        @Override
        String makePreparedQueryString(TableMetadata table, EntityMapper<?> mapper, MappingManager manager, Set<PropertyMapper> columns, Collection<Mapper.Option> options) {
            Insert insert2 = table == null ? QueryBuilder.insertInto(mapper.keyspace, mapper.table) : QueryBuilder.insertInto(table);
            for (PropertyMapper col : columns) {
                if (col.isComputed()) continue;
                insert2.value(col.columnName, QueryBuilder.bindMarker());
            }
            Insert.Options usings = insert2.using();
            for (Mapper.Option opt : options) {
                opt.checkValidFor(SAVE, manager);
                if (!opt.isIncludedInQuery()) continue;
                opt.appendTo(usings);
            }
            return insert2.toString();
        }
    }
    ,
    GET{

        @Override
        String makePreparedQueryString(TableMetadata table, EntityMapper<?> mapper, MappingManager manager, Set<PropertyMapper> columns, Collection<Mapper.Option> options) {
            Select.Selection selection = QueryBuilder.select();
            for (PropertyMapper col : mapper.allColumns) {
                Select.SelectionOrAlias column;
                Select.SelectionOrAlias selectionOrAlias = column = col.isComputed() ? selection.raw(col.columnName) : selection.column(col.columnName);
                if (col.alias == null) {
                    selection = column;
                    continue;
                }
                selection = column.as(col.alias);
            }
            Select select = table == null ? selection.from(mapper.keyspace, mapper.table) : selection.from(table);
            Select.Where where = select.where();
            for (int i = 0; i < mapper.primaryKeySize(); ++i) {
                where.and(QueryBuilder.eq(mapper.getPrimaryKeyColumn((int)i).columnName, QueryBuilder.bindMarker()));
            }
            for (Mapper.Option opt : options) {
                opt.checkValidFor(GET, manager);
            }
            return select.toString();
        }
    }
    ,
    DEL{

        @Override
        String makePreparedQueryString(TableMetadata table, EntityMapper<?> mapper, MappingManager manager, Set<PropertyMapper> columns, Collection<Mapper.Option> options) {
            Delete delete = table == null ? QueryBuilder.delete().all().from(mapper.keyspace, mapper.table) : QueryBuilder.delete().all().from(table);
            Delete.Where where = delete.where();
            for (int i = 0; i < mapper.primaryKeySize(); ++i) {
                where.and(QueryBuilder.eq(mapper.getPrimaryKeyColumn((int)i).columnName, QueryBuilder.bindMarker()));
            }
            Delete.Options usings = delete.using();
            for (Mapper.Option opt : options) {
                opt.checkValidFor(DEL, manager);
                if (!opt.isIncludedInQuery()) continue;
                opt.appendTo(usings);
            }
            return delete.toString();
        }
    };


    abstract String makePreparedQueryString(TableMetadata var1, EntityMapper<?> var2, MappingManager var3, Set<PropertyMapper> var4, Collection<Mapper.Option> var5);
}

