/*
 * Decompiled with CFR 0.152.
 */
package shade.com.datastax.spark.connector.driver.mapping;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import shade.com.datastax.spark.connector.driver.mapping.annotations.UDT;
import shade.com.datastax.spark.connector.google.common.collect.Sets;

class TypeMappings {
    TypeMappings() {
    }

    private static boolean mapsToCollection(Class<?> klass) {
        return TypeMappings.mapsToList(klass) || TypeMappings.mapsToSet(klass) || TypeMappings.mapsToMap(klass);
    }

    private static boolean mapsToList(Class<?> klass) {
        return List.class.equals(klass);
    }

    private static boolean mapsToSet(Class<?> klass) {
        return Set.class.equals(klass);
    }

    private static boolean mapsToMap(Class<?> klass) {
        return Map.class.equals(klass);
    }

    static boolean isMappedUDT(Class<?> klass) {
        return klass.isAnnotationPresent(UDT.class);
    }

    static Set<Class<?>> findUDTs(Type type) {
        Set<Class<?>> udts = TypeMappings.findUDTs(type, null);
        return udts == null ? Collections.emptySet() : udts;
    }

    private static Set<Class<?>> findUDTs(Type type, Set<Class<?>> udts) {
        Class klass;
        if (type instanceof ParameterizedType) {
            Class klass2;
            ParameterizedType pt = (ParameterizedType)type;
            Type raw = pt.getRawType();
            if (raw instanceof Class && TypeMappings.mapsToCollection(klass2 = (Class)raw)) {
                Type[] childTypes = pt.getActualTypeArguments();
                udts = TypeMappings.findUDTs(childTypes[0], udts);
                if (TypeMappings.mapsToMap(klass2)) {
                    udts = TypeMappings.findUDTs(childTypes[1], udts);
                }
            }
        } else if (type instanceof Class && TypeMappings.isMappedUDT(klass = (Class)type)) {
            if (udts == null) {
                udts = Sets.newHashSet();
            }
            udts.add(klass);
        }
        return udts;
    }
}

