/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.unsafe.Platform;

public final class XXH64 {
    private static final long PRIME64_1 = -7046029288634856825L;
    private static final long PRIME64_2 = -4417276706812531889L;
    private static final long PRIME64_3 = 1609587929392839161L;
    private static final long PRIME64_4 = -8796714831421723037L;
    private static final long PRIME64_5 = 2870177450012600261L;
    private final long seed;

    public XXH64(long seed) {
        this.seed = seed;
    }

    public String toString() {
        return "xxHash64(seed=" + this.seed + ")";
    }

    public long hashInt(int input) {
        return XXH64.hashInt(input, this.seed);
    }

    public static long hashInt(int input, long seed) {
        long hash2 = seed + 2870177450012600261L + 4L;
        hash2 ^= ((long)input & 0xFFFFFFFFL) * -7046029288634856825L;
        hash2 = Long.rotateLeft(hash2, 23) * -4417276706812531889L + 1609587929392839161L;
        return XXH64.fmix(hash2);
    }

    public long hashLong(long input) {
        return XXH64.hashLong(input, this.seed);
    }

    public static long hashLong(long input, long seed) {
        long hash2 = seed + 2870177450012600261L + 8L;
        hash2 ^= Long.rotateLeft(input * -4417276706812531889L, 31) * -7046029288634856825L;
        hash2 = Long.rotateLeft(hash2, 27) * -7046029288634856825L + -8796714831421723037L;
        return XXH64.fmix(hash2);
    }

    public long hashUnsafeWords(Object base, long offset, int length) {
        return XXH64.hashUnsafeWords(base, offset, length, this.seed);
    }

    public static long hashUnsafeWords(Object base, long offset, int length, long seed) {
        assert (length % 8 == 0) : "lengthInBytes must be a multiple of 8 (word-aligned)";
        long hash2 = XXH64.hashBytesByWords(base, offset, length, seed);
        return XXH64.fmix(hash2);
    }

    public long hashUnsafeBytes(Object base, long offset, int length) {
        return XXH64.hashUnsafeBytes(base, offset, length, this.seed);
    }

    public static long hashUnsafeBytes(Object base, long offset, int length, long seed) {
        long end;
        assert (length >= 0) : "lengthInBytes cannot be negative";
        long hash2 = XXH64.hashBytesByWords(base, offset, length, seed);
        if ((offset += (long)(length & 0xFFFFFFF8)) + 4L <= (end = offset + (long)length)) {
            hash2 ^= ((long)Platform.getInt((Object)base, (long)offset) & 0xFFFFFFFFL) * -7046029288634856825L;
            hash2 = Long.rotateLeft(hash2, 23) * -4417276706812531889L + 1609587929392839161L;
            offset += 4L;
        }
        while (offset < end) {
            hash2 ^= ((long)Platform.getByte((Object)base, (long)offset) & 0xFFL) * 2870177450012600261L;
            hash2 = Long.rotateLeft(hash2, 11) * -7046029288634856825L;
            ++offset;
        }
        return XXH64.fmix(hash2);
    }

    private static long fmix(long hash2) {
        hash2 ^= hash2 >>> 33;
        hash2 *= -4417276706812531889L;
        hash2 ^= hash2 >>> 29;
        hash2 *= 1609587929392839161L;
        hash2 ^= hash2 >>> 32;
        return hash2;
    }

    private static long hashBytesByWords(Object base, long offset, int length, long seed) {
        long hash2;
        long limit;
        long end = offset + (long)length;
        if (length >= 32) {
            limit = end - 32L;
            long v1 = seed + -7046029288634856825L + -4417276706812531889L;
            long v2 = seed + -4417276706812531889L;
            long v3 = seed;
            long v4 = seed - -7046029288634856825L;
            do {
                v1 += Platform.getLong((Object)base, (long)offset) * -4417276706812531889L;
                v1 = Long.rotateLeft(v1, 31);
                v1 *= -7046029288634856825L;
                v2 += Platform.getLong((Object)base, (long)(offset + 8L)) * -4417276706812531889L;
                v2 = Long.rotateLeft(v2, 31);
                v2 *= -7046029288634856825L;
                v3 += Platform.getLong((Object)base, (long)(offset + 16L)) * -4417276706812531889L;
                v3 = Long.rotateLeft(v3, 31);
                v3 *= -7046029288634856825L;
                v4 += Platform.getLong((Object)base, (long)(offset + 24L)) * -4417276706812531889L;
                v4 = Long.rotateLeft(v4, 31);
                v4 *= -7046029288634856825L;
            } while ((offset += 32L) <= limit);
            hash2 = Long.rotateLeft(v1, 1) + Long.rotateLeft(v2, 7) + Long.rotateLeft(v3, 12) + Long.rotateLeft(v4, 18);
            v1 *= -4417276706812531889L;
            v1 = Long.rotateLeft(v1, 31);
            hash2 ^= (v1 *= -7046029288634856825L);
            hash2 = hash2 * -7046029288634856825L + -8796714831421723037L;
            v2 *= -4417276706812531889L;
            v2 = Long.rotateLeft(v2, 31);
            hash2 ^= (v2 *= -7046029288634856825L);
            hash2 = hash2 * -7046029288634856825L + -8796714831421723037L;
            v3 *= -4417276706812531889L;
            v3 = Long.rotateLeft(v3, 31);
            hash2 ^= (v3 *= -7046029288634856825L);
            hash2 = hash2 * -7046029288634856825L + -8796714831421723037L;
            v4 *= -4417276706812531889L;
            v4 = Long.rotateLeft(v4, 31);
            hash2 ^= (v4 *= -7046029288634856825L);
            hash2 = hash2 * -7046029288634856825L + -8796714831421723037L;
        } else {
            hash2 = seed + 2870177450012600261L;
        }
        hash2 += (long)length;
        limit = end - 8L;
        while (offset <= limit) {
            long k1 = Platform.getLong((Object)base, (long)offset);
            hash2 ^= Long.rotateLeft(k1 * -4417276706812531889L, 31) * -7046029288634856825L;
            hash2 = Long.rotateLeft(hash2, 27) * -7046029288634856825L + -8796714831421723037L;
            offset += 8L;
        }
        return hash2;
    }
}

