/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskResult;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.spark_project.guava.collect.ImmutableMap;

public class QueryDisplay {
    private String queryStr;
    private String explainPlan;
    private String errorMessage;
    private String queryId;
    private final Map<Phase, Map<String, Long>> hmsTimingMap = new HashMap<Phase, Map<String, Long>>();
    private final Map<Phase, Map<String, Long>> perfLogStartMap = new HashMap<Phase, Map<String, Long>>();
    private final Map<Phase, Map<String, Long>> perfLogEndMap = new HashMap<Phase, Map<String, Long>>();
    private final LinkedHashMap<String, TaskInfo> tasks = new LinkedHashMap();

    public synchronized void addTask(Task task) {
        this.tasks.put(task.getId(), new TaskInfo(task));
    }

    public synchronized void setTaskCompleted(String taskId, TaskResult result) {
        TaskInfo taskInfo = this.tasks.get(taskId);
        if (taskInfo != null) {
            taskInfo.returnVal = result.getExitVal();
            if (result.getTaskError() != null) {
                taskInfo.errorMsg = result.getTaskError().toString();
            }
            taskInfo.endTime = System.currentTimeMillis();
        }
    }

    public synchronized List<TaskInfo> getTaskInfos() {
        ArrayList<TaskInfo> taskInfos = new ArrayList<TaskInfo>();
        taskInfos.addAll(this.tasks.values());
        return taskInfos;
    }

    public synchronized void setQueryStr(String queryStr) {
        this.queryStr = queryStr;
    }

    public synchronized String getQueryString() {
        return this.returnStringOrUnknown(this.queryStr);
    }

    public synchronized String getExplainPlan() {
        return this.returnStringOrUnknown(this.explainPlan);
    }

    public synchronized void setExplainPlan(String explainPlan) {
        this.explainPlan = explainPlan;
    }

    public synchronized Map<String, Long> getHmsTimings(Phase phase) {
        return this.hmsTimingMap.get((Object)phase);
    }

    public synchronized void setHmsTimings(Phase phase, ImmutableMap<String, Long> hmsTimings) {
        this.hmsTimingMap.put(phase, (Map<String, Long>)hmsTimings);
    }

    public synchronized Map<String, Long> getPerfLogStarts(Phase phase) {
        return this.perfLogStartMap.get((Object)phase);
    }

    public synchronized void setPerfLogStarts(Phase phase, ImmutableMap<String, Long> perfLogStarts) {
        this.perfLogStartMap.put(phase, (Map<String, Long>)perfLogStarts);
    }

    public synchronized Map<String, Long> getPerfLogEnds(Phase phase) {
        return this.perfLogEndMap.get((Object)phase);
    }

    public synchronized void setPerfLogEnds(Phase phase, ImmutableMap<String, Long> perfLogEnds) {
        this.perfLogEndMap.put(phase, (Map<String, Long>)perfLogEnds);
    }

    public synchronized Map<String, Long> getPerfLogTimes(Phase phase) {
        HashMap<String, Long> times = new HashMap<String, Long>();
        Map<String, Long> startTimes = this.perfLogStartMap.get((Object)phase);
        Map<String, Long> endTimes = this.perfLogEndMap.get((Object)phase);
        if (endTimes != null && startTimes != null) {
            for (String timeKey : endTimes.keySet()) {
                Long endTime = endTimes.get(timeKey);
                Long startTime = startTimes.get(timeKey);
                if (startTime == null) continue;
                times.put(timeKey, endTime - startTime);
            }
        }
        return times;
    }

    public synchronized String getErrorMessage() {
        return this.errorMessage;
    }

    public synchronized void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public synchronized String getQueryId() {
        return this.returnStringOrUnknown(this.queryId);
    }

    public synchronized void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    private String returnStringOrUnknown(String s) {
        return s == null ? "UNKNOWN" : s;
    }

    public static class TaskInfo {
        private Integer returnVal;
        private String errorMsg;
        private long endTime;
        final long beginTime = System.currentTimeMillis();
        final String taskId;
        final StageType taskType;
        final String name;
        final boolean requireLock;
        final boolean retryIfFail;

        public TaskInfo(Task task) {
            this.taskId = task.getId();
            this.taskType = task.getType();
            this.name = task.getName();
            this.requireLock = task.requireLock();
            this.retryIfFail = task.ifRetryCmdWhenFail();
        }

        public synchronized String getStatus() {
            if (this.returnVal == null) {
                return "Running";
            }
            if (this.returnVal == 0) {
                return "Success, ReturnVal 0";
            }
            return "Failure, ReturnVal " + String.valueOf(this.returnVal);
        }

        public synchronized long getElapsedTime() {
            if (this.endTime == 0L) {
                return System.currentTimeMillis() - this.beginTime;
            }
            return this.endTime - this.beginTime;
        }

        public synchronized String getErrorMsg() {
            return this.errorMsg;
        }

        public synchronized long getEndTime() {
            return this.endTime;
        }

        public long getBeginTime() {
            return this.beginTime;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public StageType getTaskType() {
            return this.taskType;
        }

        public String getName() {
            return this.name;
        }

        public boolean isRequireLock() {
            return this.requireLock;
        }

        public boolean isRetryIfFail() {
            return this.retryIfFail;
        }
    }

    public static enum Phase {
        COMPILATION,
        EXECUTION;

    }
}

