/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.persistence.AbstractRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.BytesBytesMultiHashMap;
import org.apache.hadoop.hive.ql.exec.persistence.HashMapWrapper;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKey;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapper;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapperBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.WriteBuffers;
import org.apache.hadoop.hive.serde2.binarysortable.BinarySortableSerDe;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryFactory;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryStruct;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinaryUtils;
import org.apache.hadoop.hive.serde2.lazybinary.objectinspector.LazyBinaryObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.lazybinary.objectinspector.LazyBinaryStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Writable;

public class MapJoinBytesTableContainer
implements MapJoinTableContainer {
    private static final Log LOG = LogFactory.getLog(MapJoinTableContainer.class);
    private final BytesBytesMultiHashMap hashMap;
    private LazyBinaryStructObjectInspector internalValueOi;
    private boolean[] sortableSortOrders;
    private KeyValueHelper writeHelper;
    private final List<Object> EMPTY_LIST = new ArrayList<Object>(0);

    public MapJoinBytesTableContainer(Configuration hconf, MapJoinObjectSerDeContext valCtx, long keyCount, long memUsage) throws SerDeException {
        this(HiveConf.getFloatVar(hconf, HiveConf.ConfVars.HIVEHASHTABLEKEYCOUNTADJUSTMENT), HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEHASHTABLETHRESHOLD), HiveConf.getFloatVar(hconf, HiveConf.ConfVars.HIVEHASHTABLELOADFACTOR), HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEHASHTABLEWBSIZE), valCtx, keyCount, memUsage);
    }

    private MapJoinBytesTableContainer(float keyCountAdj, int threshold, float loadFactor, int wbSize, MapJoinObjectSerDeContext valCtx, long keyCount, long memUsage) throws SerDeException {
        int newThreshold = HashMapWrapper.calculateTableSize(keyCountAdj, threshold, loadFactor, keyCount);
        this.hashMap = new BytesBytesMultiHashMap(newThreshold, loadFactor, wbSize, memUsage, threshold);
    }

    private LazyBinaryStructObjectInspector createInternalOi(MapJoinObjectSerDeContext valCtx) throws SerDeException {
        List fields = ((StructObjectInspector)valCtx.getSerDe().getObjectInspector()).getAllStructFieldRefs();
        ArrayList<String> colNames = new ArrayList<String>(fields.size());
        ArrayList<ObjectInspector> colOis = new ArrayList<ObjectInspector>(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            StructField field = (StructField)fields.get(i);
            colNames.add(field.getFieldName());
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)field.getFieldObjectInspector().getTypeName());
            colOis.add(LazyBinaryUtils.getLazyBinaryObjectInspectorFromTypeInfo((TypeInfo)typeInfo));
        }
        return LazyBinaryObjectInspectorFactory.getLazyBinaryStructObjectInspector(colNames, colOis);
    }

    @Override
    public MapJoinKey putRow(MapJoinObjectSerDeContext keyContext, Writable currentKey, MapJoinObjectSerDeContext valueContext, Writable currentValue) throws SerDeException {
        SerDe keySerde = keyContext.getSerDe();
        SerDe valSerde = valueContext.getSerDe();
        if (this.writeHelper == null) {
            LOG.info((Object)("Initializing container with " + keySerde.getClass().getName() + " and " + valSerde.getClass().getName()));
            if (keySerde instanceof BinarySortableSerDe && valSerde instanceof LazyBinarySerDe) {
                LazyBinaryStructObjectInspector valSoi = (LazyBinaryStructObjectInspector)valSerde.getObjectInspector();
                this.writeHelper = new LazyBinaryKvWriter(keySerde, valSoi, valueContext.hasFilterTag());
                this.internalValueOi = valSoi;
                this.sortableSortOrders = ((BinarySortableSerDe)keySerde).getSortOrders();
            } else {
                this.writeHelper = new KeyValueWriter(keySerde, valSerde, valueContext.hasFilterTag());
                this.internalValueOi = this.createInternalOi(valueContext);
                this.sortableSortOrders = null;
            }
        }
        this.writeHelper.setKeyValue(currentKey, currentValue);
        this.hashMap.put(this.writeHelper);
        return null;
    }

    @Override
    public void clear() {
        this.hashMap.clear();
    }

    @Override
    public MapJoinKey getAnyKey() {
        return null;
    }

    @Override
    public MapJoinTableContainer.ReusableGetAdaptor createGetter(MapJoinKey keyTypeFromLoader) {
        if (keyTypeFromLoader != null) {
            throw new AssertionError((Object)("No key expected from loader but got " + keyTypeFromLoader));
        }
        return new GetAdaptor();
    }

    @Override
    public void seal() {
        this.hashMap.seal();
    }

    public static boolean isSupportedKey(ObjectInspector keyOi) {
        List keyFields = ((StructObjectInspector)keyOi).getAllStructFieldRefs();
        for (StructField field : keyFields) {
            if (MapJoinKey.isSupportedField(field.getFieldObjectInspector())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void dumpMetrics() {
        this.hashMap.debugDumpMetrics();
    }

    private class ReusableRowContainer
    implements MapJoinRowContainer,
    AbstractRowContainer.RowIterator<List<Object>> {
        private byte aliasFilter;
        private List<WriteBuffers.ByteSegmentRef> refs;
        private int currentRow;
        private List<Object> dummyRow = null;
        private final ByteArrayRef uselessIndirection;
        private final LazyBinaryStruct valueStruct;

        public ReusableRowContainer() {
            this.valueStruct = MapJoinBytesTableContainer.this.internalValueOi != null ? (LazyBinaryStruct)LazyBinaryFactory.createLazyBinaryObject((ObjectInspector)MapJoinBytesTableContainer.this.internalValueOi) : null;
            this.uselessIndirection = new ByteArrayRef();
            this.clearRows();
        }

        public void setFromOutput(ByteStream.Output output) {
            if (this.refs == null) {
                this.refs = new ArrayList<WriteBuffers.ByteSegmentRef>(0);
            }
            byte aliasFilter = MapJoinBytesTableContainer.this.hashMap.getValueRefs(output.getData(), output.getLength(), this.refs);
            this.aliasFilter = (byte)(this.refs.isEmpty() ? -1 : (int)aliasFilter);
            this.dummyRow = null;
        }

        public boolean isEmpty() {
            return this.refs.isEmpty() && this.dummyRow == null;
        }

        @Override
        public AbstractRowContainer.RowIterator<List<Object>> rowIter() throws HiveException {
            this.currentRow = -1;
            return this;
        }

        @Override
        public int rowCount() throws HiveException {
            return this.dummyRow != null ? 1 : this.refs.size();
        }

        @Override
        public void clearRows() {
            if (this.refs != null) {
                this.refs.clear();
            }
            this.dummyRow = null;
            this.currentRow = -1;
            this.aliasFilter = (byte)-1;
        }

        @Override
        public byte getAliasFilter() throws HiveException {
            return this.aliasFilter;
        }

        @Override
        public MapJoinRowContainer copy() throws HiveException {
            return this;
        }

        @Override
        public List<Object> first() throws HiveException {
            this.currentRow = 0;
            return this.next();
        }

        @Override
        public List<Object> next() throws HiveException {
            WriteBuffers.ByteSegmentRef ref;
            if (this.dummyRow != null) {
                List<Object> result = this.dummyRow;
                this.dummyRow = null;
                return result;
            }
            if (this.currentRow < 0 || this.refs.size() < this.currentRow) {
                throw new HiveException("No rows");
            }
            if (this.refs.size() == this.currentRow) {
                return null;
            }
            if ((ref = this.refs.get(this.currentRow++)).getLength() == 0) {
                return MapJoinBytesTableContainer.this.EMPTY_LIST;
            }
            if (ref.getBytes() == null) {
                MapJoinBytesTableContainer.this.hashMap.populateValue(ref);
            }
            this.uselessIndirection.setData(ref.getBytes());
            this.valueStruct.init(this.uselessIndirection, (int)ref.getOffset(), ref.getLength());
            return this.valueStruct.getFieldsAsList();
        }

        @Override
        public void addRow(List<Object> t) {
            if (this.dummyRow != null || !this.refs.isEmpty()) {
                throw new RuntimeException("Cannot add rows when not empty");
            }
            this.dummyRow = t;
        }

        @Override
        public void addRow(Object[] value) {
            throw new RuntimeException(this.getClass().getCanonicalName() + " cannot add arrays");
        }

        @Override
        public void write(MapJoinObjectSerDeContext valueContext, ObjectOutputStream out) {
            throw new RuntimeException(this.getClass().getCanonicalName() + " cannot be serialized");
        }
    }

    private class GetAdaptor
    implements MapJoinTableContainer.ReusableGetAdaptor {
        private Object[] currentKey;
        private boolean[] nulls;
        private List<ObjectInspector> vectorKeyOIs;
        private final ReusableRowContainer currentValue;
        private final ByteStream.Output output;

        public GetAdaptor() {
            this.currentValue = new ReusableRowContainer();
            this.output = new ByteStream.Output();
        }

        @Override
        public void setFromVector(VectorHashKeyWrapper kw, VectorExpressionWriter[] keyOutputWriters, VectorHashKeyWrapperBatch keyWrapperBatch) throws HiveException {
            int i;
            if (this.nulls == null) {
                this.nulls = new boolean[keyOutputWriters.length];
                this.currentKey = new Object[keyOutputWriters.length];
                this.vectorKeyOIs = new ArrayList<ObjectInspector>();
                for (i = 0; i < keyOutputWriters.length; ++i) {
                    this.vectorKeyOIs.add(keyOutputWriters[i].getObjectInspector());
                }
            } else assert (this.nulls.length == keyOutputWriters.length);
            for (i = 0; i < keyOutputWriters.length; ++i) {
                this.currentKey[i] = keyWrapperBatch.getWritableKeyValue(kw, i, keyOutputWriters[i]);
                this.nulls[i] = this.currentKey[i] == null;
            }
            this.currentValue.setFromOutput(MapJoinKey.serializeRow(this.output, this.currentKey, this.vectorKeyOIs, MapJoinBytesTableContainer.this.sortableSortOrders));
        }

        @Override
        public void setFromRow(Object row, List<ExprNodeEvaluator> fields, List<ObjectInspector> ois) throws HiveException {
            if (this.nulls == null) {
                this.nulls = new boolean[fields.size()];
                this.currentKey = new Object[fields.size()];
            }
            for (int keyIndex = 0; keyIndex < fields.size(); ++keyIndex) {
                this.currentKey[keyIndex] = fields.get(keyIndex).evaluate(row);
                this.nulls[keyIndex] = this.currentKey[keyIndex] == null;
            }
            this.currentValue.setFromOutput(MapJoinKey.serializeRow(this.output, this.currentKey, ois, MapJoinBytesTableContainer.this.sortableSortOrders));
        }

        @Override
        public void setFromOther(MapJoinTableContainer.ReusableGetAdaptor other) {
            assert (other instanceof GetAdaptor);
            GetAdaptor other2 = (GetAdaptor)other;
            this.nulls = other2.nulls;
            this.currentKey = other2.currentKey;
            this.currentValue.setFromOutput(other2.output);
        }

        @Override
        public boolean hasAnyNulls(int fieldCount, boolean[] nullsafes) {
            if (this.nulls == null || this.nulls.length == 0) {
                return false;
            }
            for (int i = 0; i < this.nulls.length; ++i) {
                if (!this.nulls[i] || nullsafes != null && nullsafes[i]) continue;
                return true;
            }
            return false;
        }

        @Override
        public MapJoinRowContainer getCurrentRows() {
            return this.currentValue.isEmpty() ? null : this.currentValue;
        }

        @Override
        public Object[] getCurrentKey() {
            return this.currentKey;
        }
    }

    private static class LazyBinaryKvWriter
    implements KeyValueHelper {
        private final LazyBinaryStruct.SingleFieldGetter filterGetter;
        private Writable key;
        private Writable value;
        private final SerDe keySerDe;
        private Boolean hasTag = null;

        public LazyBinaryKvWriter(SerDe keySerDe, LazyBinaryStructObjectInspector valSoi, boolean hasFilterTag) throws SerDeException {
            this.keySerDe = keySerDe;
            if (hasFilterTag) {
                int ix;
                List fields = valSoi.getAllStructFieldRefs();
                if (!(((StructField)fields.get(ix = fields.size() - 1)).getFieldObjectInspector() instanceof ShortObjectInspector)) {
                    throw new SerDeException("Has filter tag, but corresponding OI is " + ((StructField)fields.get(ix)).getFieldObjectInspector());
                }
                this.filterGetter = new LazyBinaryStruct.SingleFieldGetter(valSoi, fields.size() - 1);
            } else {
                this.filterGetter = null;
            }
        }

        @Override
        public void writeKey(ByteStream.RandomAccessOutput dest) throws SerDeException {
            if (!(this.key instanceof BinaryComparable)) {
                throw new SerDeException("Unexpected type " + this.key.getClass().getCanonicalName());
            }
            this.sanityCheckKeyForTag();
            BinaryComparable b = (BinaryComparable)this.key;
            dest.write(b.getBytes(), 0, b.getLength() - (this.hasTag != false ? 1 : 0));
        }

        private void sanityCheckKeyForTag() throws SerDeException {
            if (this.hasTag != null) {
                return;
            }
            BinaryComparable b = (BinaryComparable)this.key;
            Object o = this.keySerDe.deserialize(this.key);
            StructObjectInspector soi = (StructObjectInspector)this.keySerDe.getObjectInspector();
            List fields = soi.getAllStructFieldRefs();
            Object[] data = new Object[fields.size()];
            ArrayList<ObjectInspector> fois = new ArrayList<ObjectInspector>(fields.size());
            for (int i = 0; i < fields.size(); ++i) {
                data[i] = soi.getStructFieldData(o, (StructField)fields.get(i));
                fois.add(((StructField)fields.get(i)).getFieldObjectInspector());
            }
            ByteStream.Output output = new ByteStream.Output();
            BinarySortableSerDe.serializeStruct((ByteStream.Output)output, (Object[])data, fois, (boolean[])new boolean[fields.size()]);
            this.hasTag = output.getLength() != b.getLength();
            if (this.hasTag.booleanValue()) {
                LOG.error((Object)"Tag found in keys and will be removed. This should not happen.");
                if (output.getLength() != b.getLength() - 1) {
                    throw new SerDeException("Unexpected tag: " + b.getLength() + " reserialized to " + output.getLength());
                }
            }
        }

        @Override
        public void writeValue(ByteStream.RandomAccessOutput dest) throws SerDeException {
            if (!(this.value instanceof BinaryComparable)) {
                throw new SerDeException("Unexpected type " + this.value.getClass().getCanonicalName());
            }
            BinaryComparable b = (BinaryComparable)this.value;
            dest.write(b.getBytes(), 0, b.getLength());
        }

        @Override
        public void setKeyValue(Writable key, Writable val) {
            this.key = key;
            this.value = val;
        }

        @Override
        public byte updateStateByte(Byte previousValue) {
            if (this.filterGetter == null) {
                return -1;
            }
            byte aliasFilter = previousValue == null ? (byte)-1 : (byte)previousValue;
            this.filterGetter.init((BinaryComparable)this.value);
            aliasFilter = (byte)(aliasFilter & this.filterGetter.getShort());
            return aliasFilter;
        }
    }

    private static class KeyValueWriter
    implements KeyValueHelper {
        private final SerDe keySerDe;
        private final SerDe valSerDe;
        private final StructObjectInspector keySoi;
        private final StructObjectInspector valSoi;
        private final List<ObjectInspector> keyOis;
        private final List<ObjectInspector> valOis;
        private final Object[] keyObjs;
        private final Object[] valObjs;
        private final boolean hasFilterTag;

        public KeyValueWriter(SerDe keySerDe, SerDe valSerDe, boolean hasFilterTag) throws SerDeException {
            int i;
            this.keySerDe = keySerDe;
            this.valSerDe = valSerDe;
            this.keySoi = (StructObjectInspector)keySerDe.getObjectInspector();
            this.valSoi = (StructObjectInspector)valSerDe.getObjectInspector();
            List keyFields = this.keySoi.getAllStructFieldRefs();
            List valFields = this.valSoi.getAllStructFieldRefs();
            this.keyOis = new ArrayList<ObjectInspector>(keyFields.size());
            this.valOis = new ArrayList<ObjectInspector>(valFields.size());
            for (i = 0; i < keyFields.size(); ++i) {
                this.keyOis.add(((StructField)keyFields.get(i)).getFieldObjectInspector());
            }
            for (i = 0; i < valFields.size(); ++i) {
                this.valOis.add(((StructField)valFields.get(i)).getFieldObjectInspector());
            }
            this.keyObjs = new Object[this.keyOis.size()];
            this.valObjs = new Object[this.valOis.size()];
            this.hasFilterTag = hasFilterTag;
        }

        @Override
        public void writeKey(ByteStream.RandomAccessOutput dest) throws SerDeException {
            LazyBinarySerDe.serializeStruct((ByteStream.RandomAccessOutput)dest, (Object[])this.keyObjs, this.keyOis);
        }

        @Override
        public void writeValue(ByteStream.RandomAccessOutput dest) throws SerDeException {
            LazyBinarySerDe.serializeStruct((ByteStream.RandomAccessOutput)dest, (Object[])this.valObjs, this.valOis);
        }

        @Override
        public void setKeyValue(Writable key, Writable val) throws SerDeException {
            int i;
            Object keyObj = this.keySerDe.deserialize(key);
            Object valObj = this.valSerDe.deserialize(val);
            List keyFields = this.keySoi.getAllStructFieldRefs();
            List valFields = this.valSoi.getAllStructFieldRefs();
            for (i = 0; i < keyFields.size(); ++i) {
                this.keyObjs[i] = this.keySoi.getStructFieldData(keyObj, (StructField)keyFields.get(i));
            }
            for (i = 0; i < valFields.size(); ++i) {
                this.valObjs[i] = this.valSoi.getStructFieldData(valObj, (StructField)valFields.get(i));
            }
        }

        @Override
        public byte updateStateByte(Byte previousValue) {
            if (!this.hasFilterTag) {
                return -1;
            }
            byte aliasFilter = previousValue == null ? (byte)-1 : (byte)previousValue;
            aliasFilter = (byte)(aliasFilter & ((ShortWritable)this.valObjs[this.valObjs.length - 1]).get());
            return aliasFilter;
        }
    }

    private static interface KeyValueHelper
    extends BytesBytesMultiHashMap.KvSource {
        public void setKeyValue(Writable var1, Writable var2) throws SerDeException;
    }
}

