/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.hive.ql.exec.spark.HiveKVResultCache;
import org.apache.hadoop.hive.ql.exec.spark.SparkUtilities;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapred.OutputCollector;
import org.spark_project.guava.base.Preconditions;
import scala.Tuple2;

public abstract class HiveBaseFunctionResultList<T>
implements Iterable,
OutputCollector<HiveKey, BytesWritable>,
Serializable {
    private static final long serialVersionUID = -1L;
    private final Iterator<T> inputIterator;
    private boolean isClosed = false;
    private final HiveKVResultCache lastRecordOutput;
    private boolean iteratorAlreadyCreated = false;

    public HiveBaseFunctionResultList(Iterator<T> inputIterator) {
        this.inputIterator = inputIterator;
        this.lastRecordOutput = new HiveKVResultCache();
    }

    public Iterator iterator() {
        Preconditions.checkState((!this.iteratorAlreadyCreated ? 1 : 0) != 0, (Object)"Iterator can only be created once.");
        this.iteratorAlreadyCreated = true;
        return new ResultIterator();
    }

    public void collect(HiveKey key, BytesWritable value) throws IOException {
        this.lastRecordOutput.add(SparkUtilities.copyHiveKey(key), SparkUtilities.copyBytesWritable(value));
    }

    protected abstract void processNextRecord(T var1) throws IOException;

    protected abstract boolean processingDone();

    protected abstract void closeRecordProcessor();

    public class ResultIterator
    implements Iterator {
        @Override
        public boolean hasNext() {
            if (HiveBaseFunctionResultList.this.lastRecordOutput.hasNext()) {
                return true;
            }
            while (HiveBaseFunctionResultList.this.inputIterator.hasNext() && !HiveBaseFunctionResultList.this.processingDone()) {
                try {
                    HiveBaseFunctionResultList.this.processNextRecord(HiveBaseFunctionResultList.this.inputIterator.next());
                    if (!HiveBaseFunctionResultList.this.lastRecordOutput.hasNext()) continue;
                    return true;
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Error while processing input.", ex);
                }
            }
            if (!HiveBaseFunctionResultList.this.isClosed) {
                HiveBaseFunctionResultList.this.closeRecordProcessor();
                HiveBaseFunctionResultList.this.isClosed = true;
            }
            if (HiveBaseFunctionResultList.this.lastRecordOutput.hasNext()) {
                return true;
            }
            HiveBaseFunctionResultList.this.lastRecordOutput.clear();
            return false;
        }

        public Tuple2<HiveKey, BytesWritable> next() {
            if (this.hasNext()) {
                return HiveBaseFunctionResultList.this.lastRecordOutput.next();
            }
            throw new NoSuchElementException("There are no more elements");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Iterator.remove() is not supported");
        }
    }
}

