/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark.status.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.JavaSparkListener;
import org.apache.spark.executor.TaskMetrics;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerApplicationStart;
import org.apache.spark.scheduler.SparkListenerBlockManagerAdded;
import org.apache.spark.scheduler.SparkListenerBlockManagerRemoved;
import org.apache.spark.scheduler.SparkListenerEnvironmentUpdate;
import org.apache.spark.scheduler.SparkListenerExecutorAdded;
import org.apache.spark.scheduler.SparkListenerExecutorMetricsUpdate;
import org.apache.spark.scheduler.SparkListenerExecutorRemoved;
import org.apache.spark.scheduler.SparkListenerJobEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.scheduler.SparkListenerStageCompleted;
import org.apache.spark.scheduler.SparkListenerStageSubmitted;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.scheduler.SparkListenerTaskGettingResult;
import org.apache.spark.scheduler.SparkListenerTaskStart;
import org.apache.spark.scheduler.SparkListenerUnpersistRDD;
import org.spark_project.guava.collect.Lists;
import org.spark_project.guava.collect.Maps;

public class JobMetricsListener
extends JavaSparkListener {
    private static final Log LOG = LogFactory.getLog(JobMetricsListener.class);
    private final Map<Integer, int[]> jobIdToStageId = Maps.newHashMap();
    private final Map<Integer, Integer> stageIdToJobId = Maps.newHashMap();
    private final Map<Integer, Map<String, List<TaskMetrics>>> allJobMetrics = Maps.newHashMap();

    public void onExecutorRemoved(SparkListenerExecutorRemoved removed) {
    }

    public void onExecutorAdded(SparkListenerExecutorAdded added) {
    }

    public void onStageCompleted(SparkListenerStageCompleted stageCompleted) {
    }

    public void onStageSubmitted(SparkListenerStageSubmitted stageSubmitted) {
    }

    public void onTaskStart(SparkListenerTaskStart taskStart) {
    }

    public void onTaskGettingResult(SparkListenerTaskGettingResult taskGettingResult) {
    }

    public synchronized void onTaskEnd(SparkListenerTaskEnd taskEnd) {
        int stageId = taskEnd.stageId();
        int stageAttemptId = taskEnd.stageAttemptId();
        String stageIdentifier = stageId + "_" + stageAttemptId;
        Integer jobId = this.stageIdToJobId.get(stageId);
        if (jobId == null) {
            LOG.warn((Object)("Can not find job id for stage[" + stageId + "]."));
        } else {
            List stageMetrics;
            HashMap jobMetrics = this.allJobMetrics.get(jobId);
            if (jobMetrics == null) {
                jobMetrics = Maps.newHashMap();
                this.allJobMetrics.put(jobId, jobMetrics);
            }
            if ((stageMetrics = (List)jobMetrics.get(stageIdentifier)) == null) {
                stageMetrics = Lists.newLinkedList();
                jobMetrics.put(stageIdentifier, stageMetrics);
            }
            stageMetrics.add(taskEnd.taskMetrics());
        }
    }

    public synchronized void onJobStart(SparkListenerJobStart jobStart) {
        int jobId = jobStart.jobId();
        int size = jobStart.stageIds().size();
        int[] intStageIds = new int[size];
        for (int i = 0; i < size; ++i) {
            Integer stageId = (Integer)jobStart.stageIds().apply(i);
            intStageIds[i] = stageId;
            this.stageIdToJobId.put(stageId, jobId);
        }
        this.jobIdToStageId.put(jobId, intStageIds);
    }

    public synchronized void onJobEnd(SparkListenerJobEnd jobEnd) {
    }

    public void onEnvironmentUpdate(SparkListenerEnvironmentUpdate environmentUpdate) {
    }

    public void onBlockManagerAdded(SparkListenerBlockManagerAdded blockManagerAdded) {
    }

    public void onBlockManagerRemoved(SparkListenerBlockManagerRemoved blockManagerRemoved) {
    }

    public void onUnpersistRDD(SparkListenerUnpersistRDD unpersistRDD) {
    }

    public void onApplicationStart(SparkListenerApplicationStart applicationStart) {
    }

    public void onApplicationEnd(SparkListenerApplicationEnd applicationEnd) {
    }

    public void onExecutorMetricsUpdate(SparkListenerExecutorMetricsUpdate executorMetricsUpdate) {
    }

    public synchronized Map<String, List<TaskMetrics>> getJobMetric(int jobId) {
        return this.allJobMetrics.get(jobId);
    }

    public synchronized void cleanup(int jobId) {
        this.allJobMetrics.remove(jobId);
        this.jobIdToStageId.remove(jobId);
        Iterator<Map.Entry<Integer, Integer>> iterator = this.stageIdToJobId.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Integer> entry = iterator.next();
            if (entry.getValue() != jobId) continue;
            iterator.remove();
        }
    }
}

