/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.split.TezGroupedSplit;
import org.apache.hadoop.mapred.split.TezMapredSplitsGrouper;
import org.apache.tez.dag.api.TaskLocationHint;
import org.spark_project.guava.collect.ArrayListMultimap;
import org.spark_project.guava.collect.Lists;
import org.spark_project.guava.collect.Multimap;

public class SplitGrouper {
    private static final Log LOG = LogFactory.getLog(SplitGrouper.class);
    private final TezMapredSplitsGrouper tezGrouper = new TezMapredSplitsGrouper();

    public Multimap<Integer, InputSplit> group(Configuration conf, Multimap<Integer, InputSplit> bucketSplitMultimap, int availableSlots, float waves) throws IOException {
        Map<Integer, Integer> bucketTaskMap = this.estimateBucketSizes(availableSlots, waves, bucketSplitMultimap.asMap());
        ArrayListMultimap bucketGroupedSplitMultimap = ArrayListMultimap.create();
        Iterator i$ = bucketSplitMultimap.keySet().iterator();
        while (i$.hasNext()) {
            int bucketId = (Integer)i$.next();
            Collection inputSplitCollection = bucketSplitMultimap.get((Object)bucketId);
            InputSplit[] rawSplits = inputSplitCollection.toArray(new InputSplit[0]);
            InputSplit[] groupedSplits = this.tezGrouper.getGroupedSplits(conf, rawSplits, bucketTaskMap.get(bucketId).intValue(), HiveInputFormat.class.getName());
            LOG.info((Object)("Original split size is " + rawSplits.length + " grouped split size is " + groupedSplits.length + ", for bucket: " + bucketId));
            for (InputSplit inSplit : groupedSplits) {
                bucketGroupedSplitMultimap.put((Object)bucketId, (Object)inSplit);
            }
        }
        return bucketGroupedSplitMultimap;
    }

    private Map<Integer, Integer> estimateBucketSizes(int availableSlots, float waves, Map<Integer, Collection<InputSplit>> bucketSplitMap) {
        HashMap<Integer, Long> bucketSizeMap = new HashMap<Integer, Long>();
        HashMap<Integer, Integer> bucketTaskMap = new HashMap<Integer, Integer>();
        long totalSize = 0L;
        boolean earlyExit = false;
        for (int bucketId : bucketSplitMap.keySet()) {
            long size = 0L;
            for (InputSplit s : bucketSplitMap.get(bucketId)) {
                if (!(s instanceof FileSplit)) {
                    bucketTaskMap.put(bucketId, (int)((float)availableSlots * waves));
                    earlyExit = true;
                    continue;
                }
                FileSplit fsplit = (FileSplit)s;
                size += fsplit.getLength();
                totalSize += fsplit.getLength();
            }
            bucketSizeMap.put(bucketId, size);
        }
        if (earlyExit) {
            return bucketTaskMap;
        }
        for (int bucketId : bucketSizeMap.keySet()) {
            int numEstimatedTasks = 0;
            if (totalSize != 0L) {
                numEstimatedTasks = (int)((float)availableSlots * waves * (float)((Long)bucketSizeMap.get(bucketId)).longValue() / (float)totalSize);
            }
            LOG.info((Object)("Estimated number of tasks: " + numEstimatedTasks + " for bucket " + bucketId));
            if (numEstimatedTasks == 0) {
                numEstimatedTasks = 1;
            }
            bucketTaskMap.put(bucketId, numEstimatedTasks);
        }
        return bucketTaskMap;
    }

    public List<TaskLocationHint> createTaskLocationHints(InputSplit[] splits) throws IOException {
        ArrayList locationHints = Lists.newArrayListWithCapacity((int)splits.length);
        for (InputSplit split : splits) {
            String rack;
            String string = rack = split instanceof TezGroupedSplit ? ((TezGroupedSplit)split).getRack() : null;
            if (rack == null) {
                if (split.getLocations() != null) {
                    locationHints.add(TaskLocationHint.createTaskLocationHint(new HashSet<String>(Arrays.asList(split.getLocations())), null));
                    continue;
                }
                locationHints.add(TaskLocationHint.createTaskLocationHint(null, null));
                continue;
            }
            locationHints.add(TaskLocationHint.createTaskLocationHint(null, Collections.singleton(rack)));
        }
        return locationHints;
    }
}

