/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.io.Text;

public class VectorUDFDateAddColScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private int outputColumn;
    private int numDays;
    protected boolean isPositive = true;
    private final transient Calendar calendar = Calendar.getInstance();
    private transient SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    private final transient Text text = new Text();

    public VectorUDFDateAddColScalar(int colNum, long numDays, int outputColumn) {
        this.colNum = colNum;
        this.numDays = (int)numDays;
        this.outputColumn = outputColumn;
    }

    public VectorUDFDateAddColScalar() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        BytesColumnVector outV = (BytesColumnVector)batch.cols[this.outputColumn];
        ColumnVector inputCol = batch.cols[this.colNum];
        int n = inputCol.isRepeating ? 1 : batch.size;
        int[] sel = batch.selected;
        if (batch.size == 0) {
            return;
        }
        outV.isRepeating = inputCol.isRepeating;
        switch (this.inputTypes[0]) {
            case DATE: {
                if (inputCol.noNulls) {
                    outV.noNulls = true;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            outV.vector[i] = this.evaluateDate(inputCol, i);
                            outV.start[i] = 0;
                            outV.length[i] = outV.vector[i].length;
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outV.vector[i] = this.evaluateDate(inputCol, i);
                            outV.start[i] = 0;
                            outV.length[i] = outV.vector[i].length;
                        }
                    }
                } else {
                    outV.noNulls = false;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            outV.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            outV.vector[i] = this.evaluateDate(inputCol, i);
                            outV.start[i] = 0;
                            outV.length[i] = outV.vector[i].length;
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outV.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            outV.vector[i] = this.evaluateDate(inputCol, i);
                            outV.start[i] = 0;
                            outV.length[i] = outV.vector[i].length;
                        }
                    }
                }
                break;
            }
            case TIMESTAMP: {
                if (inputCol.noNulls) {
                    outV.noNulls = true;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            outV.vector[i] = this.evaluateTimestamp(inputCol, i);
                            outV.start[i] = 0;
                            outV.length[i] = outV.vector[i].length;
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outV.vector[i] = this.evaluateTimestamp(inputCol, i);
                            outV.start[i] = 0;
                            outV.length[i] = outV.vector[i].length;
                        }
                    }
                } else {
                    outV.noNulls = false;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            outV.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            outV.vector[i] = this.evaluateTimestamp(inputCol, i);
                            outV.start[i] = 0;
                            outV.length[i] = outV.vector[i].length;
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outV.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            outV.vector[i] = this.evaluateTimestamp(inputCol, i);
                            outV.start[i] = 0;
                            outV.length[i] = outV.vector[i].length;
                        }
                    }
                }
                break;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                if (inputCol.noNulls) {
                    outV.noNulls = true;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            this.evaluateString(inputCol, outV, i);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            this.evaluateString(inputCol, outV, i);
                        }
                    }
                } else {
                    outV.noNulls = false;
                    if (batch.selectedInUse) {
                        for (int j = 0; j < n; ++j) {
                            int i = sel[j];
                            outV.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            this.evaluateString(inputCol, outV, i);
                        }
                    } else {
                        for (int i = 0; i < n; ++i) {
                            outV.isNull[i] = inputCol.isNull[i];
                            if (inputCol.isNull[i]) continue;
                            this.evaluateString(inputCol, outV, i);
                        }
                    }
                }
                break;
            }
            default: {
                throw new Error("Unsupported input type " + this.inputTypes[0].name());
            }
        }
    }

    protected byte[] evaluateTimestamp(ColumnVector columnVector, int index) {
        LongColumnVector lcv = (LongColumnVector)columnVector;
        this.calendar.setTimeInMillis(lcv.vector[index] / 1000000L);
        if (this.isPositive) {
            this.calendar.add(5, this.numDays);
        } else {
            this.calendar.add(5, -this.numDays);
        }
        Date newDate = this.calendar.getTime();
        this.text.set(this.formatter.format(newDate));
        return Arrays.copyOf(this.text.getBytes(), this.text.getLength());
    }

    protected byte[] evaluateDate(ColumnVector columnVector, int index) {
        LongColumnVector lcv = (LongColumnVector)columnVector;
        if (this.isPositive) {
            this.calendar.setTimeInMillis(DateWritable.daysToMillis((int)((int)lcv.vector[index] + this.numDays)));
        } else {
            this.calendar.setTimeInMillis(DateWritable.daysToMillis((int)((int)lcv.vector[index] - this.numDays)));
        }
        Date newDate = this.calendar.getTime();
        this.text.set(this.formatter.format(newDate));
        return Arrays.copyOf(this.text.getBytes(), this.text.getLength());
    }

    protected void evaluateString(ColumnVector columnVector, BytesColumnVector outputVector, int i) {
        BytesColumnVector bcv = (BytesColumnVector)columnVector;
        this.text.set(bcv.vector[i], bcv.start[i], bcv.length[i]);
        try {
            this.calendar.setTime(this.formatter.parse(this.text.toString()));
        }
        catch (ParseException e) {
            outputVector.isNull[i] = true;
        }
        if (this.isPositive) {
            this.calendar.add(5, this.numDays);
        } else {
            this.calendar.add(5, -this.numDays);
        }
        Date newDate = this.calendar.getTime();
        this.text.set(this.formatter.format(newDate));
        byte[] bytes = this.text.getBytes();
        int size = this.text.getLength();
        outputVector.vector[i] = Arrays.copyOf(bytes, size);
        outputVector.start[i] = 0;
        outputVector.length[i] = size;
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "string";
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    public int getNumDays() {
        return this.numDays;
    }

    public void setNumDay(int numDays) {
        this.numDays = numDays;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_DATETIME_FAMILY, VectorExpressionDescriptor.ArgumentType.INT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR);
        return b.build();
    }
}

