/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.ColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.ColumnStatisticsImpl;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.Metadata;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.OrcUnion;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.StripeInformation;
import org.apache.hadoop.hive.ql.io.orc.StripeStatistics;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONWriter;

public final class FileDump {
    private static final String ROWINDEX_PREFIX = "--rowindex=";

    private FileDump() {
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        ArrayList<Integer> rowIndexCols = null;
        Options opts = FileDump.createOptions();
        CommandLine cli = new GnuParser().parse(opts, args);
        if (cli.hasOption('h')) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("orcfiledump", opts);
            return;
        }
        boolean dumpData = cli.hasOption('d');
        if (cli.hasOption("rowindex")) {
            String[] colStrs = cli.getOptionValue("rowindex").split(",");
            rowIndexCols = new ArrayList<Integer>(colStrs.length);
            for (String colStr : colStrs) {
                rowIndexCols.add(Integer.parseInt(colStr));
            }
        }
        String[] files = cli.getArgs();
        if (dumpData) {
            FileDump.printData(Arrays.asList(files), conf);
        } else {
            FileDump.printMetaData(Arrays.asList(files), conf, rowIndexCols);
        }
    }

    private static void printData(List<String> files, Configuration conf) throws IOException, JSONException {
        for (String file : files) {
            FileDump.printJsonData(conf, file);
        }
    }

    private static void printMetaData(List<String> files, Configuration conf, List<Integer> rowIndexCols) throws IOException {
        for (String filename : files) {
            System.out.println("Structure for " + filename);
            Path path = new Path(filename);
            Reader reader = OrcFile.createReader(path, OrcFile.readerOptions(conf));
            System.out.println("File Version: " + reader.getFileVersion().getName() + " with " + (Object)((Object)reader.getWriterVersion()));
            RecordReaderImpl rows = (RecordReaderImpl)reader.rows();
            System.out.println("Rows: " + reader.getNumberOfRows());
            System.out.println("Compression: " + (Object)((Object)reader.getCompression()));
            if (reader.getCompression() != CompressionKind.NONE) {
                System.out.println("Compression size: " + reader.getCompressionSize());
            }
            System.out.println("Type: " + reader.getObjectInspector().getTypeName());
            System.out.println("\nStripe Statistics:");
            Metadata metadata = reader.getMetadata();
            for (int n = 0; n < metadata.getStripeStatistics().size(); ++n) {
                System.out.println("  Stripe " + (n + 1) + ":");
                StripeStatistics ss = metadata.getStripeStatistics().get(n);
                for (int i = 0; i < ss.getColumnStatistics().length; ++i) {
                    System.out.println("    Column " + i + ": " + ss.getColumnStatistics()[i].toString());
                }
            }
            ColumnStatistics[] stats = reader.getStatistics();
            System.out.println("\nFile Statistics:");
            for (int i = 0; i < stats.length; ++i) {
                System.out.println("  Column " + i + ": " + stats[i].toString());
            }
            System.out.println("\nStripes:");
            int stripeIx = -1;
            for (StripeInformation stripe : reader.getStripes()) {
                ++stripeIx;
                long stripeStart = stripe.getOffset();
                System.out.println("  Stripe: " + stripe.toString());
                OrcProto.StripeFooter footer = rows.readStripeFooter(stripe);
                long sectionStart = stripeStart;
                for (OrcProto.Stream section : footer.getStreamsList()) {
                    String kind = section.hasKind() ? section.getKind().name() : "UNKNOWN";
                    System.out.println("    Stream: column " + section.getColumn() + " section " + kind + " start: " + sectionStart + " length " + section.getLength());
                    sectionStart += section.getLength();
                }
                for (int i = 0; i < footer.getColumnsCount(); ++i) {
                    OrcProto.ColumnEncoding encoding = footer.getColumns(i);
                    StringBuilder buf = new StringBuilder();
                    buf.append("    Encoding column ");
                    buf.append(i);
                    buf.append(": ");
                    buf.append((Object)encoding.getKind());
                    if (encoding.getKind() == OrcProto.ColumnEncoding.Kind.DICTIONARY || encoding.getKind() == OrcProto.ColumnEncoding.Kind.DICTIONARY_V2) {
                        buf.append("[");
                        buf.append(encoding.getDictionarySize());
                        buf.append("]");
                    }
                    System.out.println(buf);
                }
                if (rowIndexCols == null) continue;
                OrcProto.RowIndex[] indices = rows.readRowIndex(stripeIx);
                for (int col : rowIndexCols) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("    Row group index column ").append(col).append(":");
                    OrcProto.RowIndex index = null;
                    if (col >= indices.length || (index = indices[col]) == null) {
                        buf.append(" not found\n");
                        continue;
                    }
                    for (int entryIx = 0; entryIx < index.getEntryCount(); ++entryIx) {
                        buf.append("\n      Entry ").append(entryIx).append(":");
                        OrcProto.RowIndexEntry entry = index.getEntry(entryIx);
                        if (entry == null) {
                            buf.append("unknown\n");
                            continue;
                        }
                        OrcProto.ColumnStatistics colStats = entry.getStatistics();
                        if (colStats == null) {
                            buf.append("no stats at ");
                        } else {
                            ColumnStatisticsImpl cs = ColumnStatisticsImpl.deserialize(colStats);
                            buf.append(((Object)cs).toString());
                        }
                        buf.append(" positions: ");
                        for (int posIx = 0; posIx < entry.getPositionsCount(); ++posIx) {
                            if (posIx != 0) {
                                buf.append(",");
                            }
                            buf.append(entry.getPositions(posIx));
                        }
                    }
                    System.out.println(buf);
                }
            }
            FileSystem fs = path.getFileSystem(conf);
            long fileLen = fs.getContentSummary(path).getLength();
            long paddedBytes = FileDump.getTotalPaddingSize(reader);
            double percentPadding = (double)paddedBytes / (double)fileLen * 100.0;
            DecimalFormat format = new DecimalFormat("##.##");
            System.out.println("\nFile length: " + fileLen + " bytes");
            System.out.println("Padding length: " + paddedBytes + " bytes");
            System.out.println("Padding ratio: " + format.format(percentPadding) + "%");
            rows.close();
        }
    }

    private static long getTotalPaddingSize(Reader reader) throws IOException {
        long paddedBytes = 0L;
        List<StripeInformation> stripes = reader.getStripes();
        for (int i = 1; i < stripes.size(); ++i) {
            long prevStripeOffset = stripes.get(i - 1).getOffset();
            long prevStripeLen = stripes.get(i - 1).getLength();
            paddedBytes += stripes.get(i).getOffset() - (prevStripeOffset + prevStripeLen);
        }
        return paddedBytes;
    }

    static Options createOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"data");
        OptionBuilder.withDescription((String)"Should the data be printed");
        result.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"print help message");
        result.addOption(OptionBuilder.create((char)'h'));
        OptionBuilder.withLongOpt((String)"rowindex");
        OptionBuilder.withArgName((String)"comma separated list of column ids for which row index should be printed");
        OptionBuilder.withDescription((String)"Dump stats for column number(s)");
        OptionBuilder.hasArg();
        result.addOption(OptionBuilder.create());
        return result;
    }

    private static void printMap(JSONWriter writer, Map<Object, Object> obj, List<OrcProto.Type> types, OrcProto.Type type) throws IOException, JSONException {
        writer.array();
        int keyType = type.getSubtypes(0);
        int valueType = type.getSubtypes(1);
        for (Map.Entry<Object, Object> item : obj.entrySet()) {
            writer.object();
            writer.key("_key");
            FileDump.printObject(writer, item.getKey(), types, keyType);
            writer.key("_value");
            FileDump.printObject(writer, item.getValue(), types, valueType);
            writer.endObject();
        }
        writer.endArray();
    }

    private static void printList(JSONWriter writer, List<Object> obj, List<OrcProto.Type> types, OrcProto.Type type) throws IOException, JSONException {
        int subtype = type.getSubtypes(0);
        writer.array();
        for (Object item : obj) {
            FileDump.printObject(writer, item, types, subtype);
        }
        writer.endArray();
    }

    private static void printUnion(JSONWriter writer, OrcUnion obj, List<OrcProto.Type> types, OrcProto.Type type) throws IOException, JSONException {
        int subtype = type.getSubtypes(obj.getTag());
        FileDump.printObject(writer, obj.getObject(), types, subtype);
    }

    static void printStruct(JSONWriter writer, OrcStruct obj, List<OrcProto.Type> types, OrcProto.Type type) throws IOException, JSONException {
        writer.object();
        List<Integer> fieldTypes = type.getSubtypesList();
        for (int i = 0; i < fieldTypes.size(); ++i) {
            writer.key(type.getFieldNames(i));
            FileDump.printObject(writer, obj.getFieldValue(i), types, fieldTypes.get(i));
        }
        writer.endObject();
    }

    static void printObject(JSONWriter writer, Object obj, List<OrcProto.Type> types, int typeId) throws IOException, JSONException {
        OrcProto.Type type = types.get(typeId);
        if (obj == null) {
            writer.value(null);
        } else {
            switch (type.getKind()) {
                case STRUCT: {
                    FileDump.printStruct(writer, (OrcStruct)obj, types, type);
                    break;
                }
                case UNION: {
                    FileDump.printUnion(writer, (OrcUnion)obj, types, type);
                    break;
                }
                case LIST: {
                    FileDump.printList(writer, (List)obj, types, type);
                    break;
                }
                case MAP: {
                    FileDump.printMap(writer, (Map)obj, types, type);
                    break;
                }
                case BYTE: {
                    writer.value((long)((ByteWritable)obj).get());
                    break;
                }
                case SHORT: {
                    writer.value((long)((ShortWritable)obj).get());
                    break;
                }
                case INT: {
                    writer.value((long)((IntWritable)obj).get());
                    break;
                }
                case LONG: {
                    writer.value(((LongWritable)obj).get());
                    break;
                }
                case FLOAT: {
                    writer.value((double)((FloatWritable)obj).get());
                    break;
                }
                case DOUBLE: {
                    writer.value(((DoubleWritable)obj).get());
                    break;
                }
                case BOOLEAN: {
                    writer.value(((BooleanWritable)obj).get());
                    break;
                }
                default: {
                    writer.value((Object)obj.toString());
                }
            }
        }
    }

    static void printJsonData(Configuration conf, String filename) throws IOException, JSONException {
        Path path = new Path(filename);
        Reader reader = OrcFile.createReader(path.getFileSystem(conf), path);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)System.out, "UTF-8");
        RecordReader rows = reader.rows(null);
        Object row = null;
        List<OrcProto.Type> types = reader.getTypes();
        while (rows.hasNext()) {
            row = rows.next(row);
            JSONWriter writer = new JSONWriter((Writer)out);
            FileDump.printObject(writer, row, types, 0);
            out.write("\n");
            out.flush();
        }
    }
}

