/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import com.google.protobuf.CodedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.ColumnStatistics;
import org.apache.hadoop.hive.ql.io.orc.ColumnStatisticsImpl;
import org.apache.hadoop.hive.ql.io.orc.CompressionCodec;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.InStream;
import org.apache.hadoop.hive.ql.io.orc.Metadata;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.hadoop.hive.ql.io.orc.StripeInformation;
import org.apache.hadoop.hive.ql.io.orc.WriterImpl;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.Text;
import org.spark_project.guava.collect.Lists;
import org.spark_project.guava.collect.Sets;

final class ReaderImpl
implements Reader {
    private static final Log LOG = LogFactory.getLog(ReaderImpl.class);
    private static final int DIRECTORY_SIZE_GUESS = 16384;
    private final FileSystem fileSystem;
    private final Path path;
    private final CompressionKind compressionKind;
    private final CompressionCodec codec;
    private final int bufferSize;
    private OrcProto.Metadata metadata = null;
    private final int metadataSize;
    private final OrcProto.Footer footer;
    private final ObjectInspector inspector;
    private long deserializedSize = -1L;
    private final Configuration conf;
    private final List<Integer> versionList;
    private final OrcFile.WriterVersion writerVersion;
    private final ByteBuffer footerByteBuffer;

    @Override
    public long getNumberOfRows() {
        return this.footer.getNumberOfRows();
    }

    @Override
    public List<String> getMetadataKeys() {
        ArrayList<String> result = new ArrayList<String>();
        for (OrcProto.UserMetadataItem item : this.footer.getMetadataList()) {
            result.add(item.getName());
        }
        return result;
    }

    @Override
    public ByteBuffer getMetadataValue(String key) {
        for (OrcProto.UserMetadataItem item : this.footer.getMetadataList()) {
            if (!item.hasName() || !item.getName().equals(key)) continue;
            return item.getValue().asReadOnlyByteBuffer();
        }
        throw new IllegalArgumentException("Can't find user metadata " + key);
    }

    @Override
    public boolean hasMetadataValue(String key) {
        for (OrcProto.UserMetadataItem item : this.footer.getMetadataList()) {
            if (!item.hasName() || !item.getName().equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CompressionKind getCompression() {
        return this.compressionKind;
    }

    @Override
    public int getCompressionSize() {
        return this.bufferSize;
    }

    @Override
    public List<StripeInformation> getStripes() {
        ArrayList<StripeInformation> result = new ArrayList<StripeInformation>();
        for (OrcProto.StripeInformation info : this.footer.getStripesList()) {
            result.add(new StripeInformationImpl(info));
        }
        return result;
    }

    @Override
    public ObjectInspector getObjectInspector() {
        return this.inspector;
    }

    @Override
    public long getContentLength() {
        return this.footer.getContentLength();
    }

    @Override
    public List<OrcProto.Type> getTypes() {
        return this.footer.getTypesList();
    }

    @Override
    public OrcFile.Version getFileVersion() {
        for (OrcFile.Version version : OrcFile.Version.values()) {
            if (version.getMajor() != this.versionList.get(0).intValue() || version.getMinor() != this.versionList.get(1).intValue()) continue;
            return version;
        }
        return OrcFile.Version.V_0_11;
    }

    @Override
    public OrcFile.WriterVersion getWriterVersion() {
        return this.writerVersion;
    }

    @Override
    public int getRowIndexStride() {
        return this.footer.getRowIndexStride();
    }

    @Override
    public ColumnStatistics[] getStatistics() {
        ColumnStatistics[] result = new ColumnStatistics[this.footer.getTypesCount()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = ColumnStatisticsImpl.deserialize(this.footer.getStatistics(i));
        }
        return result;
    }

    static void ensureOrcFooter(FSDataInputStream in, Path path, int psLen, ByteBuffer buffer) throws IOException {
        int len = "ORC".length();
        if (psLen < len + 1) {
            throw new IOException("Malformed ORC file " + path + ". Invalid postscript length " + psLen);
        }
        int offset = buffer.arrayOffset() + buffer.position() + buffer.limit() - 1 - len;
        byte[] array = buffer.array();
        if (!Text.decode((byte[])array, (int)offset, (int)len).equals("ORC")) {
            in.seek(0L);
            byte[] header = new byte[len];
            in.readFully(header, 0, len);
            if (!Text.decode((byte[])header, (int)0, (int)len).equals("ORC")) {
                throw new IOException("Malformed ORC file " + path + ". Invalid postscript.");
            }
        }
    }

    private static String versionString(List<Integer> version) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < version.size(); ++i) {
            if (i != 0) {
                buffer.append('.');
            }
            buffer.append(version.get(i));
        }
        return buffer.toString();
    }

    static void checkOrcVersion(Log log, Path path, List<Integer> version) {
        if (version.size() >= 1) {
            int major = version.get(0);
            int minor = 0;
            if (version.size() >= 2) {
                minor = version.get(1);
            }
            if (major > OrcFile.Version.CURRENT.getMajor() || major == OrcFile.Version.CURRENT.getMajor() && minor > OrcFile.Version.CURRENT.getMinor()) {
                log.warn((Object)("ORC file " + path + " was written by a future Hive version " + ReaderImpl.versionString(version) + ". This file may not be readable by this version of Hive."));
            }
        }
    }

    ReaderImpl(Path path, OrcFile.ReaderOptions options) throws IOException {
        FileSystem fs = options.getFilesystem();
        if (fs == null) {
            fs = path.getFileSystem(options.getConfiguration());
        }
        this.fileSystem = fs;
        this.path = path;
        this.conf = options.getConfiguration();
        FileMetaInfo footerMetaData = options.getFileMetaInfo() != null ? options.getFileMetaInfo() : ReaderImpl.extractMetaInfoFromFooter(fs, path, options.getMaxLength());
        MetaInfoObjExtractor rInfo = new MetaInfoObjExtractor(footerMetaData.compressionType, footerMetaData.bufferSize, footerMetaData.metadataSize, footerMetaData.footerBuffer);
        this.footerByteBuffer = footerMetaData.footerBuffer;
        this.compressionKind = rInfo.compressionKind;
        this.codec = rInfo.codec;
        this.bufferSize = rInfo.bufferSize;
        this.metadataSize = rInfo.metadataSize;
        this.metadata = rInfo.metadata;
        this.footer = rInfo.footer;
        this.inspector = rInfo.inspector;
        this.versionList = footerMetaData.versionList;
        this.writerVersion = footerMetaData.writerVersion;
    }

    static OrcFile.WriterVersion getWriterVersion(int writerVersion) {
        for (OrcFile.WriterVersion version : OrcFile.WriterVersion.values()) {
            if (version.getId() != writerVersion) continue;
            return version;
        }
        return OrcFile.WriterVersion.ORIGINAL;
    }

    private static FileMetaInfo extractMetaInfoFromFooter(FileSystem fs, Path path, long maxFileLength) throws IOException {
        FSDataInputStream file = fs.open(path);
        long size = maxFileLength == Long.MAX_VALUE ? fs.getFileStatus(path).getLen() : maxFileLength;
        int readSize = (int)Math.min(size, 16384L);
        file.seek(size - (long)readSize);
        ByteBuffer buffer = ByteBuffer.allocate(readSize);
        file.readFully(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        int psLen = buffer.get(readSize - 1) & 0xFF;
        ReaderImpl.ensureOrcFooter(file, path, psLen, buffer);
        int psOffset = readSize - 1 - psLen;
        CodedInputStream in = CodedInputStream.newInstance((byte[])buffer.array(), (int)(buffer.arrayOffset() + psOffset), (int)psLen);
        OrcProto.PostScript ps = OrcProto.PostScript.parseFrom(in);
        ReaderImpl.checkOrcVersion(LOG, path, ps.getVersionList());
        int footerSize = (int)ps.getFooterLength();
        int metadataSize = (int)ps.getMetadataLength();
        OrcFile.WriterVersion writerVersion = ps.hasWriterVersion() ? ReaderImpl.getWriterVersion(ps.getWriterVersion()) : OrcFile.WriterVersion.ORIGINAL;
        switch (ps.getCompression()) {
            case NONE: {
                break;
            }
            case ZLIB: {
                break;
            }
            case SNAPPY: {
                break;
            }
            case LZO: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown compression");
            }
        }
        int extra = Math.max(0, psLen + 1 + footerSize + metadataSize - readSize);
        if (extra > 0) {
            file.seek(size - (long)readSize - (long)extra);
            ByteBuffer extraBuf = ByteBuffer.allocate(extra + readSize);
            file.readFully(extraBuf.array(), extraBuf.arrayOffset() + extraBuf.position(), extra);
            extraBuf.position(extra);
            extraBuf.put(buffer);
            buffer = extraBuf;
            buffer.position(0);
            buffer.limit(footerSize + metadataSize);
        } else {
            buffer.position(psOffset - footerSize - metadataSize);
            buffer.limit(psOffset);
        }
        buffer.mark();
        file.close();
        return new FileMetaInfo(ps.getCompression().toString(), (int)ps.getCompressionBlockSize(), (int)ps.getMetadataLength(), buffer, ps.getVersionList(), writerVersion);
    }

    public FileMetaInfo getFileMetaInfo() {
        return new FileMetaInfo(this.compressionKind.toString(), this.bufferSize, this.metadataSize, this.footerByteBuffer, this.versionList, this.writerVersion);
    }

    @Override
    public RecordReader rows() throws IOException {
        return this.rowsOptions(new Reader.Options());
    }

    @Override
    public RecordReader rowsOptions(Reader.Options options) throws IOException {
        LOG.info((Object)("Reading ORC rows from " + this.path + " with " + options));
        boolean[] include = options.getInclude();
        if (include == null) {
            include = new boolean[this.footer.getTypesCount()];
            Arrays.fill(include, true);
            options.include(include);
        }
        return new RecordReaderImpl(this.getStripes(), this.fileSystem, this.path, options, this.footer.getTypesList(), this.codec, this.bufferSize, this.footer.getRowIndexStride(), this.conf);
    }

    @Override
    public RecordReader rows(boolean[] include) throws IOException {
        return this.rowsOptions(new Reader.Options().include(include));
    }

    @Override
    public RecordReader rows(long offset, long length, boolean[] include) throws IOException {
        return this.rowsOptions(new Reader.Options().include(include).range(offset, length));
    }

    @Override
    public RecordReader rows(long offset, long length, boolean[] include, SearchArgument sarg, String[] columnNames) throws IOException {
        return this.rowsOptions(new Reader.Options().include(include).range(offset, length).searchArgument(sarg, columnNames));
    }

    @Override
    public long getRawDataSize() {
        if (this.deserializedSize == -1L) {
            List<OrcProto.ColumnStatistics> stats = this.footer.getStatisticsList();
            ArrayList indices = Lists.newArrayList();
            for (int i = 0; i < stats.size(); ++i) {
                indices.add(i);
            }
            this.deserializedSize = this.getRawDataSizeFromColIndices(indices);
        }
        return this.deserializedSize;
    }

    private long getRawDataSizeFromColIndices(List<Integer> colIndices) {
        long result = 0L;
        for (int colIdx : colIndices) {
            result += this.getRawDataSizeOfColumn(colIdx);
        }
        return result;
    }

    private long getRawDataSizeOfColumn(int colIdx) {
        OrcProto.ColumnStatistics colStat = this.footer.getStatistics(colIdx);
        long numVals = colStat.getNumberOfValues();
        OrcProto.Type type = this.footer.getTypes(colIdx);
        switch (type.getKind()) {
            case BINARY: {
                return colStat.getBinaryStatistics().getSum();
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                numVals = numVals == 0L ? 1L : numVals;
                int avgStrLen = (int)(colStat.getStringStatistics().getSum() / numVals);
                return numVals * (long)JavaDataModel.get().lengthForStringOfLength(avgStrLen);
            }
            case TIMESTAMP: {
                return numVals * (long)JavaDataModel.get().lengthOfTimestamp();
            }
            case DATE: {
                return numVals * (long)JavaDataModel.get().lengthOfDate();
            }
            case DECIMAL: {
                return numVals * (long)JavaDataModel.get().lengthOfDecimal();
            }
            case DOUBLE: 
            case LONG: {
                return numVals * (long)JavaDataModel.get().primitive2();
            }
            case FLOAT: 
            case INT: 
            case SHORT: 
            case BOOLEAN: 
            case BYTE: {
                return numVals * (long)JavaDataModel.get().primitive1();
            }
        }
        LOG.debug((Object)"Unknown primitive category.");
        return 0L;
    }

    @Override
    public long getRawDataSizeOfColumns(List<String> colNames) {
        List<Integer> colIndices = this.getColumnIndicesFromNames(colNames);
        return this.getRawDataSizeFromColIndices(colIndices);
    }

    private List<Integer> getColumnIndicesFromNames(List<String> colNames) {
        OrcProto.Type type = this.footer.getTypesList().get(0);
        ArrayList colIndices = Lists.newArrayList();
        List<String> fieldNames = type.getFieldNamesList();
        int fieldIdx = 0;
        for (String colName : colNames) {
            int idxEnd;
            int idxStart;
            if (fieldNames.contains(colName)) {
                fieldIdx = fieldNames.indexOf(colName);
            }
            if ((idxStart = type.getSubtypes(fieldIdx)) == (idxEnd = fieldIdx + 1 > fieldNames.size() - 1 ? this.getLastIdx() + 1 : type.getSubtypes(fieldIdx + 1))) {
                colIndices.add(idxStart);
                continue;
            }
            for (int i = idxStart; i < idxEnd; ++i) {
                colIndices.add(i);
            }
        }
        return colIndices;
    }

    private int getLastIdx() {
        HashSet indices = Sets.newHashSet();
        for (OrcProto.Type type : this.footer.getTypesList()) {
            indices.addAll(type.getSubtypesList());
        }
        return (Integer)Collections.max(indices);
    }

    @Override
    public Metadata getMetadata() throws IOException {
        return new Metadata(this.metadata);
    }

    List<OrcProto.StripeStatistics> getOrcProtoStripeStatistics() {
        return this.metadata.getStripeStatsList();
    }

    public List<OrcProto.UserMetadataItem> getOrcProtoUserMetadata() {
        return this.footer.getMetadataList();
    }

    static class FileMetaInfo {
        final String compressionType;
        final int bufferSize;
        final int metadataSize;
        final ByteBuffer footerBuffer;
        final List<Integer> versionList;
        final OrcFile.WriterVersion writerVersion;

        FileMetaInfo(String compressionType, int bufferSize, int metadataSize, ByteBuffer footerBuffer, OrcFile.WriterVersion writerVersion) {
            this(compressionType, bufferSize, metadataSize, footerBuffer, null, writerVersion);
        }

        FileMetaInfo(String compressionType, int bufferSize, int metadataSize, ByteBuffer footerBuffer, List<Integer> versionList, OrcFile.WriterVersion writerVersion) {
            this.compressionType = compressionType;
            this.bufferSize = bufferSize;
            this.metadataSize = metadataSize;
            this.footerBuffer = footerBuffer;
            this.versionList = versionList;
            this.writerVersion = writerVersion;
        }
    }

    private static class MetaInfoObjExtractor {
        final CompressionKind compressionKind;
        final CompressionCodec codec;
        final int bufferSize;
        final int metadataSize;
        final OrcProto.Metadata metadata;
        final OrcProto.Footer footer;
        final ObjectInspector inspector;

        MetaInfoObjExtractor(String codecStr, int bufferSize, int metadataSize, ByteBuffer footerBuffer) throws IOException {
            this.compressionKind = CompressionKind.valueOf(codecStr);
            this.bufferSize = bufferSize;
            this.codec = WriterImpl.createCodec(this.compressionKind);
            this.metadataSize = metadataSize;
            int position = footerBuffer.position();
            int footerBufferSize = footerBuffer.limit() - footerBuffer.position() - metadataSize;
            footerBuffer.limit(position + metadataSize);
            InStream instream = InStream.create("metadata", new ByteBuffer[]{footerBuffer}, new long[]{0L}, metadataSize, this.codec, bufferSize);
            this.metadata = OrcProto.Metadata.parseFrom(instream);
            footerBuffer.position(position + metadataSize);
            footerBuffer.limit(position + metadataSize + footerBufferSize);
            instream = InStream.create("footer", new ByteBuffer[]{footerBuffer}, new long[]{0L}, footerBufferSize, this.codec, bufferSize);
            this.footer = OrcProto.Footer.parseFrom(instream);
            footerBuffer.position(position);
            this.inspector = OrcStruct.createObjectInspector(0, this.footer.getTypesList());
        }
    }

    static class StripeInformationImpl
    implements StripeInformation {
        private final OrcProto.StripeInformation stripe;

        StripeInformationImpl(OrcProto.StripeInformation stripe) {
            this.stripe = stripe;
        }

        @Override
        public long getOffset() {
            return this.stripe.getOffset();
        }

        @Override
        public long getLength() {
            return this.stripe.getDataLength() + this.getIndexLength() + this.getFooterLength();
        }

        @Override
        public long getDataLength() {
            return this.stripe.getDataLength();
        }

        @Override
        public long getFooterLength() {
            return this.stripe.getFooterLength();
        }

        @Override
        public long getIndexLength() {
            return this.stripe.getIndexLength();
        }

        @Override
        public long getNumberOfRows() {
            return this.stripe.getNumberOfRows();
        }

        public String toString() {
            return "offset: " + this.getOffset() + " data: " + this.getDataLength() + " rows: " + this.getNumberOfRows() + " tail: " + this.getFooterLength() + " index: " + this.getIndexLength();
        }
    }
}

